/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.util.MetaEntityUtil;

public class VoucherFilterEdit
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
        FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
        fg.addBeforeF7SelectListener(evt -> this.beforeSelect(evt));
    }

    private void beforeSelect(BeforeFilterF7SelectEvent evt) {
        List filters = evt.getQfilters();
        if (Voucher.join((String[])new String[]{"period", "number"}).equals(evt.getFieldName())) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String param = (String)showParam.getCustomParam("periodtype");
            if (StringUtils.isNotEmpty((String)param)) {
                Long periodTypeId = Long.valueOf(param);
                filters.add(new QFilter("periodtype.id", "=", (Object)periodTypeId));
            }
        } else if (Voucher.join((String[])new String[]{"account", "number"}).equals(evt.getFieldName())) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            Long param = Long.parseLong(showParam.getCustomParam("srcacctable") + "");
            if (param != 0L) {
                filters.add(new QFilter("accounttable.id", "=", (Object)param));
            }
            Long orgId = Long.parseLong(showParam.getCustomParam("org") + "");
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        } else if ("vouchertype.number".equals(evt.getFieldName())) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            Long orgId = Long.parseLong(showParam.getCustomParam("org") + "");
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterGrid();
    }

    public void afterBindData(EventObject e) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String json = (String)showParam.getCustomParam("voucherfilterjson");
        if (StringUtils.isNotEmpty((String)json)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
            fg.SetValue(fc);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
            FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
            FilterCondition fc = fg.getFilterGridState().getFilterCondition();
            FilterBuilder filterBuilder = new FilterBuilder(entityType, fc, false);
            filterBuilder.buildFilter(false);
            String filterStr = filterBuilder.getFilterString();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("voucherfilter", filterStr);
            dataMap.put("voucherfilterjson", SerializationUtils.toJsonString((Object)fc));
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        }
    }

    private void initFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("gl_voucher");
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Boolean reciprocalSchemeField = (Boolean)showParam.getCustomParam("reciprocalschemefield");
        if (reciprocalSchemeField != null && reciprocalSchemeField.booleanValue()) {
            this.setRCPVoucherFilterFields(filterGrid);
        } else {
            this.setVoucherFilterFields(filterGrid);
        }
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(32);
        filterFileds.add(Voucher.join((String[])new String[]{"org", "number"}));
        filterFileds.add("billno");
        filterFileds.add(Voucher.join((String[])new String[]{"vouchertype", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"period", "number"}));
        filterFileds.add("bookeddate");
        filterFileds.add("ispost");
        filterFileds.add(Voucher.join((String[])new String[]{"account", "number"}));
        filterFileds.add("edescription");
        filterFileds.add("sourcetype");
        filterFileds.add("sourcesys");
        filterFileds.add(Voucher.join((String[])new String[]{"currency", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"creator", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"auditor", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"cashier", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"poster", "number"}));
        filterFileds.add("debitlocal");
        filterFileds.add("creditlocal");
        filterFileds.add("description");
        filterFileds.add("sourcetype");
        filterFileds.add(Voucher.join((String[])new String[]{"sourcesys", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"booktype", "number"}));
        filterFileds.add("ischeck");
        filterFileds.addAll(MetaEntityUtil.getAllHeadExpandFields());
        filterFileds.addAll(MetaEntityUtil.getAllEntryExpandFields());
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    private void setRCPVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(16);
        filterFileds.add("billno");
        filterFileds.add(Voucher.join((String[])new String[]{"vouchertype", "number"}));
        filterFileds.add("businessnum");
        filterFileds.add("bookeddate");
        filterFileds.add("ispost");
        filterFileds.add("edescription");
        filterFileds.add(Voucher.join((String[])new String[]{"creator", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"auditor", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"cashier", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"poster", "number"}));
        filterFileds.add("debitlocal");
        filterFileds.add("creditlocal");
        filterFileds.add("description");
        filterFileds.add("sourcetype");
        filterFileds.add(Voucher.join((String[])new String[]{"sourcesys", "number"}));
        filterFileds.add("ischeck");
        filterGrid.setFilterFieldKeys(filterFileds);
    }
}

