/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.accountbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.metadata.edit.AccountEdit;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.AccountBookUtil;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.util.AccountBookHelper;

public class GLAccountBook
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(GLAccountBook.class);
    private static final String MULTIPLECHOICEORG = "multiplechoiceorg";
    public static final String ACCOUNTING_SYS = "accountingsys";
    public static final String ACCOUNTINGSYS_FORMID = "bd_accountingsys";
    private static final String GL_VOUCHER_TYPE = "gl_vouchertype";
    private static final String[] BIZSTR = new String[]{"startperiod", "cashinitperiod"};
    private static final String[] REFSTR = new String[]{"org", "multiplechoiceorg", "bookstype", "accounttable", "basecurrency", "exratetable", "periodtype", "startperiod", "curperiod", "accountingsys"};
    private static final String ID = "id";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String OTHER_APP_BOOK = "OTHER_APP_BOOK";
    private static final String BOOK_IMPORT_KEY = "book_import";
    private static final String BOOK_UPDATEIMPORT_KEY = "book_updateimport";

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType mainEntityType;
        MainEntityType originalEntityType = e.getOriginalEntityType();
        try {
            mainEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            throw new KDBizException((Throwable)exp, BosErrorCode.systemError, new Object[0]);
        }
        this.modifyRelatedBookFieldProp(this.getModel().getEntryCurrentRowIndex("b_entry"), mainEntityType);
        e.setNewEntityType(mainEntityType);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        BasedataEdit multiSelect = (BasedataEdit)this.getControl(MULTIPLECHOICEORG);
        multiSelect.addBeforeF7SelectListener(evt -> {
            Set<Object> orgInfos = this.getOrgInfo((DynamicObject)model.getValue(ACCOUNTING_SYS));
            Set<Long> permissionOrgs = this.getPermissionOrg();
            if (!permissionOrgs.isEmpty()) {
                orgInfos.retainAll(permissionOrgs);
            }
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter(ID, "in", orgInfos));
        });
        BasedataEdit sysBase = (BasedataEdit)this.getControl(ACCOUNTING_SYS);
        sysBase.addBeforeF7SelectListener(evt -> {
            Set<Long> sys = this.getMainViewId();
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter(ID, "in", sys));
        });
        Object periodType = model.getValue("periodtype_id");
        BasedataEdit startPerBase = (BasedataEdit)this.getControl("startperiod");
        startPerBase.addBeforeF7SelectListener(evt -> ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("periodtype", "=", periodType)));
        BasedataEdit currPerBase = (BasedataEdit)this.getControl("curperiod");
        currPerBase.addBeforeF7SelectListener(evt -> ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("periodtype", "=", periodType)));
        BasedataEdit cashflowInitPerBase = (BasedataEdit)this.getControl("cashinitperiod");
        cashflowInitPerBase.addBeforeF7SelectListener(evt -> {
            long curPeriod = (Long)model.getValue("curperiod_id");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("periodtype", "=", periodType));
            QFilter periodFilter = new QFilter(ID, ">=", (Object)curPeriod);
            filters.add(periodFilter);
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(filters);
        });
        BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
        accountTableEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getControl(MULTIPLECHOICEORG).getModel().getDataEntity().get(MULTIPLECHOICEORG);
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject org : orgs) {
                orgIds.add((Long)org.get(FBASEDATAID_ID));
            }
            List<Long> ids = this.getAccountTableF7Filter(orgIds);
            if (!ids.isEmpty()) {
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter(ID, "in", ids));
            }
        });
        AccountEdit profitAccount = (AccountEdit)this.getControl("yearprofitacct");
        profitAccount.addBeforeF7SelectListener(evt -> {
            QFilter filter;
            List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            DynamicObject accountTable = (DynamicObject)this.getModel().getValue("accounttable");
            if (accountTable != null) {
                qFilters.add(new QFilter("accounttable", "=", accountTable.getPkValue()));
            }
            if ((filter = this.getOrgFilter("bd_accountview")) != null) {
                qFilters.add(filter);
            }
            qFilters.add(new QFilter("accounttype.accounttype", "=", (Object)"2"));
            qFilters.add(new QFilter("ischangecurrency", "=", (Object)"0"));
        });
        BasedataEdit defaultVoucherType = (BasedataEdit)this.getControl("defaultvouchertype");
        defaultVoucherType.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            QFilter filter = this.getOrgFilter(GL_VOUCHER_TYPE);
            if (filter != null) {
                qFilters.add(filter);
            }
        });
        this.modifyRelatedBookFieldProp(this.getModel().getEntryCurrentRowIndex("b_entry"), this.getModel().getDataEntityType());
        MulBasedataEdit relateBizReal = (MulBasedataEdit)this.getControl("b_relatebook");
        relateBizReal.addBeforeF7SelectListener(evt -> this.validateRelateBookRealF7(evt));
        MulBasedataEdit relateOrg = (MulBasedataEdit)this.getControl("o_relateorg");
        relateOrg.addBeforeF7SelectListener(evt -> this.validateRelateOrgF7(evt));
        BasedataEdit bapp = (BasedataEdit)this.getControl("b_app");
        bapp.addBeforeF7SelectListener(evt -> this.setBappF7Filter(evt, "b_entry", "b_app"));
        BasedataEdit oapp = (BasedataEdit)this.getControl("o_app");
        oapp.addBeforeF7SelectListener(evt -> this.setBappF7Filter(evt, "o_entry", "o_app"));
    }

    private List<Long> getAccountTableF7Filter(List<Long> orgIds) {
        ArrayList<Long> ids = new ArrayList<Long>(32);
        List<Long> orgs = this.getAllSuperiorOrgIds(orgIds, true);
        if (!orgIds.isEmpty()) {
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)ID, (QFilter[])new QFilter("org", "in", orgs).toArray(), null);){
                for (Row row : dSet) {
                    ids.add(row.getLong(ID));
                }
            }
        }
        return ids;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{MULTIPLECHOICEORG});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountbookinfo", "relevancebusiness", "org", "bookstype", "textfield3", MULTIPLECHOICEORG});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"org"});
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        BasedataEdit multiplechoiceorg = (BasedataEdit)this.getControl(MULTIPLECHOICEORG);
        this.getView().setVisible(Boolean.TRUE, new String[]{MULTIPLECHOICEORG});
        this.getView().setVisible(Boolean.FALSE, new String[]{"org"});
        multiplechoiceorg.setMustInput(Boolean.TRUE.booleanValue());
        model.setValue("org", null);
        model.setValue("isendinit", (Object)false);
        model.setValue("isendinitcashflow", (Object)false);
        model.setValue("cashinitperiod", null);
        model.setValue("localset", (Object)false);
        model.setValue("localsetdate", null);
        BasedataEdit bookstype = (BasedataEdit)this.getControl("bookstype");
        bookstype.setMustInput(true);
        model.setValue("enablemullocalcur", (Object)false);
        this.cleanMulLocalCurrencyFieldsValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MULTIPLECHOICEORG});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"org"});
            TextEdit edit = (TextEdit)this.getView().getControl("number");
            edit.setMustInput(true);
            Object bookId = this.getModel().getValue(ID);
            if (!Objects.equals(bookId, 0L)) {
                boolean isBiz;
                DynamicObjectCollection orgs = new DynamicObjectCollection();
                orgs.add((Object)((DynamicObject)model.getValue("org")));
                model.beginInit();
                model.setValue(MULTIPLECHOICEORG, (Object)orgs);
                model.endInit();
                QFilter[] qf = new QFilter[]{new QFilter(ACCOUNTING_SYS, "=", model.getValue("accountingsys_id")), new QFilter("ismainview", "=", (Object)"1")};
                DynamicObject mainSys = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)ID, (QFilter[])qf);
                if (mainSys != null) {
                    this.getPageCache().put("mainView", mainSys.getString(ID));
                    this.judgeIsLeaf(model, model.getValue("org_id"));
                }
                boolean bl = isBiz = (Boolean)model.getValue("isbizunit") == false;
                if (isBiz) {
                    this.getView().setEnable(Boolean.valueOf(false), BIZSTR);
                }
                boolean isInitBalances = this.checkInitBalances(model);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"curperiod"});
                if (((Boolean)model.getValue("isendinit")).booleanValue() || isInitBalances) {
                    this.getView().setEnable(Boolean.valueOf(false), REFSTR);
                }
                QFilter typeQF = new QFilter("booktype", "=", model.getValue("bookstype_id"));
                QFilter orgQF = new QFilter("org", "=", model.getValue("org_id"));
                boolean isBookVersioned = QueryServiceHelper.exists((String)"gl_book_version", (QFilter[])new QFilter[]{typeQF, orgQF});
                if (isInitBalances || isBookVersioned || QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{typeQF, orgQF})) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"accounttable"});
                }
                model.getValue("enable");
                if (!"1".equals(model.getValue("enable"))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"conentpanel"});
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bookstype", "org", MULTIPLECHOICEORG, ACCOUNTING_SYS});
            }
            model.setDataChanged(false);
            if (AccountBookUtil.isHaveBiz(Collections.singletonList((Long)model.getValue(ID)))) {
                this.lockMulLocalCurrencyFields();
            }
        }
        this.setRelateBookEntry();
        this.setEnableMulCurrency();
        this.showMulLocalCurrencyFields((Boolean)model.getValue("enablemullocalcur"));
    }

    private long getOrgId() {
        return (Long)this.getModel().getValue("org_id");
    }

    private long getBookTypeId() {
        return (Long)this.getModel().getValue("bookstype_id");
    }

    private boolean checkInitBalances(IDataModel model) {
        QFilter typeQF = new QFilter("booktype", "=", model.getValue("bookstype_id"));
        QFilter orgQF = new QFilter("org", "=", model.getValue("org_id"));
        QFilter delQF = new QFilter("isdeleted", "=", (Object)false);
        boolean isInit = QueryServiceHelper.exists((String)"gl_initbalance", (QFilter[])new QFilter[]{typeQF, orgQF, delQF});
        AccountBookInfo bookInfo = new AccountBookInfo(Long.parseLong(model.getValue(ID) + ""));
        DataSet ds = ReciprocalInitUtils.queryAllEndInitReciprocalInit((Long)bookInfo.getOrgId(), (Long)bookInfo.getBookTypeId(), (Long)bookInfo.getAccountTableId());
        HashMap<String, Long> booktypeIdMap = new HashMap<String, Long>(1);
        booktypeIdMap.put("var", bookInfo.getBookTypeId());
        ds = ds.filter("isendinit != null and booktype = var", booktypeIdMap);
        return isInit || ds.hasNext();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GLAccountBook_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        if (ACCOUNTING_SYS.equals(propertyName) && changeData[0].getOldValue() != null && changeData[0].getNewValue() != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6838\u7b97\u4f53\u7cfb\u4f1a\u6e05\u7a7a\u6570\u636e\u3002", (String)"GLAccountBook_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ACCOUNTING_SYS, (IFormPlugin)this));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        if (ACCOUNTING_SYS.equals(propertyName) && (value = changeData[0].getNewValue()) != null) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountbookinfo", "relevancebusiness", "number", "org", "bookstype", MULTIPLECHOICEORG});
            BasedataEdit multiplechoiceorg = (BasedataEdit)this.getControl(MULTIPLECHOICEORG);
            multiplechoiceorg.setMustInput(Boolean.TRUE.booleanValue());
            BasedataEdit bookstype = (BasedataEdit)this.getControl("bookstype");
            bookstype.setMustInput(true);
            Set<Object> orgInfo = this.getOrgInfo((DynamicObject)this.getModel().getValue(ACCOUNTING_SYS));
            Set<Long> permissionOrg = this.getPermissionOrg();
            if (!permissionOrg.isEmpty()) {
                orgInfo.retainAll(permissionOrg);
            }
            if (orgInfo.size() == 1) {
                long orgId = 0L;
                for (Object org : orgInfo) {
                    orgId = Long.parseLong(String.valueOf(org));
                }
                this.getModel().setValue("org", (Object)orgId);
            }
        }
        if (MULTIPLECHOICEORG.equals(propertyName)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)changeData[0].getNewValue();
            IDataModel model = this.getModel();
            if (!orgs.isEmpty()) {
                if (orgs.size() == 1) {
                    this.orgChange(((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid"));
                    this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
                    long selectOrgId = ((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getLong(ID);
                    this.setCurrencyANdExtrate(selectOrgId);
                } else {
                    model.setValue("basecurrency", null);
                    model.setValue("exratetable", null);
                    model.setValue("number", (Object)" ");
                    this.getView().setEnable(Boolean.TRUE, new String[]{"startperiod", "curperiod", "relevancebusiness"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                    ((BasedataEdit)this.getControl("startperiod")).setMustInput(Optional.ofNullable(this.getPageCache().get("mainView")).map(viewIdStr -> orgs.stream().anyMatch(org -> OrgServiceHelper.isLeaf((long)((Long)org.getDynamicObject(1).getPkValue()), (long)Long.parseLong(viewIdStr)))).orElseGet(() -> false).booleanValue());
                }
            }
        }
        if ("periodtype".equals(propertyName)) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("curperiod", null);
            this.getModel().setValue("cashinitperiod", null);
        }
        if ("startperiod".equals(propertyName) && (value = changeData[0].getNewValue()) != null) {
            DynamicObject period = (DynamicObject)value;
            this.getModel().setValue("curperiod", period.getPkValue());
        }
        String viewStatus = this.getView().getFormShowParameter().getStatus().name();
        if ("org".equals(propertyName) && "EDIT".equalsIgnoreCase(viewStatus)) {
            this.getModel().setValue("yearprofitacct", null);
        }
        if (MULTIPLECHOICEORG.equals(propertyName) && "ADDNEW".equalsIgnoreCase(viewStatus)) {
            this.getModel().setValue("yearprofitacct", null);
        }
        if ("accounttable".equals(propertyName)) {
            this.getModel().setValue("yearprofitacct", null);
        }
        if ("b_app".equals(propertyName)) {
            this.getModel().setValue("b_relatebook", null, changeData[0].getRowIndex());
        }
        if ("o_app".equals(propertyName)) {
            this.getModel().setValue("o_relateorg", null, changeData[0].getRowIndex());
        }
        if ("b_relatebook".equals(propertyName)) {
            // empty if block
        }
        if ("enablemullocalcur".equals(propertyName)) {
            boolean enableMulLocalCurrency = (Boolean)changeData[0].getNewValue();
            if (!enableMulLocalCurrency) {
                this.cleanMulLocalCurrencyFieldsValue();
            }
            this.showMulLocalCurrencyFields(enableMulLocalCurrency);
            if (!enableMulLocalCurrency) {
                this.cleanMulLocalCurrencyFieldsValue();
            }
        }
    }

    private void modifyRelatedBookFieldProp(int row, MainEntityType newMainType) {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("b_app", row);
        if (null == bizApp) {
            return;
        }
        this.getPageCache().put("CURRENT_APP", bizApp.getString("number"));
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)bizApp.getString("number"));
        if (null == bookRegisterInfo) {
            return;
        }
        String bookEntityId = bookRegisterInfo.getBookEntityId();
        EntryProp entry = (EntryProp)newMainType.getProperty("b_entry");
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("b_relatebook");
        prop.setBaseEntityId(bookEntityId);
        BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
        baseProp.setBaseEntityId(bookEntityId);
        baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)bookEntityId));
    }

    private void setCurrencyANdExtrate(long selectOrgId) {
        Object accountintSys = this.getModel().getValue(ACCOUNTING_SYS);
        if (null != accountintSys && 0L != selectOrgId) {
            Map baseMap = BaseDataServiceHelper.getBaseAccountingInfo((Long)selectOrgId);
            this.getModel().setValue("basecurrency", baseMap.get("baseCurrencyID"));
            this.getModel().setValue("exratetable", baseMap.get("exchangeRateTableID"));
        }
    }

    private Set<Long> getPermissionOrg() {
        String userId = RequestContext.get().getUserId();
        String appId = AppMetadataCache.getAppInfo((String)"fibd").getId();
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(userId), (String)appId, (String)"gl_accountbook", (String)"47156aff000000ac");
        HashSet<Long> permissionOrg = new HashSet<Long>();
        if (!rs.hasAllOrgPerm()) {
            permissionOrg.addAll(rs.getHasPermOrgs());
        }
        return permissionOrg;
    }

    private void orgChange(Object value) {
        if (value != null) {
            String select = "basecurrrency,exratetable";
            Object org = ((DynamicObject)value).getPkValue();
            DynamicObject base = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)select, (QFilter[])new QFilter("baseacctorg", "=", org).toArray());
            IDataModel model = this.getModel();
            if (base != null && !Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("iscopy")) && null != this.getView().getFormShowParameter().getCustomParam("iscopy")) {
                model.setValue("basecurrency", base.get("basecurrrency"));
                model.setValue("exratetable", base.get("exratetable"));
            }
            this.judgeIsLeaf(model, org);
        }
    }

    private void clearAtt(IDataModel model) {
        model.setValue("startperiod", null);
        model.setValue("curperiod", null);
    }

    private void judgeIsLeaf(IDataModel model, Object org) {
        String viewId = this.getPageCache().get("mainView");
        boolean isLeaf = true;
        if (!StringUtils.isEmpty((CharSequence)viewId)) {
            QFilter[] qf = new QFilter[]{new QFilter("view", "=", (Object)Long.parseLong(viewId)), new QFilter("org", "=", org)};
            DynamicObject leaf = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"isleaf", (QFilter[])qf);
            isLeaf = leaf == null ? Boolean.TRUE.booleanValue() : leaf.getBoolean("isleaf");
        }
        model.setValue("isbizunit", (Object)isLeaf);
        this.getView().setEnable(Boolean.valueOf(isLeaf), new String[]{"startperiod", "curperiod", "relevancebusiness", "cashinitperiod", "advconap", "advconap1", "defaultvouchertype", "yearprofitacct"});
        BasedataEdit startperiod = (BasedataEdit)this.getControl("startperiod");
        startperiod.setMustInput(isLeaf);
        FormShowParameter params = this.getView().getFormShowParameter();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isCopy = customParams.get("iscopy");
        if (isLeaf && (isCopy != null && ((Boolean)isCopy).booleanValue() || OperationStatus.EDIT.equals((Object)params.getStatus()))) {
            if (isCopy != null && ((Boolean)isCopy).booleanValue()) {
                model.setValue("defaultvouchertype", null);
            }
            return;
        }
        this.clearAtt(model);
    }

    private Set<Object> getOrgInfo(DynamicObject accountingsys) {
        HashSet<Object> org = new HashSet<Object>();
        if (null == accountingsys) {
            return org;
        }
        QFilter[] qf = new QFilter[]{new QFilter(ACCOUNTING_SYS, "=", accountingsys.getPkValue()), new QFilter("ismainview", "=", (Object)"1")};
        DynamicObject mainSys = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)ID, (QFilter[])qf);
        if (mainSys != null) {
            this.getPageCache().put("mainView", mainSys.getString(ID));
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter("view", "=", (Object)mainSys.getLong(ID)).toArray());
            for (DynamicObject dyo : orgs) {
                org.add(dyo.get("org"));
            }
        }
        return org;
    }

    private Set<Long> getMainViewId() {
        DynamicObjectCollection mainSys = QueryServiceHelper.query((String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])new QFilter("ismainview", "=", (Object)"1").toArray());
        HashSet<Long> sys = new HashSet<Long>();
        for (DynamicObject main : mainSys) {
            sys.add(main.getLong(ACCOUNTING_SYS));
        }
        return sys;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String str;
            IDataModel model = this.getModel();
            Object id = model.getValue(ID);
            Object bookstype = model.getValue("bookstype_id");
            DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue(MULTIPLECHOICEORG);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject org : orgs) {
                QFilter[] qf = new QFilter[]{new QFilter(ID, "!=", id), new QFilter("org", "=", ((DynamicObject)org.get("fbasedataid")).getPkValue()), new QFilter("bookstype", "=", bookstype)};
                if (!QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])qf)) continue;
                String orgName = ((DynamicObject)org.get("fbasedataid")).get("name.zh_CN").toString();
                sb.append(orgName);
                sb.append("\u3001");
            }
            if (sb != null && sb.length() > 0 && "0".equals(model.getValue(ID).toString())) {
                sb.deleteCharAt(sb.length() - 1);
                sb.insert(0, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 \uff1a", (String)"GLAccountBook_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                sb.append(ResManager.loadKDString((String)" \u5df2\u521b\u5efa\u8fc7\u76f8\u540c\u8d26\u7c3f\u7c7b\u578b\u7684\u8d26\u7c3f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GLAccountBook_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)sb.toString(), (String)"GLAccountBook_2", (String)"GLAccountBook_4", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("gl_accountbook", (IFormPlugin)this));
                args.setCancel(true);
            }
            if (StringUtils.isNotBlank((CharSequence)(str = this.validate()))) {
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)str, (String)"GLAccountBook_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), str));
            }
            if (!args.cancel) {
                QFilter[] numberFilter;
                DynamicObject accountBookRow;
                DynamicObject record;
                QFilter[] idFilter = new QFilter[]{new QFilter(ID, "=", id)};
                String number = (String)model.getValue("number");
                if (StringUtils.isNotBlank((CharSequence)number) && ((record = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"number", (QFilter[])idFilter)) == null || !number.equals(record.getString("number"))) && (accountBookRow = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)ID, (QFilter[])(numberFilter = new QFilter[]{new QFilter("number", "=", (Object)number)}))) != null) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"GLAccountBook_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!id.equals(0L)) {
                    this.initBalanceHasData(idFilter, model, args);
                }
            }
        }
    }

    private void initBalanceHasData(QFilter[] idFilter, IDataModel model, BeforeDoOperationEventArgs args) {
        boolean baseIsUpdate;
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"isendinit, number, accountingsys, org, bookstype, accounttable, basecurrency, exratetable, periodtype, startperiod, curperiod", (QFilter[])idFilter);
        DynamicObject obj = model.getDataEntity();
        boolean numberFlag = obj.get("number").equals(book.getString("number"));
        boolean accountingSysFlag = model.getValue("accountingsys_id").equals(book.getLong(ACCOUNTING_SYS));
        boolean orgFlag = model.getValue("org_id").equals(book.getLong("org"));
        boolean booksTypeFlag = model.getValue("bookstype_id").equals(book.getLong("bookstype"));
        boolean accountTableFlag = model.getValue("accounttable_id").equals(book.getLong("accounttable"));
        boolean baseCurrencyFlag = model.getValue("basecurrency_id").equals(book.getLong("basecurrency"));
        boolean exrateTableFlag = model.getValue("exratetable_id").equals(book.getLong("exratetable"));
        boolean periodTypeFlag = model.getValue("periodtype_id").equals(book.getLong("periodtype"));
        boolean startPeriodFlag = model.getValue("startperiod_id").equals(book.getLong("startperiod"));
        boolean curPeriodFlag = model.getValue("curperiod_id").equals(book.getLong("curperiod"));
        boolean businessIsUpdate = !numberFlag || !accountingSysFlag || !orgFlag || !booksTypeFlag || !accountTableFlag || !baseCurrencyFlag || !exrateTableFlag || !periodTypeFlag || !startPeriodFlag || !curPeriodFlag;
        DynamicObject dataObj = BusinessDataServiceHelper.loadSingle((Object)model.getValue(ID), (String)"gl_accountbook", (String)"org,bookstype");
        if (businessIsUpdate && (book.getBoolean("isendinit") || this.checkInitBalances(model) || AccountBookHelper.checkVoucherRef((DynamicObject)dataObj))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u6216\u5b58\u5728\u4f59\u989d\u521d\u59cb\u5316\u3001\u51ed\u8bc1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"GLAccountBook_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        boolean bl = baseIsUpdate = !numberFlag || !accountingSysFlag || !orgFlag || !booksTypeFlag || !accountTableFlag;
        if (baseIsUpdate && AccountBookHelper.checkAccountBookIsRefered((DynamicObject)dataObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u5df2\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"GLAccountBook_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private String validate() {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection bentry = this.getModel().getEntryEntity("b_entry");
        if (bentry == null || bentry.isEmpty()) {
            return sb.toString();
        }
        HashSet<Long> orgFa = new HashSet<Long>(16);
        HashSet<Long> orgAr = new HashSet<Long>(16);
        HashSet<Long> orgCal = new HashSet<Long>(16);
        for (DynamicObject row : bentry) {
            String bizApp;
            DynamicObjectCollection relateCols = row.getDynamicObjectCollection("b_relatebook");
            if (relateCols == null || relateCols.isEmpty()) continue;
            Set<Long> ids = relateCols.stream().map(r -> r.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
            switch (bizApp = Optional.ofNullable(row.getDynamicObject("b_app")).map(r -> r.getString("number")).orElse("").toLowerCase()) {
                case "fa": {
                    this.appendValidateMsgFa(sb, orgFa, ids);
                    break;
                }
                case "ar": {
                    this.appendValidateMsgAr(sb, orgAr, ids);
                    break;
                }
                case "cal": {
                    this.appendValidateMsgCal(sb, orgCal, relateCols);
                    break;
                }
            }
        }
        return sb.toString();
    }

    private Set<Object> getMultBaseOrg() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getControl(MULTIPLECHOICEORG).getModel().getDataEntity().get(MULTIPLECHOICEORG);
        HashSet<Object> set = new HashSet<Object>();
        if (orgs.size() < 2) {
            for (DynamicObject o : orgs) {
                Object orgId = o.get(FBASEDATAID_ID);
                DynamicObjectCollection bizorgs = QueryServiceHelper.query((String)ACCOUNTINGSYS_FORMID, (String)"bizorgentry.bizorg", (QFilter[])new QFilter("bizorgentry.bizacctorg", "=", orgId).toArray());
                for (DynamicObject bizorg : bizorgs) {
                    set.add(bizorg.get("bizorgentry.bizorg"));
                }
                set.add(orgId);
            }
        }
        return set;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        IDataModel model = this.getModel();
        if (ACCOUNTING_SYS.equals(key) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Object accSys = model.getValue(ACCOUNTING_SYS);
            model.createNewData();
            this.getView().updateView();
            model.setValue(ACCOUNTING_SYS, accSys);
        }
    }

    public List<Long> getAllSuperiorOrgIds(List<Long> orgIds, boolean isIncludeCurOrg) {
        List<Long> ids = this.getAllSuperiorOrgIdsOrderByLevel(orgIds);
        for (Long o : orgIds) {
            if (isIncludeCurOrg) {
                if (ids.contains(o)) continue;
                ids.add(o);
                continue;
            }
            if (!ids.contains(o)) continue;
            Iterator<Long> it = ids.iterator();
            while (it.hasNext()) {
                long id = it.next();
                if (id != o) continue;
                it.remove();
            }
        }
        return ids;
    }

    private List<Long> getAllSuperiorOrgIdsOrderByLevel(List<Long> orgIds) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgIds.isEmpty()) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "in", orgIds);
        String longNumber = "";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)GLAccountBook.class.getName(), (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf("!") == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)GLAccountBook.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        return ids;
    }

    private QFilter getOrgFilter(String entity) {
        List<Long> orgIds = this.getAllAccountOrgIds();
        Long viewId = Long.valueOf("10");
        Long parentOrgId = this.getParentOrgByChildren(orgIds, viewId);
        return this.getBaseDataFilterBySingleOrg(parentOrgId, entity);
    }

    private List<Long> getAllAccountOrgIds() {
        Long id;
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(MULTIPLECHOICEORG);
        List<Long> orgIds = this.getMultiAccountOrgIds(orgs);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org && !orgIds.contains(id = (Long)org.getPkValue())) {
            orgIds.add(id);
        }
        return orgIds;
    }

    private List<Long> getMultiAccountOrgIds(DynamicObjectCollection orgs) {
        ArrayList<Long> orgIds;
        if (orgs == null || orgs.isEmpty()) {
            orgIds = new ArrayList<Long>(0);
        } else {
            orgIds = new ArrayList(orgs.size());
            for (DynamicObject dyo : orgs) {
                Object orgObj = dyo.get(FBASEDATAID_ID);
                if (!(orgObj instanceof Long)) continue;
                orgIds.add((Long)orgObj);
            }
        }
        return orgIds;
    }

    private Long getParentOrgByChildren(List<Long> childrenOrgs, Long viewId) {
        if (viewId == null || viewId.compareTo(0L) <= 0) {
            return 0L;
        }
        return AccSysUtil.getParentOrgByChildre(childrenOrgs, (Long)viewId);
    }

    private QFilter getBaseDataFilterBySingleOrg(Long orgId, String entity) {
        if (orgId == null || orgId.compareTo(0L) <= 0) {
            return null;
        }
        return BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgId);
    }

    private void validateRelateBookF7(BeforeF7SelectEvent evt) {
        int rowIndex = evt.getRow();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("b_app", rowIndex);
        if (bizApp == null) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u3002", (String)"GLAccountBook_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceMethod = evt.getSourceMethod();
        if ("getLookUpList".equals(sourceMethod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6253\u5f00\u5217\u8868\u9009\u62e9\u3002", (String)"AbstractCreditLimitEditPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("b_relatebook", null, rowIndex);
            evt.setCancel(true);
            return;
        }
        if ("setItemByNumber".equals(sourceMethod)) {
            return;
        }
        this.modifyRelatedBookFieldProp(rowIndex, this.getModel().getDataEntityType());
        evt.setCancel(true);
        BasedataEdit realF7 = (BasedataEdit)this.getControl("b_relatebook");
        realF7.click();
    }

    private void validateRelateBookRealF7(BeforeF7SelectEvent evt) {
        int rowIndex = evt.getRow();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("b_app", rowIndex);
        if (bizApp == null) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u3002", (String)"GLAccountBook_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceMethod = evt.getSourceMethod();
        if ("getLookUpList".equals(sourceMethod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6253\u5f00\u5217\u8868\u9009\u62e9\u3002", (String)"AbstractCreditLimitEditPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("b_relatebook", null, rowIndex);
            evt.setCancel(true);
            return;
        }
        if ("setItemByNumber".equals(sourceMethod)) {
            return;
        }
        this.addF7Filter(evt);
    }

    private void validateRelateOrgF7(BeforeF7SelectEvent evt) {
        int rowIndx = evt.getRow();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("o_app", rowIndx);
        if (bizApp == null) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u3002", (String)"GLAccountBook_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        String appNumber = Optional.ofNullable(bizApp.getString("number")).orElse("");
        if ("cas".equals(appNumber)) {
            param.setCustomParam("orgFuncId", (Object)"08");
        } else {
            param.setCustomParam("orgFuncId", (Object)"10");
        }
    }

    private void addF7Filter(BeforeF7SelectEvent evt) {
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)this.getPageCache().get("CURRENT_APP"));
        if (null == bookRegisterInfo) {
            return;
        }
        switch (bookRegisterInfo.getBookEntityId()) {
            case "fa_assetbook": {
                this.addFaAssetBookFilter(evt, qFilters);
                break;
            }
            case "cal_bd_costaccount": {
                qFilters.add(new QFilter("calorg", "in", this.getMultBaseOrg()));
                break;
            }
            case "ar_policy": {
                qFilters.add(new QFilter("org", "in", this.getMultBaseOrg()));
                break;
            }
        }
    }

    private void addFaAssetBookFilter(BeforeF7SelectEvent evt, List<QFilter> qFilters) {
        ((ListShowParameter)evt.getFormShowParameter()).setShowApproved(false);
        ListIterator<QFilter> iterator = qFilters.listIterator();
        while (iterator.hasNext()) {
            QFilter next = iterator.next();
            if ("status".equals(next.getProperty())) {
                iterator.remove();
                iterator.add(new QFilter("status", "in", (Object)new String[]{"B", "C"}));
                continue;
            }
            if (!"enable".equals(next.getProperty())) continue;
            next.or(new QFilter("enable", "=", (Object)"0"));
        }
        qFilters.add(new QFilter("org", "in", this.getMultBaseOrg()));
    }

    private void appendValidateMsgFa(StringBuilder sb, Set<Long> containIds, Set<Long> ids) {
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"fa_assetbook", (String)"org", (QFilter[])new QFilter(ID, "in", ids).toArray());
        for (DynamicObject query : querys) {
            if (containIds.add(query.getLong("org"))) continue;
            sb.append(ResManager.loadKDString((String)"\u540c\u4e00\u4f1a\u8ba1\u8d26\u7c3f\u4e0d\u5141\u8bb8\u540c\u65f6\u5173\u8054\u540c\u4e00\u4e2a\u8d44\u4ea7\u7ec4\u7ec7\u7684\u4e24\u4e2a\u8d26\u7c3f\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u5173\u8054\u8d26\u7c3f\u8bbe\u7f6e\u3002", (String)"GLAccountBook_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            break;
        }
    }

    private void appendValidateMsgAr(StringBuilder sb, Set<Long> containIds, Set<Long> ids) {
        DynamicObjectCollection policyquerys = QueryServiceHelper.query((String)"ar_policy", (String)"org", (QFilter[])new QFilter(ID, "in", ids).toArray());
        for (DynamicObject policyquery : policyquerys) {
            if (containIds.add(policyquery.getLong("org"))) continue;
            sb.append(ResManager.loadKDString((String)"\u5173\u8054\u8d26\u7c3f\u91cd\u590d\u3010\u5e94\u6536\u8d26\u7c3f\u7ec4\u7ec7\u91cd\u590d\u3011\u3002", (String)"GLAccountBook_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            break;
        }
    }

    private void appendValidateMsgCal(StringBuilder sb, Set<Long> containIds, DynamicObjectCollection relateCols) {
        for (DynamicObject costaccount : relateCols) {
            if (containIds.add(costaccount.getLong(FBASEDATAID_ID))) continue;
            sb.append(costaccount.getDynamicObject("fbasedataid").get("name"));
            sb.append("\t\n");
        }
    }

    private void setRelateBookEntry() {
        DynamicObjectCollection relateBookEntry = this.getModel().getEntryEntity("b_entry");
        if (null != relateBookEntry && !relateBookEntry.isEmpty()) {
            MainEntityType mainEntityType = this.getModel().getDataEntityType();
            for (int i = 0; i < relateBookEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)relateBookEntry.get(i);
                DynamicObjectCollection relateBookCols = row.getDynamicObjectCollection("b_relatebook");
                Long[] ids = relateBookCols.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList()).toArray(new Long[0]);
                this.modifyRelatedBookFieldProp(i, mainEntityType);
                this.getModel().setValue("b_relatebook", (Object)ids, i);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void setBappF7Filter(BeforeF7SelectEvent evt, String entryEntity, String field) {
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        List registerInfoList = BookRegisterService.queryAll();
        boolean isOEntry = "o_entry".equals(entryEntity);
        Set appSet = registerInfoList.stream().filter(r -> !"gl".equals(r.getBizApp())).filter(r -> isOEntry ? BookRegisterService.isBookOnOrg((String)r.getBizApp()) : !BookRegisterService.isBookOnOrg((String)r.getBizApp())).map(r -> r.getBizApp()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("number", "in", appSet);
        DynamicObjectCollection entry = this.getModel().getEntryEntity(entryEntity);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryEntity);
        if (null != entry && !entry.isEmpty()) {
            ArrayList<String> appIds = new ArrayList<String>(entry.size());
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject appDyn;
                if (i == rowIndex || null == (appDyn = ((DynamicObject)entry.get(i)).getDynamicObject(field))) continue;
                appIds.add(appDyn.getString(ID));
            }
            qFilter.and(new QFilter(ID, "not in", appIds));
        }
        qFilters.add(qFilter);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        JSONArray array = (JSONArray)sourceData.get("b_entry");
        if (null == array || array.size() == 0) {
            return;
        }
        List allAppNumList = (List)ThreadCache.get((Object)"all_app_number", () -> BookRegisterService.queryAll().stream().map(BookRegisterInfo::getBizApp).collect(Collectors.toList()));
        HashMap<String, String> appMap = new HashMap<String, String>();
        HashMap<Long, Tuple> updateMap = new HashMap<Long, Tuple>();
        Iterator iterator = array.iterator();
        Map accountingsys = (Map)sourceData.get(ACCOUNTING_SYS);
        QFilter[] qf1 = new QFilter[]{new QFilter("accountingsys.number", "=", accountingsys.get("number")), new QFilter("ismainview", "=", (Object)"1")};
        DynamicObject mainSys = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)ID, (QFilter[])qf1);
        boolean leaf = true;
        if (mainSys != null) {
            String viewIdStr = mainSys.getString(ID);
            long orgId = this.getOrgIdByNumber((String)((Map)sourceData.get("org")).get("number"));
            leaf = OrgServiceHelper.isLeaf((long)orgId, (long)Long.parseLong(viewIdStr));
        }
        DynamicObjectCollection cols = this.getModel().getEntryEntity("b_entry");
        Map<Long, DynamicObject> bEntry = cols.stream().collect(Collectors.toMap(x -> x.getLong(ID), x -> x));
        while (iterator.hasNext() && leaf) {
            JSONObject json = (JSONObject)iterator.next();
            JSONObject bAppJson = (JSONObject)json.get((Object)"b_app");
            String number = (String)bAppJson.get((Object)"number");
            if (!allAppNumList.contains(number)) {
                throw new KDBizException(ResManager.loadKDString((String)"EXCEL\u4e2d\u5305\u542b\u4e0d\u652f\u6301\u7684\u5e94\u7528\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLAccountBook_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            JSONObject bookObj = (JSONObject)json.get((Object)"b_relatebook");
            if (bookObj == null || bookObj.get((Object)"number") == null) continue;
            Long id = json.getLong(ID);
            if (id == null || id == 0L) {
                appMap.put(number, (String)bookObj.get((Object)"number"));
                continue;
            }
            if (bEntry.containsKey(id)) {
                updateMap.put(id, new Tuple((Object)number, (Object)((String)bookObj.get((Object)"number"))));
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5173\u8054\u8d26\u7c3f\u5355\u636e\u4f53\u7684\u5185\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1aid=%s", (String)"GLAccountBook_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), id));
        }
        array.clear();
        Object id = this.getModel().getValue(ID);
        ThreadCache.put((Object)GLAccountBook.genCacheKey(id, BOOK_IMPORT_KEY), appMap);
        ThreadCache.put((Object)GLAccountBook.genCacheKey(id, BOOK_UPDATEIMPORT_KEY), updateMap);
    }

    private static String genCacheKey(Object id, String prefix) {
        return String.format("%1$s_%2$s_%3$s", prefix, id, OTHER_APP_BOOK);
    }

    public void afterImportData(ImportDataEventArgs e) {
        Object id = this.getModel().getValue(ID);
        String addCacheKey = GLAccountBook.genCacheKey(id, BOOK_IMPORT_KEY);
        String updateCacheKey = GLAccountBook.genCacheKey(id, BOOK_UPDATEIMPORT_KEY);
        Map appMap = (Map)ThreadCache.get((Object)addCacheKey);
        Map updateMap = (Map)ThreadCache.get((Object)updateCacheKey);
        if ((appMap == null || appMap.isEmpty()) && (updateMap == null || updateMap.isEmpty())) {
            return;
        }
        ThreadCache.remove((Object)addCacheKey);
        ThreadCache.remove((Object)updateCacheKey);
        Map appNum2IdMap = (Map)ThreadCache.get((Object)"book_apps_numbers", () -> {
            List appNums = BookRegisterService.queryAll().stream().map(BookRegisterInfo::getBizApp).collect(Collectors.toList());
            return Arrays.stream(BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"number,id", (QFilter[])new QFilter[]{new QFilter("number", "in", appNums)})).collect(Collectors.toMap(x -> x.getString("number"), x -> x));
        });
        DynamicObjectCollection cols = this.getModel().getEntryEntity("b_entry");
        if (updateMap != null) {
            for (Map.Entry entry : updateMap.entrySet()) {
                for (DynamicObject col : cols) {
                    long updateId = (Long)entry.getKey();
                    if (col.getLong(ID) != updateId) continue;
                    String appNum = (String)((Tuple)entry.getValue()).item1;
                    DynamicObject app = (DynamicObject)appNum2IdMap.get(appNum);
                    col.set("b_app", (Object)app);
                    BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)appNum);
                    String[] numbers = ((String)((Tuple)entry.getValue()).item2).split(",");
                    HashSet<String> numberSet = new HashSet<String>(8);
                    numberSet.addAll(Arrays.asList(numbers));
                    DataSet books = this.getBooks(bookRegisterInfo, numbers, numberSet);
                    DynamicObjectCollection subCols = col.getDynamicObjectCollection("b_relatebook");
                    subCols.clear();
                    for (Row bookId : books) {
                        DynamicObject subRow = subCols.addNew();
                        subRow.set(FBASEDATAID_ID, (Object)bookId.getLong(ID));
                    }
                }
            }
        }
        if (appMap != null) {
            for (Map.Entry entry : appMap.entrySet()) {
                DynamicObject newRow = cols.addNew();
                DynamicObject app = (DynamicObject)appNum2IdMap.get(entry.getKey());
                newRow.set("b_app", (Object)app);
                BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)((String)entry.getKey()));
                String[] numbers = ((String)entry.getValue()).split(",");
                HashSet<String> numberSet = new HashSet<String>(8);
                numberSet.addAll(Arrays.asList(numbers));
                DataSet books = this.getBooks(bookRegisterInfo, numbers, numberSet);
                DynamicObjectCollection subCols = newRow.getDynamicObjectCollection("b_relatebook");
                for (Row bookId : books) {
                    DynamicObject subRow = subCols.addNew();
                    subRow.set(FBASEDATAID_ID, (Object)bookId.getLong(ID));
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setHideFieldNotDataChanged();
        e.setSkipNoField(true);
    }

    private void setHideFieldNotDataChanged() {
        DynamicObject acctBook = this.getModel().getDataEntity(true);
        DynamicObjectCollection bEntry = acctBook.getDynamicObjectCollection("b_entry");
        for (DynamicObject row : bEntry) {
            DynamicObjectCollection mulCols = row.getDynamicObjectCollection("b_relatebook");
            for (DynamicObject subRow : mulCols) {
                subRow.getDataEntityState().setBizChanged(false);
            }
        }
    }

    private Long getOrgIdByNumber(String orgNumber) {
        QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject org = this.queryOneOrThrow("bos_org", "org", orgNumber, orgFilter);
        return org.getLong(ID);
    }

    private DynamicObject queryOneOrThrow(String entity, String prop, String number, QFilter ... filters) {
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)entity, (String)ID, (QFilter[])filters)).orElseThrow(() -> this.throwNumberMissingException(prop, entity, number));
    }

    private IllegalStateException throwNumberMissingException(String prop, String entity, String missingNumber) {
        String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
        String propName = this.getModel().getDataEntityType().getProperty(prop).getDisplayName().getLocaleValue();
        return new IllegalStateException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u5b58\u5728\u542f\u7528\u7684\u7f16\u7801\u4e3a%2$s\u7684%3$s\u3002", (String)"ImportGLAccountBook_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), propName, missingNumber, entityName));
    }

    private DataSet getBooks(BookRegisterInfo bookRegisterInfo, String[] numbers, Set<String> numberSet) {
        DataSet books = QueryServiceHelper.queryDataSet((String)GLAccountBook.class.getName(), (String)bookRegisterInfo.getBookEntityId(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numbers)}, null);
        HashSet<String> dbNumberSet = new HashSet<String>(8);
        for (Row row : books.copy()) {
            dbNumberSet.add(row.getString("number"));
        }
        numberSet.removeAll(dbNumberSet);
        if (numberSet.size() > 0) {
            StringBuilder str = new StringBuilder();
            numberSet.stream().forEach(s -> str.append(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5f15\u5165\u65f6\u627e\u4e0d\u5230\u5173\u8054\u4e1a\u52a1\u8d26\u7c3f.\u7f16\u7801=%s\u7684\u5173\u8054\u4e1a\u52a1\u8d26\u7c3f\uff1b", (String)"GLAccountBook_16", (String)"fi-gl-formplugin", (Object[])new Object[0]), s)));
            throw new KDBizException(str.substring(0, str.lastIndexOf(MultiLangPunc.semicolon())));
        }
        return books;
    }

    private void lockMulLocalCurrencyFields() {
        List mulCurFieldList = AccountBookUtil.getCurAndExRateTableFields();
        mulCurFieldList.add("enablemullocalcur");
        this.getView().setEnable(Boolean.valueOf(false), mulCurFieldList.toArray(new String[0]));
    }

    private void cleanMulLocalCurrencyFieldsValue() {
        IDataModel model = this.getModel();
        List curAndExRateTableFields = AccountBookUtil.getCurAndExRateTableFields();
        for (String field : curAndExRateTableFields) {
            model.setValue(field, null);
        }
    }

    private void showMulLocalCurrencyFields(boolean enableMulLocalCurrency) {
        List curAndExRateTableFields = AccountBookUtil.getCurAndExRateTableFields();
        this.getView().setVisible(Boolean.valueOf(enableMulLocalCurrency), curAndExRateTableFields.toArray(new String[0]));
    }

    private void setEnableMulCurrency() {
        IDataModel model = this.getModel();
        List currencyFieldList = AccountBookUtil.getCurFields();
        for (String currencyField : currencyFieldList) {
            if (!Objects.nonNull(model.getValue(currencyField))) continue;
            model.setValue("enablemullocalcur", (Object)true);
        }
    }
}

