/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.accountbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class GLAccountBookList
extends AbstractListPlugin {
    private static final String OPENED_PERIOD = "openedperiod";
    private static final String ORG = "org";
    private static final String BOOK_TYPE = "booktype";
    private static final String OPENED_PERIOD_TABLE = "gl_openedperiod";
    private static final String PERIOD = "period";
    private static final String ACCOUNT_PERIOD = "bd_period";
    private static final String PERIOD_NAME = "name";
    private static final String DELIMITER = ";";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperateOption option;
        String disableConfirm;
        StatusConvert stC;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof StatusConvert && "disable".equals((stC = (StatusConvert)args.getSource()).getOperateKey()) && (disableConfirm = (option = stC.getOption()).getVariableValue("disable_confirm", "0")).equals("0")) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (ListSelectedRow row : args.getListSelectedData()) {
                list.add(row.getPrimaryKeyValue());
            }
            this.checkEndLocal(list, args);
        }
    }

    private void checkEndLocal(List<Object> list, BeforeDoOperationEventArgs args) {
        StringBuilder info = new StringBuilder();
        String select = "org,bookstype,accounttable,curperiod";
        QFilter idQF = new QFilter("id", "in", list);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)select, (QFilter[])new QFilter[]{idQF, enable});
        ArrayList<Object> orgIds = new ArrayList<Object>();
        ArrayList<Object> booktypeIds = new ArrayList<Object>();
        ArrayList<Object> accounttableIds = new ArrayList<Object>();
        ArrayList<Object> periodIds = new ArrayList<Object>();
        for (DynamicObject book : books) {
            orgIds.add(book.get(ORG));
            booktypeIds.add(book.get("bookstype"));
            accounttableIds.add(book.get("accounttable"));
            periodIds.add(book.get("curperiod"));
        }
        QFilter orgQF = new QFilter(ORG, "in", orgIds);
        QFilter booktypeQF = new QFilter(BOOK_TYPE, "in", booktypeIds);
        QFilter accounttableQF = new QFilter("accounttable", "in", accounttableIds);
        QFilter periodQF = new QFilter("endperiod", "=", (Object)GLUtil.MAX_PERIOD);
        QFilter endLocalQF = new QFilter("endlocal", "!=", (Object)BigDecimal.ZERO);
        QFilter vperiodQF = new QFilter(PERIOD, "in", periodIds);
        QFilter statusQF = new QFilter("ispost", "=", (Object)"0");
        if (QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{orgQF, booktypeQF, vperiodQF, statusQF})) {
            info.append(ResManager.loadKDString((String)"\u7981\u7528\u8d26\u7c3f\u4e2d\u5b58\u5728\u672a\u8fc7\u8d26\u51ed\u8bc1\u3002", (String)"GLAccountBookList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            info.append("\t\n");
        }
        if (QueryServiceHelper.exists((String)"gl_balance", (QFilter[])new QFilter[]{orgQF, booktypeQF, accounttableQF, periodQF, endLocalQF})) {
            info.append(ResManager.loadKDString((String)"\u7981\u7528\u8d26\u7c3f\u4e2d\u6709\u671f\u672b\u4f59\u989d\u4e0d\u4e3a0\u7684\u79d1\u76ee\u3002", (String)"GLAccountBookList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            info.append("\t\n");
        }
        if (StringUtils.isNotBlank((CharSequence)info)) {
            this.getView().showConfirm(info.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Set<Long> set = this.getPermissionOrg();
        if (!set.isEmpty()) {
            e.getQFilters().add(new QFilter(ORG, "in", set));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : listFilterColumns) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "org.name": {
                    List comboItems = AccSysUtil.getAcctOrgComboItem((String)"gl_accountbook", (boolean)false, (PermissonType)PermissonType.VIEW);
                    commFilter.setComboItems(comboItems);
                    if (comboItems.size() <= 0) break;
                    commFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
                }
            }
        }
    }

    private Set<Long> getPermissionOrg() {
        String userId = RequestContext.get().getUserId();
        String appId = AppMetadataCache.getAppInfo((String)"fibd").getId();
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(userId), (String)appId, (String)"gl_accountbook", (String)"47150e89000000ac");
        HashSet<Long> permissionOrg = new HashSet<Long>();
        if (!rs.hasAllOrgPerm()) {
            permissionOrg.addAll(rs.getHasPermOrgs());
        }
        return permissionOrg;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("accountingsys_name".equalsIgnoreCase(fieldName)) {
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            Object key = list.getFocusRowPkId();
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accountingsys", (QFilter[])new QFilter("id", "=", key).toArray());
            BillShowParameter form = new BillShowParameter();
            form.setFormId("bd_accountingsys");
            form.setPkId(book.get("accountingsys"));
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setBillStatus(BillOperationStatus.VIEW);
            form.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)form);
            args.setCancel(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dyos = super.getData(start, limit);
                dyos.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(GLAccountBookList.OPENED_PERIOD, String.class, (Object)""));
                boolean isContainOrgProp = false;
                if (!dyos.isEmpty()) {
                    DataEntityPropertyCollection properties = ((DynamicObject)dyos.get(0)).getDynamicObjectType().getProperties();
                    for (IDataEntityProperty property : properties) {
                        if (!GLAccountBookList.ORG.equals(property.getName())) continue;
                        isContainOrgProp = true;
                        break;
                    }
                    Map accountInfos = new HashMap();
                    if (!isContainOrgProp) {
                        ArrayList<Long> ids = new ArrayList<Long>(dyos.size());
                        for (DynamicObject dyo : dyos) {
                            ids.add(dyo.getLong("id"));
                        }
                        accountInfos = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"id,org.number", (QFilter[])new QFilter("id", "in", ids).toArray());
                    }
                    for (DynamicObject dyo : dyos) {
                        String number;
                        String orgNum = "";
                        String bookstypeNum = "";
                        Long orgId = null;
                        Long bookstypeId = null;
                        DynamicObject bookstype = dyo.getDynamicObject("bookstype");
                        if (bookstype != null) {
                            bookstypeNum = bookstype.getString("number");
                            bookstypeId = bookstype.getLong("id");
                        }
                        if (!isContainOrgProp) {
                            Object id = dyo.get("id");
                            DynamicObject accountInfo = (DynamicObject)accountInfos.get(id);
                            orgNum = accountInfo.getString("org.number");
                            orgId = accountInfo.getLong("org.id");
                        } else {
                            DynamicObject org = dyo.getDynamicObject(GLAccountBookList.ORG);
                            if (org != null) {
                                orgNum = org.getString("number");
                                orgId = org.getLong("id");
                            }
                        }
                        List openedPeriodList = GLAccountBookList.this.getOpenedPeriod(orgId, bookstypeId);
                        if (openedPeriodList.size() > 0) {
                            String openedPeriodStr = String.join((CharSequence)GLAccountBookList.DELIMITER, openedPeriodList);
                            dyo.set(GLAccountBookList.OPENED_PERIOD, (Object)openedPeriodStr);
                        }
                        if (!StringUtils.isBlank((CharSequence)(number = dyo.getString("number")))) continue;
                        dyo.set("number", (Object)(orgNum + "@" + bookstypeNum));
                    }
                }
                return dyos;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("delete".equals(key) && evt.getOperationResult().isSuccess()) {
            DistributeCache cacheSys = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);
            cacheSys.remove(CacheKey.ACCSYS_MAINVIEWORGBOOKTYPE.toString());
            cacheSys.remove(CacheKey.ACCSYS_STATVIEWORGBOOKTYPE.toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key = evt.getCallBackId();
        if ("disable".equals(key) && MessageBoxResult.Yes.compareTo((Enum)evt.getResult()) == 0) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("disable_confirm", "1");
            this.getView().invokeOperation("disable", operateOption);
        }
    }

    private List<String> getOpenedPeriod(Long orgId, Long bookType) {
        ArrayList<String> periodList = new ArrayList<String>();
        if (orgId != null && bookType != null) {
            QFilter orgFilter = new QFilter(ORG, "=", (Object)orgId);
            QFilter bookTypeFilter = new QFilter(BOOK_TYPE, "=", (Object)bookType);
            DynamicObjectCollection openedPeriodCollection = QueryServiceHelper.query((String)OPENED_PERIOD_TABLE, (String)PERIOD, (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
            for (DynamicObject openedPeriodObject : openedPeriodCollection) {
                String periodNumber = this.getPeriodNameById(openedPeriodObject.getLong(PERIOD));
                if (periodNumber == null) continue;
                periodList.add(periodNumber);
            }
        }
        Collections.sort(periodList);
        return periodList;
    }

    private String getPeriodNameById(long periodId) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject periodObject = QueryServiceHelper.queryOne((String)ACCOUNT_PERIOD, (String)PERIOD_NAME, (QFilter[])new QFilter[]{filter});
        return periodObject == null ? null : periodObject.getString(PERIOD_NAME);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("cashflowconfig".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bd_cashflow_config");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_cashflow_config"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("bd_cashflow_config".equals(key)) {
            OperateOption operateOption = OperateOption.create();
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] acctBooks;
        for (DynamicObject acctBook : acctBooks = e.getQueryValues()) {
            DataEntityPropertyCollection properties = acctBook.getDynamicObjectType().getProperties();
            if (!properties.containsKey((Object)"b_entry")) continue;
            DynamicObjectCollection bEntry = acctBook.getDynamicObjectCollection("b_entry");
            for (int i = 0; i < bEntry.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)bEntry.get(i);
                DynamicObject bizAppp = entryRow.getDynamicObject("b_app");
                DynamicObjectCollection cols = entryRow.getDynamicObjectCollection("b_relatebook");
                for (DynamicObject subRow : cols) {
                    long fbasedataId = subRow.getLong("fbasedataid_id");
                    BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)bizAppp.getString("number"));
                    DynamicObject baseDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)fbasedataId, (String)bookRegisterInfo.getBookEntityId());
                    subRow.set("fbasedataid", (Object)baseDyn);
                }
            }
        }
    }
}

