/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.acctformula;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.formplugin.acctformula.AcctAssgrpBasePlugin;
import kd.fi.gl.util.GLUtil;

public class CashFlowItemAndAssgrpPlugin
extends AcctAssgrpBasePlugin
implements BeforeF7SelectListener {
    private static final String ENTITY = "gl_cashflowitem";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"account"});
        this.addClickListeners(new String[]{"cancel", "confirm"});
        BasedataEdit cashflowitem = (BasedataEdit)this.getControl("cashflowitem");
        cashflowitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"group"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl("cashflowitem");
        base.addBeforeF7SelectListener(select -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                QFilter qbase = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY, (Long)org.getLong("id"));
                list.add(qbase);
                showParam.getListFilterParameter().getQFilters().addAll(list);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String accountStr = (String)param.getCustomParam("cashflow");
        String orgid = (String)param.getCustomParam("org");
        if (!StringUtils.isEmpty((CharSequence)orgid)) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgid));
        } else {
            long oid = RequestContext.get().getOrgId();
            this.getModel().setValue("org", (Object)oid);
        }
        if (!StringUtils.isEmpty((CharSequence)accountStr)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.resetEntityAndAssgrp(org == null ? 0L : org.getLong("id"), 0L, accountStr, ENTITY);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit t;
        if (arg0.getSource() instanceof BasedataEdit && "cashflowitem".equals((t = (BasedataEdit)arg0.getSource()).getKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                arg0.addCustomQFilter(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CashFlowItemAndAssgrpPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (propName) {
            case "org": {
                this.getModel().setValue("cashflowitem", null);
                this.getModel().deleteEntryData("assgrpentity");
                DynamicObject neworg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getPageCache().put("orgid", neworg == null ? null : neworg.getString("id"));
                break;
            }
            case "cashflowitem": {
                DynamicObject newOne = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject oldOne = (DynamicObject)changeSet[0].getOldValue();
                if (newOne == null) {
                    this.getModel().deleteEntryData("assgrpentity");
                    break;
                }
                if (oldOne != null && newOne.getLong("id") == oldOne.getLong("id")) break;
                String selector = CashFlowItemAndAssgrpPlugin.genUniqueKey("id", "assistentry", "assistentry.asstypeid", "assistentry.asstypeid.number", "assistentry.asstypeid.name", "assistentry.asstypeid.flexfield", "assistentry.asstypeid.valuesource", "assistentry.asstypeid.valuetype");
                this.initAsstEntry(newOne.getLong("id"), ENTITY, selector, "assistentry", "asstypeid", new ArrayList<String>(5), new HashMap<String, AcctAssgrpBasePlugin.AssgrpEntryRowInfo>());
                break;
            }
            case "type": {
                IDataModel model = this.getModel();
                int index = model.getEntryCurrentRowIndex("assgrpentity");
                String type = (String)model.getValue(propName);
                boolean isConsist = "1".equals(type);
                if (isConsist) {
                    model.setValue("asstmember", null, index);
                } else {
                    model.setValue("sasstmember", null, index);
                    model.setValue("easstmember", null, index);
                }
                this.getView().setEnable(Boolean.valueOf(!isConsist), index, new String[]{"asstmember"});
                this.getView().setEnable(Boolean.valueOf(isConsist), index, new String[]{"sasstmember", "easstmember"});
                break;
            }
            case "groupstandard": {
                int rowIndex = changeSet[0].getRowIndex();
                this.getModel().setValue("group", null, rowIndex);
                Object groupStandard = changeSet[0].getDataEntity().get("groupstandard");
                if ((DynamicObject)changeSet[0].getNewValue() != null) {
                    this.getModel().setValue("groupstandardnumber", (Object)((DynamicObject)changeSet[0].getNewValue()).getString("number"), rowIndex);
                } else {
                    this.getModel().setValue("groupstandardnumber", null, rowIndex);
                }
                if (groupStandard != null && !groupStandard.equals("")) {
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"group"});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"asstmember"});
                    this.getModel().setValue("asstmember", null, rowIndex);
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"group"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"asstmember"});
                break;
            }
            case "asstmember": {
                int changeIndex = changeSet[0].getRowIndex();
                this.getModel().setValue("group", null, changeIndex);
                Object asstMember = changeSet[0].getDataEntity().get("asstmember");
                if (asstMember != null && !asstMember.equals("")) {
                    this.getView().setEnable(Boolean.valueOf(false), changeIndex, new String[]{"groupstandard"});
                    this.getModel().setValue("groupstandard", null, changeIndex);
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), changeIndex, new String[]{"groupstandard"});
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            DynamicObject cashflowitem = (DynamicObject)this.getModel().getValue("cashflowitem");
            if (cashflowitem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashFlowItemAndAssgrpPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder returnData = new StringBuilder();
            returnData.append(cashflowitem.getString("number"));
            for (DynamicObject row : this.getModel().getEntryEntity(ENTRY)) {
                DynamicObject groupStandard = row.getDynamicObject("groupstandard");
                String groupNum = row.getString("group");
                if (groupStandard == null || !StringUtils.isNotEmpty((CharSequence)groupStandard.getString("number")) || !StringUtils.isEmpty((CharSequence)groupNum)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u6807\u51c6\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashFlowItemAndAssgrpPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            this.appendAssgrps(this.getModel().getEntryEntity(ENTRY), returnData);
            HashMap map = Maps.newHashMap();
            if (returnData.length() > 2000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u957f\u5ea6\u8d85\u8fc72000\uff0c\u8bf7\u9009\u62e9\u9002\u91cf\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u3002", (String)"CashFlowItemAndAssgrpPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            map.put("returnData", returnData.toString());
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }
}

