/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.acctformula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.util.CommonAssistUtil;

public class CommonAssistF7Plugin
extends AbstractFormPlugin {
    private static final String ORG = "org";
    private static final String ACCOUNT_BOOK_TYPE = "accountbookstype";
    private static final String ACCOUNT_TABLE = "accounttable";
    private static final String COM_ASSIST_ENTITY = "commonassistentity";
    private static final String IS_SELECT = "isselect";
    private static final String COM_ASSIST = "comassist";
    private static final String SELECT_TYPE = "selecttype";
    private static final String COM_ASSIST_MEMBER = "comassistmember";
    private static final String START_ASSIST_MEMBER = "scomassistmember";
    private static final String END_ASSIST_MEMBER = "ecomassistmember";
    private static final String CANCEL_BUTTON = "cancel";
    private static final String CONFIRM_BUTTON = "confirm";
    private static final String BASEDATA_TYPE = "1";
    private static final String ASSISTANT_TYPE = "2";
    private static final String CONTINUE_TYPE = "1";
    private static final String DISPERSED_TYPE = "2";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{COM_ASSIST_MEMBER, START_ASSIST_MEMBER, END_ASSIST_MEMBER, CANCEL_BUTTON, CONFIRM_BUTTON});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String orgId = (String)param.getCustomParam(ORG);
        String accountBookType = (String)param.getCustomParam(ACCOUNT_BOOK_TYPE);
        if (!StringUtils.isEmpty((CharSequence)orgId)) {
            this.getModel().setValue(ORG, (Object)Long.parseLong(orgId));
        } else {
            this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
            orgId = String.valueOf(RequestContext.get().getOrgId());
        }
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            this.setAccountTable(Long.parseLong(orgId), accountBookType);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        String key = ((Control)evt.getSource()).getKey();
        if (evt.getSource() instanceof TextEdit) {
            EntryGrid comAssistEntity = (EntryGrid)this.getControl(COM_ASSIST_ENTITY);
            int[] selectRows = comAssistEntity.getSelectRows();
            if (selectRows.length == 0 || model.getEntryEntity(COM_ASSIST_ENTITY).isEmpty()) {
                return;
            }
            DynamicObject comAssist = (DynamicObject)((DynamicObject)model.getValue(ACCOUNT_TABLE)).getDynamicObjectCollection("comassistentry").get(selectRows[0]);
            if (comAssist != null) {
                String valueType = comAssist.getString("valuesourcetype");
                if (model.getValue(ORG) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CommonAssistF7Plugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("2".equals(valueType)) {
                    Object orgId;
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)false);
                    long groupId = comAssist.getLong("assistantvaluesource.id");
                    lsp.getListFilterParameter().setFilter(new QFilter("group", "=", (Object)groupId));
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                    lsp.setCloseCallBack(closeCallBack);
                    if (COM_ASSIST_MEMBER.equals(key)) {
                        lsp.setMultiSelect(true);
                    }
                    if (Objects.nonNull(orgId = this.getModel().getValue("org_id")) && Long.parseLong(orgId.toString()) != 0L) {
                        this.getView().getFormShowParameter().setCustomParam("orgId", orgId);
                    } else {
                        this.getView().getFormShowParameter().getCustomParams().remove("orgId");
                    }
                    this.getView().cacheFormShowParameter();
                    this.getView().showForm((FormShowParameter)lsp);
                } else if ("1".equals(valueType)) {
                    QFilter orgFilter;
                    String entityName = comAssist.getString("valuesource.id");
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)false);
                    ListFilterParameter filterParam = lsp.getListFilterParameter();
                    List qFilters = filterParam.getQFilters();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                    DynamicProperty statusProp = entityType.getProperty("enable");
                    if (statusProp != null) {
                        qFilters.add(new QFilter("enable", "=", (Object)"1"));
                    }
                    if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(model.getValue("org_id"))))) != null) {
                        qFilters.add(orgFilter);
                    }
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                    lsp.setCloseCallBack(closeCallBack);
                    if (COM_ASSIST_MEMBER.equals(key)) {
                        lsp.setMultiSelect(true);
                    }
                    this.getView().showForm((FormShowParameter)lsp);
                }
            }
        } else if (CANCEL_BUTTON.equals(key)) {
            this.getView().close();
        } else if (CONFIRM_BUTTON.equals(key)) {
            DynamicObject org = (DynamicObject)model.getValue(ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAssistF7Plugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject accountTable = (DynamicObject)model.getValue(ACCOUNT_TABLE);
            if (accountTable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAssistF7Plugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            String selectType = (String)model.getValue(SELECT_TYPE);
            String startDimensionMember = (String)model.getValue(START_ASSIST_MEMBER);
            String endDimensionMember = (String)model.getValue(END_ASSIST_MEMBER);
            if ("1".equals(selectType) && (StringUtils.isBlank((CharSequence)startDimensionMember) && StringUtils.isNotBlank((CharSequence)endDimensionMember) || StringUtils.isBlank((CharSequence)endDimensionMember) && StringUtils.isNotBlank((CharSequence)startDimensionMember))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u65b9\u5f0f\u4e3a\u8fde\u7eed\u65f6\uff0c\u5f00\u59cb\u6210\u5458\u548c\u7ed3\u675f\u6210\u5458\u5fc5\u987b\u540c\u65f6\u6709\u503c\u3002", (String)"CommonAssistF7Plugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            String returnData = this.buildReturnData();
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (ORG.equals(propName) && Objects.nonNull(changeSet[0].getNewValue())) {
            this.setAccountTable(((DynamicObject)changeSet[0].getNewValue()).getLong("id"), "");
        } else if (ACCOUNT_TABLE.equals(propName)) {
            DynamicObject newAccountTable = (DynamicObject)changeSet[0].getNewValue();
            if (newAccountTable != null) {
                DynamicObjectCollection comAssistDyns = newAccountTable.getDynamicObjectCollection("comassistentry");
                this.getModel().deleteEntryData(COM_ASSIST_ENTITY);
                if (CollectionUtils.isNotEmpty((Collection)comAssistDyns)) {
                    this.setComAssistEntry(comAssistDyns);
                }
            } else {
                this.getModel().deleteEntryData(COM_ASSIST_ENTITY);
            }
        } else if (SELECT_TYPE.equals(propName)) {
            String selectType = (String)changeSet[0].getNewValue();
            if ("1".equals(selectType)) {
                this.getModel().setValue(COM_ASSIST_MEMBER, null, changeSet[0].getRowIndex());
                this.getView().setEnable(Boolean.FALSE, changeSet[0].getRowIndex(), new String[]{COM_ASSIST_MEMBER});
                this.getView().setEnable(Boolean.TRUE, changeSet[0].getRowIndex(), new String[]{START_ASSIST_MEMBER, END_ASSIST_MEMBER});
            } else if ("2".equals(selectType)) {
                this.getModel().setValue(START_ASSIST_MEMBER, null, changeSet[0].getRowIndex());
                this.getModel().setValue(END_ASSIST_MEMBER, null, changeSet[0].getRowIndex());
                this.getView().setEnable(Boolean.TRUE, changeSet[0].getRowIndex(), new String[]{COM_ASSIST_MEMBER});
                this.getView().setEnable(Boolean.FALSE, changeSet[0].getRowIndex(), new String[]{START_ASSIST_MEMBER, END_ASSIST_MEMBER});
            } else {
                this.getModel().setValue(COM_ASSIST_MEMBER, null, changeSet[0].getRowIndex());
                this.getModel().setValue(START_ASSIST_MEMBER, null, changeSet[0].getRowIndex());
                this.getModel().setValue(END_ASSIST_MEMBER, null, changeSet[0].getRowIndex());
                this.getView().setEnable(Boolean.FALSE, changeSet[0].getRowIndex(), new String[]{COM_ASSIST_MEMBER, START_ASSIST_MEMBER, END_ASSIST_MEMBER});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection coll;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && actionId.endsWith(COM_ASSIST_MEMBER) && !(coll = (ListSelectedRowCollection)returnData).isEmpty()) {
            EntryGrid dimensionEntity = (EntryGrid)this.getControl(COM_ASSIST_ENTITY);
            int[] selectRows = dimensionEntity.getSelectRows();
            StringBuilder sb = new StringBuilder();
            for (ListSelectedRow row : coll) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getNumber())) continue;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(row.getNumber());
            }
            this.getModel().setValue(actionId, (Object)sb.toString(), selectRows[0]);
        }
    }

    private String buildReturnData() {
        StringBuilder returnData = new StringBuilder();
        DynamicObjectCollection comAssistEntity = this.getModel().getEntryEntity(COM_ASSIST_ENTITY);
        int index = 0;
        for (DynamicObject comAssistRow : comAssistEntity) {
            boolean isSelect = comAssistRow.getBoolean(IS_SELECT);
            if (isSelect) {
                boolean hasComAssistValue;
                String selectType = comAssistRow.getString(SELECT_TYPE);
                String startAssistMember = comAssistRow.getString(START_ASSIST_MEMBER);
                String endAssistMember = comAssistRow.getString(END_ASSIST_MEMBER);
                String comAssistMember = comAssistRow.getString(COM_ASSIST_MEMBER);
                String comAssistTypeNumber = CommonAssistUtil.getComassistField((int)(index + 1));
                returnData.append("|").append(comAssistTypeNumber).append("|");
                boolean bl = hasComAssistValue = StringUtils.isNotBlank((CharSequence)comAssistMember) || StringUtils.isNotBlank((CharSequence)startAssistMember) && StringUtils.isNotBlank((CharSequence)endAssistMember);
                if (hasComAssistValue) {
                    if ("1".equals(selectType)) {
                        returnData.append("[").append(startAssistMember).append(",").append(endAssistMember).append("]");
                    } else if ("2".equals(selectType)) {
                        returnData.append(comAssistMember);
                    }
                }
            }
            ++index;
        }
        return returnData.length() > 0 ? returnData.deleteCharAt(0).toString() : "";
    }

    private void setComAssistEntry(DynamicObjectCollection comAssistDyns) {
        IDataModel model = this.getModel();
        ArrayList<Integer> indexList = new ArrayList<Integer>(8);
        for (int index = 0; index < comAssistDyns.size(); ++index) {
            DynamicObject comAssistDyn = (DynamicObject)comAssistDyns.get(index);
            String comAssistName = comAssistDyn.getString("comassistname");
            if (StringUtils.isBlank((CharSequence)comAssistName)) continue;
            indexList.add(index);
        }
        if (CollectionUtils.isNotEmpty(indexList)) {
            model.batchCreateNewEntryRow(COM_ASSIST_ENTITY, indexList.size());
            int rowIndex = 0;
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                DynamicObject comAssistDyn = (DynamicObject)comAssistDyns.get(index);
                String comAssistName = comAssistDyn.getString("comassistname");
                model.setValue(COM_ASSIST, (Object)comAssistName, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{COM_ASSIST_MEMBER});
                ++rowIndex;
            }
        }
    }

    private void setAccountTable(long orgId, String accountBookTypeId) {
        if (orgId != 0L) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
            filterList.add(new QFilter(ORG, "=", (Object)orgId));
            if (StringUtils.isBlank((CharSequence)accountBookTypeId)) {
                DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)AccountBooksType.MAIN_BOOK.getValue())});
                if (bookTypeDyn != null) {
                    filterList.add(new QFilter("bookstype", "=", (Object)bookTypeDyn.getLong("id")));
                }
            } else {
                filterList.add(new QFilter("bookstype", "=", (Object)Long.parseLong(accountBookTypeId)));
            }
            DynamicObject accountBookDyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)ACCOUNT_TABLE, (QFilter[])filterList.toArray(new QFilter[0]));
            if (accountBookDyn != null) {
                this.getModel().setValue(ACCOUNT_TABLE, accountBookDyn.get(ACCOUNT_TABLE));
                DynamicObjectCollection comAssistDyns = QueryServiceHelper.query((String)"bd_accounttable", (String)"comassistentry.seq seq, comassistentry.comassistname comassistname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountBookDyn.getLong(ACCOUNT_TABLE))}, (String)"comassistentry.seq");
                if (CollectionUtils.isNotEmpty((Collection)comAssistDyns)) {
                    this.getModel().deleteEntryData(COM_ASSIST_ENTITY);
                    this.setComAssistEntry(comAssistDyns);
                }
            }
        }
    }
}

