/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.bdctrl.asstctl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;

public class AccountAssistFixAddPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(AccountAssistFixAddPlugin.class);
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"gl");
    protected static final String ACDEF = "defaultval";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{ACDEF});
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(listener -> {
            DynamicObject accounttable = (DynamicObject)this.getModel().getValue("accounttable");
            if (accounttable == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee\u8868", (String)"AccountAssistFixAddPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"AccountAssistFixAddPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
            listener.getCustomQFilters().add(AccountUtils.getAccountDataFilter((long)((Long)org.getPkValue()), (long)((Long)accounttable.getPkValue())));
            listener.getCustomQFilters().add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
            listener.getCustomQFilters().add(new QFilter("isassist", "=", (Object)true));
            listener.getCustomQFilters().add(new QFilter("createorg_id", "=", (Object)((Long)org.getPkValue())));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ACDEF.equals(key)) {
            QFilter orgFilter;
            int index = this.getModel().getEntryCurrentRowIndex("checkitementry");
            DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("checkitementry").get(index);
            if (row == null) {
                return;
            }
            DynamicObject asstacttype = row.getDynamicObject("asstactitem");
            String valuetype = asstacttype.getString("valuetype");
            if ("3".equals(valuetype)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("gl_assgrp_txtval_edit");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setdefaultval"));
                ArrayList<String> params = new ArrayList<String>(1);
                params.add(this.getModel().getValue(ACDEF, this.getModel().getEntryCurrentRowIndex("checkitementry")).toString());
                parameter.setCustomParam("params", params);
                this.getView().showForm(parameter);
                return;
            }
            if ("2".equals(valuetype)) {
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)false);
                long groupId = BusinessDataServiceHelper.loadSingle((Object)asstacttype.get("id"), (String)"bd_asstacttype").getDynamicObject("assistanttype").getLong("id");
                lsp.getListFilterParameter().setFilter(new QFilter("group", "=", (Object)groupId));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
                return;
            }
            DynamicObject valuesource = asstacttype.getDynamicObject("valuesource");
            String entityName = valuesource.getString("id");
            this.getPageCache().put("bd_entityname", entityName);
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)false);
            ListFilterParameter filterParam = lsp.getListFilterParameter();
            List qFilters = filterParam.getQFilters();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty statusProp = entityType.getProperty("status");
            if (statusProp != null) {
                qFilters.add(new QFilter("status", "=", (Object)"C"));
            }
            if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(this.getModel().getValue("org_id"))))) != null) {
                qFilters.add(orgFilter);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String errorMsg;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && StringUtils.isNotBlank((CharSequence)(errorMsg = this.checkBookRefer()))) {
            this.getView().showErrorNotification(errorMsg);
            args.setCancel(true);
            return;
        }
    }

    private String checkBookRefer() {
        String result = "";
        Object accounttable = this.getModel().getValue("accounttable");
        if (accounttable == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u68c0\u67e5\u7684\u79d1\u76ee\u8868", (String)"AccountAssistVersionControlCheckerPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"AccountAssistFixAddPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]);
        }
        DynamicObject account = (DynamicObject)this.getModel().getValue("account");
        if (account == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee", (String)"AccountAssistFixAddPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]);
        }
        logger.info("check_begin:" + accounttable);
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (name) {
            case "account": {
                DynamicObject account = (DynamicObject)this.getModel().getValue("account");
                DynamicObjectCollection checkitementry = account.getDynamicObjectCollection("checkitementry");
                model.deleteEntryData("checkitementry");
                for (DynamicObject assist : checkitementry) {
                    int index = model.createNewEntryRow("checkitementry");
                    model.setValue("asstactitem", (Object)assist.getDynamicObject("asstactitem"), index);
                    model.setValue("isrequire", assist.get("isrequire"), index);
                    model.setValue("isdetail", assist.get("isdetail"), index);
                    model.setValue("enaccheck", assist.get("enaccheck"), index);
                }
                break;
            }
            case "defaultval": {
                ChangeData changeData = changeSet[0];
                String newValue = (String)changeData.getNewValue();
                if (newValue != null && !newValue.equals("")) break;
                this.getModel().setValue("defaulid", (Object)"", changeData.getRowIndex());
                break;
            }
            case "isrequire": {
                ChangeData changeIsrequire = changeSet[0];
                boolean newIsrequire = (Boolean)changeIsrequire.getNewValue();
                if (newIsrequire) {
                    this.getView().setEnable(Boolean.valueOf(true), changeIsrequire.getRowIndex(), new String[]{"enaccheck", ACDEF});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), changeIsrequire.getRowIndex(), new String[]{"enaccheck", ACDEF});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (returnData != null && ACDEF.equals(actionId)) {
            ListSelectedRowCollection coll = (ListSelectedRowCollection)returnData;
            if (!coll.isEmpty()) {
                DynamicObject baseData;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("checkitementry");
                StringBuilder nameSb = new StringBuilder();
                StringBuilder valueSb = new StringBuilder();
                for (ListSelectedRow row : coll) {
                    if (nameSb.length() != 0) {
                        nameSb.append(',');
                        valueSb.append(',');
                    }
                    nameSb.append(row.getName());
                    valueSb.append(row.getPrimaryKeyValue());
                }
                this.getModel().setValue(actionId, (Object)nameSb.toString(), rowIndex);
                String entityName = this.getPageCache().get("bd_entityname");
                if (entityName != null) {
                    baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(valueSb.toString()), (String)entityName, (String)"masterid");
                    this.getModel().setValue("defaulid", (Object)baseData.get("masterid").toString(), rowIndex);
                    this.getPageCache().remove("bd_entityname");
                } else {
                    baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(valueSb.toString()), (String)"bos_assistantdata_detail", (String)"masterid");
                    this.getModel().setValue("defaulid", (Object)baseData.get("masterid").toString(), rowIndex);
                }
            }
        } else if (returnData != null && "setdefaultval".equals(actionId)) {
            this.getModel().setValue(ACDEF, (Object)returnData.toString(), this.getModel().getEntryCurrentRowIndex("checkitementry"));
            this.getModel().setValue("defaulid", (Object)returnData.toString(), this.getModel().getEntryCurrentRowIndex("checkitementry"));
        }
    }
}

