/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cfitem.bdctl.assign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.vo.AssignOrgTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.CashFlowItemNumTreeNode;

public class AssignCtx
implements Serializable {
    private static final long serialVersionUID = -8151636715987600933L;
    private Map<Long, Map<Long, String>> assignCheckResMap;
    private Long assignOrgID;
    private List<Long> dataIds;
    private List<Long> orgIds;
    private Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap;
    private Map<String, CashFlowItemNumTreeNode> cashFlowItemNumTreeNodeMap;
    private String ctrlstrategy;

    public AssignCtx(String entityId, Long assignOrgID, List<Long> dataIds, List<Long> orgIds) {
        this.assignOrgID = assignOrgID;
        this.dataIds = dataIds;
        this.orgIds = orgIds;
        this.assignOrgTreeNodeMap = new HashMap<Long, AssignOrgTreeNode>(16);
        this.cashFlowItemNumTreeNodeMap = new HashMap<String, CashFlowItemNumTreeNode>(16);
        this.assignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
        this.initCtrlstrategy(dataIds.get(0));
        this.buildOrgNodes();
        this.buildCashFlowItemNumNodes();
    }

    private void initCtrlstrategy(Long dataId) {
        DynamicObject cashFlowItem = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)"gl_cashflowitem");
        this.ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
    }

    private void buildOrgNodes() {
        if (null == this.orgIds || this.orgIds.size() == 0) {
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u4e3a\u7a7a", (String)"AssignCtx_0", (String)"fi-bd-common", (Object[])new Object[0])});
        }
        if (this.ctrlstrategy.equals("1")) {
            QFilter f2 = new QFilter("view", "=", (Object)10);
            QFilter f3 = new QFilter("org", "in", this.orgIds);
            DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);
            Object object = null;
            try {
                for (Row row : dt) {
                    Long orgId = row.getLong("org");
                    AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                    if (null != curorgNode) continue;
                    curorgNode = new AssignOrgTreeNode(orgId);
                    curorgNode.setParentId(row.getLong("parent"));
                    this.assignOrgTreeNodeMap.put(orgId, curorgNode);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dt != null) {
                    if (object != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            Set<Long> assignOrgIds = this.assignOrgTreeNodeMap.keySet();
            assignOrgIds = new HashSet<Long>(assignOrgIds);
            for (Long assignOrgId : assignOrgIds) {
                AssignOrgTreeNode curOrgNode = this.assignOrgTreeNodeMap.get(assignOrgId);
                Long parentOrgId = curOrgNode.getParentId();
                AssignOrgTreeNode parentOrgNode = this.assignOrgTreeNodeMap.computeIfAbsent(parentOrgId, k -> new AssignOrgTreeNode(k));
                parentOrgNode.getChildIds().add(assignOrgId);
            }
        } else if (this.ctrlstrategy.equals("2")) {
            for (Long orgId : this.orgIds) {
                AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                if (null != curorgNode) continue;
                curorgNode = new AssignOrgTreeNode(orgId);
                curorgNode.setParentId(this.assignOrgID);
                this.assignOrgTreeNodeMap.put(orgId, curorgNode);
            }
            AssignOrgTreeNode parentOrgNode = this.assignOrgTreeNodeMap.computeIfAbsent(this.assignOrgID, k -> new AssignOrgTreeNode(k));
            parentOrgNode.getChildIds().addAll(this.orgIds);
        }
    }

    private void buildCashFlowItemNumNodes() {
        Object number22;
        DynamicObject[] cashFlowItems;
        HashSet<Long> pidSet = new HashSet<Long>(this.dataIds.size());
        HashSet<Long> masteridSet = new HashSet<Long>(this.dataIds.size());
        for (DynamicObject dynamicObject : cashFlowItems = BusinessDataServiceHelper.load((Object[])this.dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"))) {
            masteridSet.add(dynamicObject.getLong("masterid"));
            number22 = dynamicObject.getString("number");
            CashFlowItemNumTreeNode node = this.cashFlowItemNumTreeNodeMap.computeIfAbsent((String)number22, k -> new CashFlowItemNumTreeNode((String)k));
            Iterator pnumber = dynamicObject.getString("parent.number");
            if (!StringUtils.isNotEmpty((CharSequence)((Object)pnumber))) continue;
            node.setPnumber((String)((Object)pnumber));
            CashFlowItemNumTreeNode pnode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent((String)((Object)pnumber), k -> new CashFlowItemNumTreeNode((String)k));
            pnode.getChildNumbers().add((String)number22);
            pidSet.add(dynamicObject.getLong("parent.id"));
        }
        if (pidSet.size() > 0) {
            this.fixAcctTreeDataComplete(new HashSet<Long>(this.dataIds), pidSet, masteridSet);
        }
        QFilter forgid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)this.assignOrgID);
        QFilter numberFilter = new QFilter("number", "in", this.cashFlowItemNumTreeNodeMap.keySet());
        Throwable throwable = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AssignCtx.buildCashFlowItemNumNodes", (String)"gl_cashflowitem", (String)"masterid", (QFilter[])new QFilter[]{forgid, numberFilter}, null);){
            for (Row row : ds) {
                masteridSet.add(row.getLong("masterid"));
            }
        }
        catch (Throwable number22) {
            Throwable throwable2 = number22;
            throw number22;
        }
        QFilter masteridFilter = new QFilter("masterid", "in", masteridSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AssignCtx.buildCashFlowItemNumNodes", (String)"gl_cashflowitem", (String)"id,number,masterid,longnumber", (QFilter[])new QFilter[]{forgid, masteridFilter}, null);
        number22 = null;
        try {
            HashMap<Long, Map> demoMap = new HashMap<Long, Map>(16);
            for (Row row : dataSet) {
                demoMap.computeIfAbsent(row.getLong("masterid"), k -> new HashMap(16)).put(row.getString("longnumber"), row.getString("number"));
            }
            for (Map.Entry entry : demoMap.entrySet()) {
                Map value = (Map)entry.getValue();
                if (value.size() <= 1) continue;
                ArrayList longNumbers = new ArrayList(value.keySet());
                longNumbers.sort(Comparator.comparingInt(String::length));
                for (int i = 0; i < longNumbers.size(); ++i) {
                    String longNumberNt = (String)longNumbers.get(i);
                    String numberNt = (String)value.get(longNumberNt);
                    CashFlowItemNumTreeNode node = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(numberNt, k -> new CashFlowItemNumTreeNode((String)k));
                    if (i <= 0) continue;
                    String longPnumberNt = (String)longNumbers.get(i - 1);
                    String pnumberNt = (String)value.get(longPnumberNt);
                    node.setPnumber(pnumberNt);
                    CashFlowItemNumTreeNode pnode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(pnumberNt, k -> new CashFlowItemNumTreeNode((String)k));
                    pnode.getChildNumbers().add(numberNt);
                }
            }
        }
        catch (Throwable demoMap) {
            number22 = demoMap;
            throw demoMap;
        }
        finally {
            if (dataSet != null) {
                if (number22 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable demoMap) {
                        ((Throwable)number22).addSuppressed(demoMap);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Set<Map.Entry<String, CashFlowItemNumTreeNode>> set = this.cashFlowItemNumTreeNodeMap.entrySet();
        for (Map.Entry<String, CashFlowItemNumTreeNode> treeNodeEntry : set) {
            CashFlowItemNumTreeNode node = treeNodeEntry.getValue();
            String pnumber = node.getPnumber();
            if (!StringUtils.isNotEmpty((CharSequence)pnumber)) continue;
            CashFlowItemNumTreeNode parentOrgNode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(pnumber, k -> new CashFlowItemNumTreeNode((String)k));
            parentOrgNode.getChildNumbers().add(treeNodeEntry.getKey());
        }
    }

    private void fixAcctTreeDataComplete(Set<Long> dataIDs, Set<Long> pidSet, Set<Long> masteridSet) {
        do {
            DynamicObject[] accts = BusinessDataServiceHelper.load((Object[])pidSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"));
            pidSet.clear();
            for (DynamicObject acct : accts) {
                String number = acct.getString("number");
                dataIDs.add((Long)acct.getPkValue());
                masteridSet.add(acct.getLong("masterid"));
                if (acct.getLong("parent.id") != 0L) {
                    pidSet.add(acct.getLong("parent.id"));
                }
                CashFlowItemNumTreeNode node = this.cashFlowItemNumTreeNodeMap.get(number);
                String pnumber = acct.getString("parent.number");
                if (!StringUtils.isNotEmpty((CharSequence)pnumber)) continue;
                node.setPnumber(pnumber);
                CashFlowItemNumTreeNode pnode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(pnumber, k -> new CashFlowItemNumTreeNode((String)k));
                pnode.getChildNumbers().add(number);
            }
        } while (pidSet.size() > 0);
    }

    public Long getAssignOrgID() {
        return this.assignOrgID;
    }

    public void setAssignOrgID(Long assignOrgID) {
        this.assignOrgID = assignOrgID;
    }

    public Map<Long, AssignOrgTreeNode> getAssignOrgTreeNodeMap() {
        return this.assignOrgTreeNodeMap;
    }

    public void setAssignOrgTreeNodeMap(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        this.assignOrgTreeNodeMap = assignOrgTreeNodeMap;
    }

    public Map<String, CashFlowItemNumTreeNode> getCashFlowItemNumTreeNodeMap() {
        return this.cashFlowItemNumTreeNodeMap;
    }

    public void setCashFlowItemNumTreeNodeMap(Map<String, CashFlowItemNumTreeNode> cashFlowItemNumTreeNodeMap) {
        this.cashFlowItemNumTreeNodeMap = cashFlowItemNumTreeNodeMap;
    }

    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public String getCtrlstrategy() {
        return this.ctrlstrategy;
    }

    public void setCtrlstrategy(String ctrlstrategy) {
        this.ctrlstrategy = ctrlstrategy;
    }

    public Map<Long, Map<Long, String>> getAssignCheckResMap() {
        return this.assignCheckResMap;
    }

    public void setAssignCheckResMap(Map<Long, Map<Long, String>> assignCheckResMap) {
        this.assignCheckResMap = assignCheckResMap;
    }

    public List<Long> getDataIds() {
        return this.dataIds;
    }

    public void setDataIds(List<Long> dataIds) {
        this.dataIds = dataIds;
    }
}

