/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cfitem.bdctl.unassign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.AssignOrgTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.AssignUtil;
import kd.fi.gl.formplugin.cfitem.bdctl.CashFlowItemNumTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.unassign.OrgCashFlowItemAndParent;
import kd.fi.gl.formplugin.cfitem.bdctl.unassign.OrgCashFlowItemInfo;
import kd.fi.gl.formplugin.cfitem.bdctl.unassign.OrgSingleAssignCtx;
import kd.fi.gl.formplugin.cfitem.bdctl.unassign.UnAssignCtx;

public class HandleBeforeUnAssign {
    private static Log LOG = LogFactory.getLog(HandleBeforeUnAssign.class);
    public UnAssignCtx assignCtx;

    public HandleBeforeUnAssign(String entityId, Map<Long, Set<Long>> cancelDataMap) {
        if (DebugTrace.enable()) {
            LOG.info("HandleBeforeUnAssign_construct_start");
            LOG.info(String.format("HandleBeforeUnAssign_construct_cancelDataMap[%1$s]", SerializationUtils.toJsonString(cancelDataMap)));
        }
        this.assignCtx = new UnAssignCtx(cancelDataMap);
    }

    public Map<Long, Map<Long, String>> handle() {
        try {
            boolean pass;
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_handle_start");
            }
            if (pass = this.checkUnAssignRes(this.assignCtx)) {
                Map<Long, AssignOrgTreeNode> orgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
                List orgIds = orgTreeNodeMap.entrySet().stream().filter(e -> ((AssignOrgTreeNode)e.getValue()).getChildIds().size() == 0).map(x -> ((AssignOrgTreeNode)x.getValue()).getId()).collect(Collectors.toList());
                ArrayList<Long> parentOrgIds = new ArrayList<Long>(10);
                while (orgIds.size() > 0) {
                    for (Long orgId : orgIds) {
                        Long thisOrgParentIds = this.doUnAssign(orgId);
                        if (thisOrgParentIds == null || thisOrgParentIds <= 0L) continue;
                        parentOrgIds.add(thisOrgParentIds);
                    }
                    orgIds.clear();
                    orgIds.addAll(parentOrgIds);
                    parentOrgIds.clear();
                }
            } else {
                this.assignCtx.getDataIds().clear();
            }
        }
        catch (KDBizException e2) {
            LOG.error("HandleBeforeUnAssign_handle", (Throwable)e2);
        }
        catch (Exception e3) {
            LOG.error("HandleBeforeUnAssign_handle", (Throwable)e3);
            throw e3;
        }
        return this.assignCtx.getUnAssignCheckResMap();
    }

    private Long doUnAssign(Long orgId) {
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_doUnAssign_orgId[%1$d]", orgId));
        }
        OrgSingleAssignCtx orgSingleAssignCtx = new OrgSingleAssignCtx(this.assignCtx, orgId);
        this.buildOrgAcctParentAndOtherParents(orgSingleAssignCtx);
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_buildOrgAcctParentAndOtherParents_orgSingleAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)orgSingleAssignCtx)));
        }
        this.unAssignExcuter(orgSingleAssignCtx);
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
        AssignOrgTreeNode assignOrgTreeNode = assignOrgTreeNodeMap.get(orgId);
        Long parentId = assignOrgTreeNode.getParentId();
        return parentId;
    }

    private boolean checkUnAssignRes(UnAssignCtx ctx) {
        boolean pass = true;
        Map<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatas = ctx.getOrgAndDatas();
        for (Map.Entry<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatasEntry : orgAndDatas.entrySet()) {
            long useOrgId = orgAndDatasEntry.getKey();
            Map<String, OrgCashFlowItemInfo> datasMap = orgAndDatasEntry.getValue();
            Set<String> numbers = datasMap.keySet();
            if (null == numbers || numbers.size() == 0) {
                if (!DebugTrace.enable()) continue;
                LOG.info("HandleBeforeUnAssign_checkUnAssignRes_numbers_isNull");
                continue;
            }
            pass = this.checkLeaf(ctx, useOrgId, datasMap, numbers);
            Map<String, List<Long>> newParamsMap = this.getUseRegDataByCashFlowItemAndOrg(numbers, useOrgId);
            for (Map.Entry<String, List<Long>> newParamsEntry : newParamsMap.entrySet()) {
                String number = newParamsEntry.getKey();
                List<Long> newParamsE = newParamsEntry.getValue();
                if (DebugTrace.enable()) {
                    LOG.info(String.format("HandleBeforeUnAssign_checkUnAssignRes_useOrgId[%1$s],number[%2$s],newParamsE[%3$s],ctx[%4$s]", useOrgId, number, SerializationUtils.toJsonString(newParamsE), SerializationUtils.toJsonString((Object)ctx)));
                }
                if (!this.isCashFlowItemUsed(useOrgId, number, newParamsE, ctx)) continue;
                this.unDisParentAndSelfAcct(datasMap, number);
                this.unDisParentAndSelfOrgAcct(ctx, number, useOrgId);
            }
        }
        Map<Long, Map<Long, String>> unAssignCheckResMap = ctx.getUnAssignCheckResMap();
        if (unAssignCheckResMap != null && unAssignCheckResMap.size() > 0) {
            pass = false;
        }
        return pass;
    }

    private boolean checkLeaf(UnAssignCtx ctx, long useOrgId, Map<String, OrgCashFlowItemInfo> datasMap, Set<String> numbers) {
        boolean pass = true;
        try (DataSet dataSet = CashflowRelationFactory.get().queryDataInfoByNumber(useOrgId, null, "id,parent.number,number");){
            for (Row row : dataSet) {
                String number = row.getString("parent.number");
                if (number == null || !numbers.contains(number) || numbers.contains(row.getString("number"))) continue;
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u9879\u76ee\u4e0d\u80fd\u53d6\u6d88\uff0c\u4e0b\u7ea7\u7ec4\u7ec7%2$s\u5b58\u5728\u4e0b\u7ea7\u9879\u76ee%3$s\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u914d\u4e0b\u7ea7\u9879\u76ee\u3002", (String)"HandleBeforeUnAssign_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), number, AssignUtil.getOrgNameById(useOrgId), row.getString("number"));
                Optional<Map.Entry> entry = ctx.getDataIdNumbers().entrySet().stream().filter(x -> ((String)x.getValue()).equals(number)).findFirst();
                Long dataId = entry.isPresent() ? (Long)entry.get().getKey() : Long.valueOf(0L);
                ctx.getUnAssignCheckResMap().computeIfAbsent(dataId, k -> new HashMap(16)).put(useOrgId, msg);
                this.unDisParentAndSelfAcct(datasMap, number);
                this.unDisParentAndSelfOrgAcct(ctx, number, useOrgId);
                pass = false;
            }
        }
        return pass;
    }

    private void unDisParentAndSelfOrgAcct(UnAssignCtx ctx, String number, long useOrgId) {
        Map<Long, AssignOrgTreeNode> treeMap = ctx.getAssignOrgTreeNodeMap();
        Map<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatas = ctx.getOrgAndDatas();
        this.setParentOrgAcctRef(number, useOrgId, treeMap, orgAndDatas);
    }

    private void setParentOrgAcctRef(String number, long useOrgId, Map<Long, AssignOrgTreeNode> treeMap, Map<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatas) {
        Map<String, OrgCashFlowItemInfo> orgCashFlowItem;
        do {
            orgCashFlowItem = null;
            AssignOrgTreeNode treeNode = treeMap.get(useOrgId);
            Long parentOrgId = treeNode.getParentId();
            if (null == parentOrgId || parentOrgId <= 0L || null == (orgCashFlowItem = orgAndDatas.get(parentOrgId))) continue;
            orgCashFlowItem.get(number).setRef(true);
            this.unDisParentAndSelfAcct(orgCashFlowItem, number);
            useOrgId = parentOrgId;
        } while (null != orgCashFlowItem);
    }

    private void unDisParentAndSelfAcct(Map<String, OrgCashFlowItemInfo> datasMap, String number) {
        for (Map.Entry<String, OrgCashFlowItemInfo> datasEntry : datasMap.entrySet()) {
            String num = datasEntry.getKey();
            if (!number.contains(num)) continue;
            OrgCashFlowItemInfo parentAndSelfCashFlowItemInfo = datasMap.get(num);
            parentAndSelfCashFlowItemInfo.setRef(true);
        }
    }

    private Map<String, List<Long>> getUseRegDataByCashFlowItemAndOrg(Set<String> numbers, Long orgId) {
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(16);
        ArrayList<String> numbersList = new ArrayList<String>(numbers);
        try (DataSet dataSet = CashflowRelationFactory.get().queryAssignDataByNumbers(orgId.longValue(), numbersList);){
            for (Row row : dataSet) {
                params.computeIfAbsent(row.getString("fnumber"), k -> new ArrayList(10)).add(row.getLong("fid"));
            }
        }
        return params;
    }

    private boolean isCashFlowItemUsed(long useOrgId, String cashFlowItemNumber, List<Long> cashFlowItemIds, UnAssignCtx ctx) {
        DynamicObjectCollection cashFlowItems = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id,startdate", (QFilter[])new QFilter("id", "in", cashFlowItemIds).toArray());
        Map<Long, Date> idDateMap = cashFlowItems.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getDate("startdate")));
        if (idDateMap == null || idDateMap.isEmpty()) {
            LOG.error(String.format("failed to find CashFlowItem,useorgId(%1$d),cashFlowItemNumber(%2$s):", useOrgId, cashFlowItemNumber));
            return false;
        }
        ArrayList<Object> orgIds = new ArrayList<Object>(1);
        orgIds.add(useOrgId);
        if (DebugTrace.enable()) {
            LOG.info("HandleBeforeUnAssign_handle_existOnLaterPeriods,start");
        }
        boolean existOnLaterPeriods = false;
        for (Long cashFlowItemId : cashFlowItemIds) {
            String existBillTypeRefMsg;
            if (idDateMap.get(cashFlowItemId) == null) {
                LOG.error(String.format("failed to find CashFlowItem,cashFlowItemId(%1$d)", cashFlowItemId));
                continue;
            }
            if (DebugTrace.enable()) {
                LOG.info(String.format("HandleBeforeUnAssign_handle_existOnLaterPeriods,cashFlowItemId[%1$d], orgIds[%2$s],date[%3$s]", cashFlowItemId, ((Object)orgIds).toString(), idDateMap.get(cashFlowItemId).toString()));
            }
            if ((existBillTypeRefMsg = this.existBillTypeRef(cashFlowItemNumber, orgIds)) != null) {
                if (DebugTrace.enable()) {
                    LOG.info("HandleBeforeUnAssign_handle_start");
                }
                String msg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%1$s\uff09\u5728\uff08%2$s\uff09\u4e2d\u5b58\u5728\u5f15\u7528\uff0c\u8bf7\u5bf9\u7ec4\u7ec7\uff08%3$s\uff09\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%4$s\uff09\u8fdb\u884c\u68c0\u67e5\u3002", (String)"HandleBeforeUnAssign_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), cashFlowItemNumber, existBillTypeRefMsg, AssignUtil.getOrgNameById(useOrgId), cashFlowItemNumber);
                Set<Long> dataIDs = ctx.getDataIds();
                Long next = dataIDs.iterator().next();
                ctx.getUnAssignCheckResMap().computeIfAbsent(next, k -> new HashMap(16)).put(useOrgId, msg);
                existOnLaterPeriods = true;
                break;
            }
            if (!CashflowItemCheckUtil.existOnLaterPeriods((long)cashFlowItemId, orgIds, (Date)idDateMap.get(cashFlowItemId))) continue;
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_handle_start");
            }
            String msg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%1$s\uff09\u5df2\u7ecf\u53d1\u751f\u4e1a\u52a1\uff0c\u8bf7\u5bf9\u7ec4\u7ec7\uff08%2$s\uff09\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%3$s\uff09\u8fdb\u884c\u68c0\u67e5\u3002", (String)"HandleBeforeUnAssign_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), cashFlowItemNumber, AssignUtil.getOrgNameById(useOrgId), cashFlowItemNumber);
            Set<Long> dataIDs = ctx.getDataIds();
            Long next = dataIDs.iterator().next();
            ctx.getUnAssignCheckResMap().computeIfAbsent(next, k -> new HashMap(16)).put(useOrgId, msg);
            existOnLaterPeriods = true;
            break;
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_handle_existOnLaterPeriods_result[%1$s]", existOnLaterPeriods));
        }
        return existOnLaterPeriods;
    }

    private String existBillTypeRef(String cashFlowItemNumber, List<Object> orgIds) {
        if (this.templeteVoucherRefChecker(cashFlowItemNumber, orgIds)) {
            return ResManager.loadKDString((String)"\u6a21\u5f0f\u51ed\u8bc1", (String)"HandleBeforeUnAssign_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        if (this.presetCashFlowItemRefChecker(cashFlowItemNumber, orgIds)) {
            return ResManager.loadKDString((String)"\u79d1\u76ee\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb", (String)"HandleBeforeUnAssign_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean templeteVoucherRefChecker(String cashFlowItemNumber, List<Object> orgIds) {
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("select TOP 1 a.fid from T_GL_TEMPLATEVOUCHER as a ", new Object[0]);
        balSql.append(" inner join T_GL_TEMPLATEVOUCHERENTRY as b on a.fid=b.fid ", new Object[0]);
        balSql.append(" left join T_GL_CASHFLOWITEM as c on c.fid=b.fmaincfitemid ", new Object[0]);
        balSql.append(" left join T_GL_CASHFLOWITEM as d on d.fid=b.fsuppcfitemid ", new Object[0]);
        balSql.append(" where (c.fnumber = ? or d.fnumber = ? ) ", new Object[]{cashFlowItemNumber, cashFlowItemNumber});
        if (CollectionUtils.isNotEmpty(orgIds)) {
            balSql.appendIn(" and a.forgid", orgIds);
        }
        return this.executeSql(balSql);
    }

    private boolean presetCashFlowItemRefChecker(String cashFlowItemNumber, List<Object> orgIds) {
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("select TOP 1 a.fid from t_gl_presetcashflowitem as a ", new Object[0]);
        balSql.append(" inner join T_GL_CASHFLOWITEM as b on b.fid=a.fgroupid  ", new Object[0]);
        balSql.append(" where b.fnumber = ? ", new Object[]{cashFlowItemNumber});
        if (CollectionUtils.isNotEmpty(orgIds)) {
            balSql.appendIn(" and a.fcreateorgid ", orgIds);
        }
        return this.executeSql(balSql);
    }

    private boolean executeSql(SqlBuilder sqlBuilder) {
        DataSet ds = DB.queryDataSet((String)"CashflowChecker", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        return ds.hasNext();
    }

    private void buildOrgAcctParentAndOtherParents(OrgSingleAssignCtx orgSingleAssignCtx) {
        Date fenddate;
        OrgCashFlowItemAndParent orgCashFlowItemAndParent;
        String fnumber;
        UnAssignCtx assignCtx = orgSingleAssignCtx.getAssignCtx();
        Map<String, OrgCashFlowItemAndParent> orgCashFlowItemAndParentMap = orgSingleAssignCtx.getOrgCashFlowItemAndParentMap();
        Long userOrgId = orgSingleAssignCtx.getUseOrgid();
        Set<Object> cashFlowItemIds = new HashSet(100);
        ArrayList<String> cashflowNumbers = new ArrayList<String>();
        Map<String, OrgCashFlowItemInfo> orgCashFlowItemInfoMap = assignCtx.getOrgAndDatas().get(userOrgId);
        if (orgCashFlowItemInfoMap == null || orgCashFlowItemInfoMap.size() == 0) {
            cashFlowItemIds = assignCtx.getDataIds();
            cashflowNumbers.addAll(assignCtx.getDataIdNumbers().values());
        } else {
            for (Map.Entry<String, OrgCashFlowItemInfo> orgCashFlowItemInfoEntry : orgCashFlowItemInfoMap.entrySet()) {
                cashFlowItemIds.addAll(orgCashFlowItemInfoEntry.getValue().getCashFlowItemIds());
                cashflowNumbers.add(orgCashFlowItemInfoEntry.getValue().getCashFlowItemNumber());
            }
        }
        ArrayList<Object> CashFlowItemIdList = new ArrayList<Object>(cashFlowItemIds);
        try (DataSet dataSet = AssignUtil.findVersionCashFlowItemsByIdsAndOrg(userOrgId, CashFlowItemIdList);){
            for (Row row : dataSet) {
                fnumber = row.getString("fnumber");
                orgCashFlowItemAndParent = orgCashFlowItemAndParentMap.get(fnumber);
                if (null == orgCashFlowItemAndParent) {
                    orgCashFlowItemAndParent = new OrgCashFlowItemAndParent();
                    orgCashFlowItemAndParentMap.put(fnumber, orgCashFlowItemAndParent);
                    orgCashFlowItemAndParent.setOrgId(userOrgId);
                    orgCashFlowItemAndParent.setCashFlowItemNum(fnumber);
                }
                fenddate = row.getDate("fenddate");
                Long id = row.getLong("fid");
                if (fenddate.compareTo(CashflowItemVersionUtil.getEndDate()) == 0) {
                    Long masterid = row.getLong("fmasterid");
                    orgCashFlowItemAndParent.setCashFlowItemMasterId(masterid);
                    orgCashFlowItemAndParent.setCtrlstrategy(row.getString("fctrlstrategy"));
                    orgCashFlowItemAndParent.setCreateOrgId(row.getLong("fcreateorgid"));
                }
                orgCashFlowItemAndParent.getVersionIds().add(id);
                orgCashFlowItemAndParent.getVersionIDEndDateMap().put(id, fenddate);
                orgCashFlowItemAndParent.getUseregIds().add(id);
                orgCashFlowItemAndParent.getExcIds().add(id);
            }
        }
        dataSet = CashflowRelationFactory.get().queryAssignDataByNumbers(userOrgId.longValue(), cashflowNumbers);
        var10_10 = null;
        try {
            for (Row row : dataSet) {
                fnumber = row.getString("fnumber");
                orgCashFlowItemAndParent = orgCashFlowItemAndParentMap.get(fnumber);
                if (null == orgCashFlowItemAndParent) {
                    orgCashFlowItemAndParent = new OrgCashFlowItemAndParent();
                    orgCashFlowItemAndParentMap.put(fnumber, orgCashFlowItemAndParent);
                    orgCashFlowItemAndParent.setOrgId(userOrgId);
                    orgCashFlowItemAndParent.setCashFlowItemNum(fnumber);
                    fenddate = row.getDate("fenddate");
                    if (fenddate.compareTo(CashflowItemVersionUtil.getEndDate()) == 0) {
                        Long masterid = row.getLong("fmasterid");
                        orgCashFlowItemAndParent.setCashFlowItemMasterId(masterid);
                        orgCashFlowItemAndParent.setCtrlstrategy(row.getString("fctrlstrategy"));
                        orgCashFlowItemAndParent.setCreateOrgId(row.getLong("fcreateorgid"));
                    }
                }
                orgCashFlowItemAndParent.getUseregIds().add(row.getLong("fid"));
                orgCashFlowItemAndParent.getExcIds().add(row.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var10_10 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        dataSet = CashflowRelationFactory.get().queryExcDataIdByNumber(userOrgId.longValue(), cashflowNumbers);
        var10_10 = null;
        try {
            for (Row row : dataSet) {
                fnumber = row.getString("fnumber");
                orgCashFlowItemAndParent = orgCashFlowItemAndParentMap.get(fnumber);
                if (null == orgCashFlowItemAndParent) continue;
                orgCashFlowItemAndParent.getExcIds().add(row.getLong("fdataid"));
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var10_10 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    private void unAssignExcuter(OrgSingleAssignCtx orgSingleAssignCtx) {
        Set numbers;
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_unAssignExcuter_orgSingleAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)orgSingleAssignCtx)));
        }
        UnAssignCtx assignCtx = orgSingleAssignCtx.getAssignCtx();
        Map<String, OrgCashFlowItemAndParent> oapopMap = orgSingleAssignCtx.getOrgCashFlowItemAndParentMap();
        if (null == oapopMap) {
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_unAssignExcuter_oapopMap_isnull");
            }
            return;
        }
        Long orgId = orgSingleAssignCtx.getUseOrgid();
        Map<String, OrgCashFlowItemInfo> orgCashFlowItemInfoMap = assignCtx.getOrgAndDatas().get(orgId);
        if (orgCashFlowItemInfoMap == null) {
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_unAssignExcuter_orgCashFlowItemInfoMap_isnull");
            }
            return;
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_unAssignExcuter_orgCashFlowItemInfoMap[%1$s]", SerializationUtils.toJsonString(orgCashFlowItemInfoMap)));
        }
        if (null == (numbers = orgCashFlowItemInfoMap.entrySet().stream().filter(e -> ((OrgCashFlowItemInfo)e.getValue()).getRef() == false).map(x -> (String)x.getKey()).collect(Collectors.toSet()))) {
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_unAssignExcuter_numbers_isnull");
            }
            return;
        }
        Map<String, CashFlowItemNumTreeNode> CashFlowItemNumTreeNodeMap = assignCtx.getAssignAcctountNumTreeNodeMap();
        List cashFlowItemNumbers = CashFlowItemNumTreeNodeMap.entrySet().stream().filter(e -> ((CashFlowItemNumTreeNode)e.getValue()).getChildNumbers().size() == 0).filter(e -> numbers.contains(((CashFlowItemNumTreeNode)e.getValue()).getNumber())).map(x -> ((CashFlowItemNumTreeNode)x.getValue()).getNumber()).collect(Collectors.toList());
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_unAssignExcuter_cashFlowItemNumbers[%1$s]", SerializationUtils.toJsonString(cashFlowItemNumbers)));
        }
        do {
            for (String acctNumber : cashFlowItemNumbers) {
                this.excuteUnAssign(assignCtx, oapopMap, orgId, acctNumber);
            }
            HashSet<String> pnumberSet = new HashSet<String>(10);
            for (String acctNumber : cashFlowItemNumbers) {
                String pnumber;
                CashFlowItemNumTreeNode assignCashFlowItemNumTreeNode = CashFlowItemNumTreeNodeMap.get(acctNumber);
                if (null == assignCashFlowItemNumTreeNode || !StringUtils.isNotEmpty((CharSequence)(pnumber = assignCashFlowItemNumTreeNode.getPnumber())) || !numbers.contains(pnumber)) continue;
                pnumberSet.add(pnumber);
            }
            cashFlowItemNumbers.clear();
            cashFlowItemNumbers.addAll(pnumberSet);
        } while (!cashFlowItemNumbers.isEmpty());
    }

    private void excuteUnAssign(UnAssignCtx assignCtx, Map<String, OrgCashFlowItemAndParent> oapopMap, Long orgId, String acctNumber) {
        OrgCashFlowItemAndParent orgCashFlowItemAndParent;
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_excuteUnAssign_assignCtx[%1$s],oapopMap[%2$s],orgId[%3$d],acctNumber[%4$s]", SerializationUtils.toJsonString((Object)assignCtx), SerializationUtils.toJsonString(oapopMap), orgId, acctNumber));
        }
        if (null == (orgCashFlowItemAndParent = oapopMap.get(acctNumber))) {
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_excuteUnAssign_orgCashFlowItemAndParent_isNull");
            }
            return;
        }
        Set<Long> versionIds = orgCashFlowItemAndParent.getVersionIds();
        if (versionIds.size() > 0) {
            OperationResult result;
            if (DebugTrace.enable()) {
                LOG.info("HandleBeforeUnAssign_excuteUnAssign_excute(deleteVersion)_start");
            }
            if ((result = this.deleteVersion(orgId, orgCashFlowItemAndParent)) != null && !result.isSuccess()) {
                if (DebugTrace.enable()) {
                    LOG.info("HandleBeforeUnAssign_excuteUnAssign_excute(deleteVersion)_false");
                }
                HashSet<String> numbers = new HashSet<String>(10);
                this.findAllpNumbers(assignCtx, acctNumber, numbers);
                HashSet<Long> orgIds = new HashSet<Long>(10);
                this.findAllPOrgs(assignCtx, orgId, orgIds);
                this.removeFailNumbers(assignCtx, numbers, orgIds);
                StringBuilder msgSb = new StringBuilder();
                List valResults = result.getValidateResult().getValidateErrors();
                for (ValidateResult validateResult : valResults) {
                    for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                        msgSb.append(errorInfo.getMessage()).append("\r\n");
                    }
                }
                if (StringUtils.isBlank((CharSequence)msgSb)) {
                    msgSb.append(result.getMessage());
                }
                String msg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u62a5\u9519\uff0c\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801\uff1a%1$s,\u7ec4\u7ec7\u540d\u79f0\uff1a%2$s,\u62a5\u9519\u4fe1\u606f\uff1a%3$s\u3002", (String)"HandleBeforeUnAssign_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), acctNumber, AssignUtil.getOrgNameById(orgId), msgSb.toString());
                if (DebugTrace.enable()) {
                    LOG.info(String.format("HandleBeforeUnAssign_excuteUnAssign_excute(deleteVersion)_false_msg(%1$s)", msg));
                }
                Set<Long> useregIds = orgCashFlowItemAndParent.getUseregIds();
                for (Long useregId : useregIds) {
                    if (!assignCtx.getDataIds().contains(useregId)) continue;
                    assignCtx.getUnAssignCheckResMap().computeIfAbsent(useregId, k -> new HashMap(16)).put(orgId, msg);
                }
                throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
            }
        }
        Set<Long> useregIds = orgCashFlowItemAndParent.getUseregIds();
        Set<Long> excIds = orgCashFlowItemAndParent.getExcIds();
        ArrayList<Object[]> params = new ArrayList<Object[]>(useregIds.size() + excIds.size());
        for (Long useregId : useregIds) {
            params.add(new Object[]{useregId, orgId});
        }
        for (Long excId : excIds) {
            params.add(new Object[]{excId, orgId});
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeUnAssign_excuteUnAssign_AssignUtil.clearCache[%1$s]", SerializationUtils.toJsonString(params)));
        }
        if (params != null && !params.isEmpty()) {
            CashflowRelationFactory.get().deleteUseRange(params);
        }
    }

    private OperationResult deleteVersion(Long orgId, OrgCashFlowItemAndParent orgCashFlowItemAndParent) {
        ArrayList<Map.Entry<Long, Date>> versionAcctIDEndDateSet = new ArrayList<Map.Entry<Long, Date>>(orgCashFlowItemAndParent.getVersionIDEndDateMap().entrySet());
        Comparator<Map.Entry<Long, Date>> versionAcctIDEndDateSetComparator = new Comparator<Map.Entry<Long, Date>>(){

            @Override
            public int compare(Map.Entry<Long, Date> arg0, Map.Entry<Long, Date> arg1) {
                return -arg0.getValue().compareTo(arg1.getValue());
            }
        };
        Collections.sort(versionAcctIDEndDateSet, versionAcctIDEndDateSetComparator);
        OperateOption operation = OperateOption.create();
        operation.setVariableValue("useorg", String.valueOf(orgId));
        operation.setVariableValue("createOrg", String.valueOf(orgId));
        operation.setVariableValue("versiondelete", "1");
        CashflowItemOptionVarManager.setIsassign((OperateOption)operation, (boolean)true);
        OperationResult result = null;
        for (Map.Entry<Long, Date> versionAcctIDEndDateEnty : versionAcctIDEndDateSet) {
            result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_cashflowitem", (Object[])new Object[]{versionAcctIDEndDateEnty.getKey()}, (OperateOption)operation);
            if (result.isSuccess()) continue;
            return result;
        }
        orgCashFlowItemAndParent.getVersionIds().clear();
        orgCashFlowItemAndParent.getVersionIDEndDateMap().clear();
        return result;
    }

    private void removeFailNumbers(UnAssignCtx assignCtx, Set<String> numbers, Set<Long> orgIds) {
        Map<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatas = assignCtx.getOrgAndDatas();
        for (Long orgId : orgIds) {
            Map<String, OrgCashFlowItemInfo> datasMap = orgAndDatas.get(orgId);
            for (String number : numbers) {
                datasMap.remove(number);
            }
        }
    }

    private void findAllPOrgs(UnAssignCtx assignCtx, Long orgId, Set<Long> orgIds) {
        AssignOrgTreeNode pNode;
        orgIds.add(orgId);
        do {
            Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap;
            if (null == (pNode = (assignOrgTreeNodeMap = assignCtx.getAssignOrgTreeNodeMap()).get(orgId).getParent())) continue;
            orgId = pNode.getParentId();
            orgIds.add(orgId);
        } while (pNode != null);
    }

    private void findAllpNumbers(UnAssignCtx assignCtx, String number, Set<String> numbers) {
        CashFlowItemNumTreeNode parent;
        numbers.add(number);
        do {
            String pnumber;
            parent = null;
            Map<String, CashFlowItemNumTreeNode> assignAcctountNumTreeNodeMap = assignCtx.getAssignAcctountNumTreeNodeMap();
            CashFlowItemNumTreeNode cashFlowItemNumTreeNode = assignAcctountNumTreeNodeMap.get(number);
            if (cashFlowItemNumTreeNode != null && (pnumber = cashFlowItemNumTreeNode.getPnumber()) != null && StringUtils.isNotEmpty((CharSequence)pnumber)) {
                parent = assignAcctountNumTreeNodeMap.get(pnumber);
            }
            if (null == parent) continue;
            number = parent.getNumber();
            numbers.add(number);
        } while (null != parent);
    }
}

