/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.comassist;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.enums.ControlVisible;
import kd.fi.gl.formplugin.comassist.CommonAssistListPlugin;
import kd.fi.gl.util.GLUtil;

public class ComAssistFinalProcessListPlugin
extends CommonAssistListPlugin {
    private static final String NOT_NULL_CP = "is not null";

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Optional<ComAssistTable> commonAssistTable = this.getCommonAssistTable();
        List<ListColumn> comAssistListColumnList = args.getListColumns().stream().filter(ListColumn.class::isInstance).map(ListColumn.class::cast).filter(column -> column.getFieldKey().startsWith("comassist")).collect(Collectors.toList());
        if (commonAssistTable.isPresent()) {
            comAssistListColumnList.forEach(comAssistColumn -> {
                Optional commonAssist = ((ComAssistTable)commonAssistTable.get()).getCommonAssist(comAssistColumn.getFieldKey().split("\\.")[0]);
                if (commonAssist.isPresent() && ((CommonAssist)commonAssist.get()).isBalanced) {
                    ComAssistService.modifyListColumn((CommonAssist)((CommonAssist)commonAssist.get()), (IListColumn)comAssistColumn);
                } else {
                    comAssistColumn.setVisible(ControlVisible.hide.value);
                }
            });
        } else {
            comAssistListColumnList.forEach(comAssistColumn -> comAssistColumn.setVisible(ControlVisible.hide.value));
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        Optional<ComAssistTable> commonAssistTable = this.getCommonAssistTable();
        if (e.getSource() instanceof BillList) {
            List<ListColumn> comAssistListColumnList = ((BillList)e.getSource()).getShowListColumns().stream().filter(ListColumn.class::isInstance).map(ListColumn.class::cast).filter(column -> column.getFieldKey().startsWith("comassist")).collect(Collectors.toList());
            if (commonAssistTable.isPresent()) {
                comAssistListColumnList.forEach(comAssistColumn -> {
                    int visible;
                    Optional commonAssist = ((ComAssistTable)commonAssistTable.get()).getCommonAssist(comAssistColumn.getFieldKey().split("\\.")[0]);
                    Optional<Map> userConfigColumnSettings = Optional.ofNullable(comAssistColumn.getUserConfigColumnSettings());
                    int n = visible = commonAssist.isPresent() && ((CommonAssist)commonAssist.get()).isBalanced ? ControlVisible.show.value : ControlVisible.hide.value;
                    if (visible == ControlVisible.show.value) {
                        userConfigColumnSettings.ifPresent(config -> config.putIfAbsent("visible", ControlVisible.show.value));
                    } else {
                        userConfigColumnSettings.ifPresent(config -> config.put("visible", ControlVisible.hide.value));
                    }
                });
            } else {
                comAssistListColumnList.forEach(comAssistColumn -> {
                    Optional<Map> userConfigColumnSettings = Optional.ofNullable(comAssistColumn.getUserConfigColumnSettings());
                    userConfigColumnSettings.ifPresent(config -> config.put("visible", ControlVisible.hide.value));
                });
            }
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if (!property.contains("comassist")) continue;
            if (property.contains("name") && !qFilter.getCP().equals(NOT_NULL_CP)) {
                qFilter.or(QFilter.emptyOrNotExists((String)property));
                continue;
            }
            qFilter.or(new QFilter(property, "=", null));
        }
        this.getCommonAssistTable().ifPresent(x -> x.getBalancedCommonAssists().forEach(comAssist -> {
            if (CollectionUtils.isEmpty((Collection)GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)(comAssist.key + ".id")))) {
                ComAssistService.getDataPermIds((CommonAssist)comAssist, this.getOrgID(), (String)"id").ifPresent(ids -> e.getQFilters().add(new QFilter(this.getComAssistFilterField((CommonAssist)comAssist), "in", ids).or(new QFilter(this.getComAssistFilterField((CommonAssist)comAssist), "=", null))));
            }
        }));
    }

    private String getComAssistFilterField(CommonAssist commonAssist) {
        String billFormId = ((IListView)this.getView()).getBillFormId();
        String comAssistKey = commonAssist.key;
        switch (billFormId) {
            case "gl_autotrans": {
                return "autotransentry." + comAssistKey + ".fbasedataid.id";
            }
            case "gl_voucheramortacheme": {
                if ("comassist1".equals(comAssistKey)) {
                    return comAssistKey + ".id";
                }
                return "entryentity.";
            }
        }
        return comAssistKey + ".fbasedataid.id";
    }
}

