/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.comassist;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ThreadLocals;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.FieldConfig;
import org.apache.commons.beanutils.ConvertUtils;

public class ComAssistImportPlugin
extends BatchImportPlugin {
    protected int getBatchImportSize() {
        return 200;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (CollectionUtils.isNotEmpty(rowdatas)) {
            ImportHandler.cacheBillData((Map<String, Object>)rowdatas.get(0).getData());
        }
        return super.save(rowdatas, logger);
    }

    public static class ImportHandler {
        private static final ThreadLocal<Map<String, Object>> billDataThreadLocal = ThreadLocals.create();
        private static final Map<String, Class<?>> convertMap = ImmutableMap.of((Object)"id", Long.class, (Object)"number", String.class, (Object)"name", String.class);

        public static void cacheBillData(Map<String, Object> billData) {
            billDataThreadLocal.set(billData);
        }

        public static MainEntityType getEntityType(MainEntityType originalEntityType) {
            if (billDataThreadLocal.get() != null) {
                return ImportHandler.parseToEntityType(billDataThreadLocal.get(), originalEntityType);
            }
            return originalEntityType;
        }

        private static MainEntityType parseToEntityType(Map<String, Object> billData, MainEntityType originalEntityType) {
            Optional<ComAssistTable> tableOptional = ImportHandler.resolveBilldataToTable(billData, originalEntityType.getName());
            if (tableOptional.isPresent()) {
                return (MainEntityType)ThreadCache.get((Object)String.format("tableIdToEntityType$%s", tableOptional.get().getAcctTableID()), () -> (MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)((ComAssistTable)tableOptional.get()), (EntityType)originalEntityType));
            }
            LogFactory.getLog(ImportHandler.class).warn("resolveBilldataToTable error, billdata={}", billData);
            return originalEntityType;
        }

        private static Optional<ComAssistTable> resolveBilldataToTable(Map<String, Object> billdata, String formId) {
            Object orgMap = billdata.get(FieldConfig.getOrgAndBookTypeFieldKey((String)formId).item1);
            Object bookTypeMap = billdata.get(FieldConfig.getOrgAndBookTypeFieldKey((String)formId).item2);
            if (orgMap instanceof Map && bookTypeMap instanceof Map) {
                QFilter orgFilter = ImportHandler.parseMapToQFilter((Map)orgMap);
                QFilter bookTypeFilter = ImportHandler.parseMapToQFilter((Map)bookTypeMap);
                return ComAssistTable.get((Long)ImportHandler.queryId("bos_org", orgFilter), (Long)ImportHandler.queryId("bd_accountbookstype", bookTypeFilter));
            }
            return Optional.empty();
        }

        private static QFilter parseMapToQFilter(Map<String, Object> map) {
            for (Map.Entry<String, Class<?>> keyClassEntry : convertMap.entrySet()) {
                String propKey = keyClassEntry.getKey();
                Class<?> propType = keyClassEntry.getValue();
                Object valueBuf = map.get(propKey);
                if (valueBuf == null) continue;
                Object value = ConvertUtils.convert((Object)valueBuf, propType);
                return new QFilter(propKey, "=", value);
            }
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }

        private static long queryId(String entity, QFilter filter) {
            return (Long)ThreadCache.get((Object)String.join((CharSequence)"$", entity, filter.toString()), () -> {
                DynamicObject dyo = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])new QFilter[]{filter});
                return dyo == null ? 0L : dyo.getLong("id");
            });
        }
    }
}

