/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.comassist;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.FieldConfig;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class ComAssistListDataProvider
extends ListDataProvider {
    private final IFormView view;

    public ComAssistListDataProvider(IFormView view) {
        this.view = view;
    }

    public ComAssistListDataProvider() {
        this.view = null;
    }

    public EntityType getEntityType() {
        if (this.view == null) {
            return super.getEntityType();
        }
        EntityType originalType = super.getEntityType();
        EntityType newEntityType = this.getCommonAssistTable(originalType.getName()).map(table -> ComAssistTableService.modifyEntityType((ComAssistTable)table, (EntityType)originalType)).orElse(originalType);
        this.setEntityType(newEntityType);
        return newEntityType;
    }

    public String getEntityId() {
        return ((BillList)this.view.getControl("billlistap")).getEntityId();
    }

    public List<ListField> getListFields() {
        if (this.view == null) {
            return super.getListFields();
        }
        List listFields = super.getListFields();
        String entity = this.getEntityId();
        return this.getCommonAssistTable(entity).map(commonAssistTable -> ComAssistTableService.modifyListFields((ComAssistTable)commonAssistTable, (List)listFields)).orElse(listFields);
    }

    protected Optional<ComAssistTable> getCommonAssistTable(String entity) {
        return (Optional)ThreadCache.get((Object)(((Object)((Object)this)).getClass().getName() + ".getCommonAssistTable_"), () -> {
            List<Long> orgIdList = this.getOrgIds(entity);
            List<Long> bookTypeIdList = this.getBookTypeIds(entity);
            return ComAssistTable.tryGetMaxComAssist(new HashSet<Long>(orgIdList), new HashSet<Long>(bookTypeIdList));
        }, (boolean)true);
    }

    protected Long getDefaultOrgID() {
        long defaultOrg = Long.parseLong(Optional.ofNullable(this.view.getPageCache().get("initorg")).orElse("0"));
        if (defaultOrg == 0L) {
            List<Long> orgList = AccSysUtil.getAcctOrgComboItem((String)this.getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW).stream().map(item -> Long.parseLong(item.getValue())).collect(Collectors.toList());
            defaultOrg = Optional.ofNullable(GlFormUtil.getDefaultAcctOrg(orgList)).orElse(0L);
            this.view.getPageCache().put("initorg", defaultOrg + "");
        }
        return defaultOrg;
    }

    protected Long getDefaultBookTypeID() {
        long defaultOrg = Long.parseLong(Optional.ofNullable(this.view.getPageCache().get("initbt")).orElse("0"));
        if (defaultOrg == 0L) {
            defaultOrg = AccSysUtil.getBookTypeComboByOrg((long)this.getDefaultOrgID()).stream().mapToLong(item -> Long.parseLong(item.getValue())).findFirst().orElse(0L);
            this.view.getPageCache().put("initbt", defaultOrg + "");
        }
        return defaultOrg;
    }

    protected List<Long> getOrgIds(String entity) {
        List<Long> filterValues = CommonAssistUtil.getOrgCommonFilterColumnValues((IFormView)this.getView(), (String)((String)FieldConfig.getOrgAndBookTypeFieldKey((String)entity).item1));
        this.view.getPageCache().put("alluseorg", JSONObject.toJSONString((Object)filterValues));
        return filterValues.size() == 0 ? Collections.singletonList(this.getDefaultOrgID()) : filterValues;
    }

    protected List<Long> getBookTypeIds(String entity) {
        List<Long> filterValues = CommonAssistUtil.getBookTypeCommonFilterColumnValues((IFormView)this.getView(), (String)((String)FieldConfig.getOrgAndBookTypeFieldKey((String)entity).item2));
        return filterValues.size() == 0 ? Collections.singletonList(this.getDefaultBookTypeID()) : filterValues;
    }

    protected Long getOrgID(String entity) {
        List filterValues = CommonAssistUtil.getOrgCommonFilterColumnValues((IFormView)this.getView(), (String)((String)FieldConfig.getOrgAndBookTypeFieldKey((String)entity).item1));
        this.view.getPageCache().put("alluseorg", JSONObject.toJSONString((Object)filterValues));
        return filterValues.size() == 0 ? this.getDefaultOrgID() : (Long)filterValues.get(0);
    }

    protected Long getBookTypeID(String entity) {
        List filterValues = CommonAssistUtil.getBookTypeCommonFilterColumnValues((IFormView)this.getView(), (String)((String)FieldConfig.getOrgAndBookTypeFieldKey((String)entity).item2));
        return filterValues.size() == 0 ? this.getDefaultBookTypeID() : (Long)filterValues.get(0);
    }

    public IFormView getView() {
        return this.view;
    }
}

