/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.comassist;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.exception.GLErrorCode;

public class ComAssistReportFormPlugin
extends AbstractReportFormPlugin {
    private static final String ACCOUNT_TABLE_CACHE_KEY = "cache_accounttableid";
    private MainEntityType newType;

    public void getEntityType(GetEntityTypeEventArgs e) {
        Optional<ComAssistTable> comAssistTableOptional;
        super.getEntityType(e);
        if (this.newType == null) {
            try {
                this.newType = e.getNewEntityType() == null ? (MainEntityType)e.getOriginalEntityType().clone() : e.getNewEntityType();
                Field mainEntityType = AbstractFormDataModel.class.getDeclaredField("mainEntityType");
                mainEntityType.setAccessible(true);
                mainEntityType.set(this.getModel(), this.newType);
            }
            catch (CloneNotSupportedException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new KDException(GLErrorCode.SYS_ERR, new Object[]{ex});
            }
            this.newType.clearRefEntityTypeVer();
            this.newType.clearSubEntityTypecache();
        }
        if ((comAssistTableOptional = this.getCommonAssistTable()).isPresent()) {
            MainEntityType newEntityType = (MainEntityType)ComAssistTableService.simpleModifyEntityType((ComAssistTable)comAssistTableOptional.get(), (EntityType)this.newType);
            this.setUseOrgProp(newEntityType, comAssistTableOptional.get());
            e.setNewEntityType(newEntityType);
        } else {
            e.setNewEntityType(this.newType);
        }
    }

    public void setUseOrgProp(MainEntityType newEntityType, ComAssistTable comAssistTable) {
        Map allFields = newEntityType.getAllFields();
        if (allFields.containsKey("useorg")) {
            comAssistTable.getCommonAssists().forEach(commonAssist -> allFields.keySet().stream().filter(k -> k.startsWith(commonAssist.key)).forEach(comAssistKey -> Optional.ofNullable(newEntityType.findProperty(comAssistKey)).ifPresent(prop -> {
                if (prop instanceof BasedataProp) {
                    ((BasedataProp)prop).setOrgProp("useorg");
                } else if (prop instanceof MulBasedataProp) {
                    ((MulBasedataProp)prop).setOrgProp("useorg");
                    ((BasedataProp)((MulBasedataProp)prop).getItemType().getProperties().get((Object)"fbasedataid")).setOrgProp("useorg");
                }
            })));
        }
    }

    private Optional<ComAssistTable> getCommonAssistTable() {
        String accttableId = this.getPageCache().get(ACCOUNT_TABLE_CACHE_KEY) == null ? (String)this.getView().getFormShowParameter().getCustomParam("accounttable") : this.getPageCache().get(ACCOUNT_TABLE_CACHE_KEY);
        return Optional.ofNullable(accttableId).map(Long::parseLong).map(ComAssistTable::get);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.propertyAccounttableChange(this.getModel().getValue("accounttable"));
        this.addAccountTableChangeListener();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addAccountTableChangeListener();
        this.getCommonAssistTable().ifPresent(comAssistTable -> this.registerF7Listener((ComAssistTable)comAssistTable, (IFormView)this.getView()));
    }

    public void registerF7Listener(ComAssistTable comAssistTable, IFormView view) {
        comAssistTable.getCommonAssists().stream().map(commonAssist -> view.getControl(commonAssist.key)).map(BasedataEdit.class::cast).forEach(comAssistEdit -> comAssistEdit.addBeforeF7SelectListener(ComAssistService.F7Listener));
    }

    private void addAccountTableChangeListener() {
        ((BasedataEdit)this.getView().getControl("accounttable")).addBasedataEditListener(evt -> {
            this.getView().getPageCache().put(ACCOUNT_TABLE_CACHE_KEY, ((DynamicObject)evt.getDataEntity()).getPkValue().toString());
            this.getCommonAssistTable().ifPresent(comAssistTable -> {
                ComAssistTableService.modifyCommonAssistFields((ComAssistTable)comAssistTable, (IFormView)this.getView());
                if (!comAssistTable.existCommonAssists()) {
                    this.getModel().setValue("showcomassist", (Object)false);
                }
                this.getView().setVisible(Boolean.valueOf(comAssistTable.existCommonAssists()), new String[]{"showcomassist"});
            });
        });
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        long acctTableID = scheme.getLong("accounttable.id");
        ComAssistTable comAssistTable = ComAssistTable.get((Long)acctTableID);
        MainEntityType mainEntityType = (MainEntityType)ComAssistTableService.simpleModifyEntityType((ComAssistTable)comAssistTable, (EntityType)this.getModel().getDataEntityType());
        comAssistTable.getCommonAssists().forEach(commonAssist -> {
            DynamicObjectCollection comAssistDyos = scheme.getDynamicObjectCollection(commonAssist.key);
            if (CollectionUtils.isNotEmpty((Collection)comAssistDyos)) {
                Object[] comAssistIDs = comAssistDyos.stream().map(dyo -> ((DynamicObject)dyo.get("fbasedataid")).getPkValue()).toArray();
                if (mainEntityType.getProperty(commonAssist.key) != null) {
                    this.getModel().setValue(commonAssist.key, (Object)comAssistIDs);
                }
            }
        });
        if (!comAssistTable.getCommonAssists().isEmpty()) {
            this.getModel().setValue("showcomassist", scheme.get("showcomassist"));
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        boolean showComAssist = this.getQueryParam().getFilter().getBoolean("showcomassist");
        if (!showComAssist) {
            event.getColumns().stream().filter(c -> c instanceof ReportColumn && ((ReportColumn)c).getFieldKey().startsWith("comassist")).forEach(c -> ((ReportColumn)c).setHide(true));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String propertyName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        Object newValue = data.getNewValue();
        if (newValue == (oldValue = data.getOldValue())) {
            return;
        }
        switch (propertyName) {
            case "orgs": {
                this.propertyOrgsChange();
                break;
            }
            case "accounttable": {
                this.propertyAccounttableChange(newValue);
                break;
            }
        }
    }

    private void propertyOrgsChange() {
        List<String> comassistList = this.getComassistFieldByPageCache();
        this.clearComAssist(comassistList);
    }

    private void propertyAccounttableChange(Object newValue) {
        List<String> comassistList = this.getComassistFieldByPageCache();
        this.clearComAssist(comassistList);
        if (newValue == null) {
            ComAssistTableService.modifyCommonAssistFields(null, (IFormView)this.getView());
            this.getView().getPageCache().put(ACCOUNT_TABLE_CACHE_KEY, null);
            return;
        }
    }

    private List<String> getComassistFieldByPageCache() {
        ArrayList<String> comassistList = new ArrayList(8);
        String comassistStr = this.getPageCache().get("comassist");
        if (!StringUtils.isBlank((CharSequence)comassistStr)) {
            comassistList = (List)SerializationUtils.fromJsonString((String)comassistStr, List.class);
        } else {
            int index = 1;
            while (this.getControl("comassist" + index) != null) {
                comassistList.add("comassist" + index);
                ++index;
            }
            if (!comassistList.isEmpty()) {
                this.getPageCache().put("comassist", SerializationUtils.toJsonString(comassistList));
            }
        }
        return comassistList;
    }

    private void clearComAssist(List<String> comassistList) {
        for (String comassistField : comassistList) {
            this.getModel().setValue(comassistField, null);
        }
    }
}

