/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.finalprocess.breakpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.formplugin.voucher.VoucherListDataProvider;

public class VoucherListAndBreakPointLogProvider
extends VoucherListDataProvider {
    private IPageCache pageCache;

    public VoucherListAndBreakPointLogProvider(IFormView view) {
        super(view);
        this.pageCache = view.getPageCache();
    }

    @Override
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection voucherListData = super.getData(start, limit);
        if (CollectionUtils.isEmpty((Collection)voucherListData)) {
            return voucherListData;
        }
        Set fields = this.getVisibleSelectFieldList().stream().filter(x -> x.getKey().startsWith("modifier")).map(x -> x.getKey()).collect(Collectors.toSet());
        if (fields.isEmpty()) {
            return voucherListData;
        }
        DynamicObjectType modifierDT = ((DynamicObject)voucherListData.get(0)).getDynamicObject("modifier").getDynamicObjectType();
        voucherListData.stream().forEach(e -> e.set("modifier", null));
        DynamicObjectType dynamicObjectType = voucherListData.getDynamicObjectType();
        dynamicObjectType.registerSimpleProperty(new DynamicSimpleProperty("originvchno", String.class, null));
        dynamicObjectType.registerSimpleProperty(new DynamicSimpleProperty("adjustdate", Date.class, null));
        List voucherIdList = voucherListData.stream().map(e -> (Long)e.getPkValue()).collect(Collectors.toList());
        String entryTimestmp = this.pageCache.get("EntryTimestmp");
        if (null == entryTimestmp) {
            entryTimestmp = String.valueOf(System.currentTimeMillis());
            this.pageCache.put("EntryTimestmp", entryTimestmp);
            return voucherListData;
        }
        QFilter qfilter = new QFilter("voucherid", "in", voucherIdList).and(new QFilter("isadjust", "!=", (Object)Character.valueOf('0'))).and(new QFilter("adjustdate", ">=", (Object)new Date(Long.parseLong(entryTimestmp))));
        DynamicObjectCollection voucherBreakPoints = QueryServiceHelper.query((String)"gl_voucherbreakpoint", (String)"voucherid, voucherno, adjuster, adjustdate", (QFilter[])new QFilter[]{qfilter});
        if (CollectionUtils.isEmpty((Collection)voucherBreakPoints)) {
            return voucherListData;
        }
        Map<String, List<DynamicObject>> voucherBreakPointMap = voucherBreakPoints.stream().collect(Collectors.groupingBy(e -> e.getString("voucherid")));
        voucherBreakPointMap.values().stream().forEach(e -> e.sort(Comparator.nullsFirst(Comparator.comparing(d -> d.getDate("adjustdate")))));
        ArrayList<Long> adjusterIdList = new ArrayList<Long>(voucherBreakPointMap.size());
        for (List<DynamicObject> voucherBreakPointList : voucherBreakPointMap.values()) {
            DynamicObject lastVoucherBreakPoint = voucherBreakPointList.get(voucherBreakPointList.size() - 1);
            Long adjusterId = lastVoucherBreakPoint.getLong("adjuster");
            adjusterIdList.add(adjusterId);
        }
        Map userInfoMap = BusinessDataServiceHelper.loadFromCache((Object[])adjusterIdList.toArray(), (DynamicObjectType)modifierDT);
        voucherListData.stream().forEach(e -> {
            Object voucherId = e.getPkValue();
            List voucherBreakPointList = (List)voucherBreakPointMap.get(String.valueOf(voucherId));
            if (!CollectionUtils.isEmpty((Collection)voucherBreakPointList)) {
                DynamicObject firstVoucherBreakPoint = (DynamicObject)voucherBreakPointList.get(0);
                DynamicObject lastVoucherBreakPoint = (DynamicObject)voucherBreakPointList.get(voucherBreakPointList.size() - 1);
                String oldVchNo = firstVoucherBreakPoint.getString("voucherno");
                Date adjustdate = lastVoucherBreakPoint.getDate("adjustdate");
                e.set("originvchno", (Object)oldVchNo);
                e.set("adjustdate", (Object)adjustdate);
                Object adjusterId = lastVoucherBreakPoint.get("adjuster");
                DynamicObject adjuster = (DynamicObject)userInfoMap.get(adjusterId);
                e.set("modifier", (Object)adjuster);
            }
        });
        return voucherListData;
    }
}

