/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.importexport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.formplugin.importexport.builder.IImportBuilder;
import kd.fi.gl.formplugin.importexport.builder.repository.AcctBuilder;

public class GLImportHelper {
    public static final String KEY_IMPORT_PROP = "importprop";
    public static final String KEY_ID = "id";
    private final Map<String, IImportBuilder> builderToUse;
    private final AbstractFormPlugin p;
    private static final Map<String, IImportBuilder> builderRepository = new HashMap<String, IImportBuilder>(8);

    public GLImportHelper(AbstractFormPlugin p) {
        this.p = p;
        this.builderToUse = new HashMap<String, IImportBuilder>(8);
    }

    public void registerBuilder(PropertyKey ... buildOnColumns) {
        Arrays.stream(buildOnColumns).map(PropertyKey::getKey).forEach(buildOn -> this.builderToUse.put((String)buildOn, builderRepository.get(this.getEntityByKey((String)buildOn))));
    }

    public void build(BeforeImportDataEventArgs e) {
        this.builderToUse.forEach((buildOn, builder) -> this.doRebuild(e, (String)buildOn, (IImportBuilder)builder));
    }

    private void doRebuild(BeforeImportDataEventArgs e, String buildOn, IImportBuilder builder) {
        Object obj = e.getSourceData().get(buildOn);
        if (!(obj instanceof Map)) {
            return;
        }
        Map val = (Map)obj;
        Object buildRes = builder.build(this.p, e, buildOn);
        val.put(KEY_ID, buildRes == null ? Long.valueOf(0L) : buildRes);
        val.put(KEY_IMPORT_PROP, KEY_ID);
    }

    private String getEntityByKey(String key) {
        MainEntityType mainType = this.p.getView().getModel().getDataEntityType();
        DynamicProperty propType = mainType.getProperty(key);
        if (propType instanceof BasedataProp) {
            return ((BasedataProp)propType).getBaseEntityId();
        }
        return ((MulBasedataProp)propType).getBaseEntityId();
    }

    static {
        builderRepository.put("bd_accountview", new AcctBuilder());
    }
}

