/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.multilingual;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.formplugin.multilingual.MultilingualRepairPlugin;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class MultilingualImportPlugin
extends MultilingualRepairPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(MultilingualImportPlugin.class);

    @Override
    protected void doImport(String fileNames) {
        if (StringUtils.isEmpty((CharSequence)fileNames)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u6587\u4ef6(*.xlsx)\u3002", (String)"AccMultilingualImortPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (fileNames.split(";").length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64cd\u4f5c\u4e00\u4efd\u6587\u4ef6\u3002", (String)"AccMultilingualImortPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        log.info("MultilingualRepairPlugin import begin:");
        try {
            MultilingualRepairPlugin.Local local;
            Workbook wb = MultilingualImportPlugin.getWorkbook(fileNames);
            if (wb == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AccMultilingualImortPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            Sheet sheet = wb.getSheetAt(0);
            int firstRowIndex = sheet.getFirstRowNum() + 1;
            int lastRowIndex = sheet.getLastRowNum();
            HashMap<String, MultilingualRepairPlugin.Local> localeMap = new HashMap<String, MultilingualRepairPlugin.Local>();
            Row firstRow = sheet.getRow(sheet.getFirstRowNum());
            int accIndex = 0;
            int accNumberIndex = 0;
            if (firstRow != null) {
                int firstCell = firstRow.getFirstCellNum();
                short lastCell = firstRow.getLastCellNum();
                for (int i = firstCell; i < lastCell; ++i) {
                    String value = this.getCell(firstRow.getCell(i));
                    if (this.isFiledIndex(value)) {
                        accIndex = i;
                    } else if (this.isFiledNumIndex(value)) {
                        accNumberIndex = i;
                    }
                    if (!value.contains("&")) continue;
                    int localeIndex = value.indexOf("&");
                    String localeValue = value.substring(localeIndex + 1);
                    if (localeMap.containsKey(localeValue)) {
                        if (value.contains(ResManager.loadKDString((String)"\u957f\u540d\u79f0", (String)"AccMultilingualImortPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                            ((MultilingualRepairPlugin.Local)localeMap.get(localeValue)).setFullNameIndex(i);
                            continue;
                        }
                        ((MultilingualRepairPlugin.Local)localeMap.get(localeValue)).setNameIndex(i);
                        continue;
                    }
                    local = new MultilingualRepairPlugin.Local();
                    local.setLocalId(localeValue);
                    if (value.contains(ResManager.loadKDString((String)"\u957f\u540d\u79f0", (String)"AccMultilingualImortPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                        local.setFullNameIndex(i);
                    } else {
                        local.setNameIndex(i);
                    }
                    localeMap.put(localeValue, local);
                }
            }
            for (int rIndex = firstRowIndex; rIndex <= lastRowIndex; ++rIndex) {
                Row row = sheet.getRow(rIndex);
                if (row == null) continue;
                String id = "";
                String number = "";
                if (row.getCell(accIndex) == null || row.getCell(accNumberIndex) == null) continue;
                id = row.getCell(accIndex).getStringCellValue();
                number = row.getCell(accNumberIndex).getStringCellValue();
                for (Map.Entry entry : localeMap.entrySet()) {
                    local = (MultilingualRepairPlugin.Local)entry.getValue();
                    if (local == null || StringUtils.isBlank((Object)row.getCell(local.getNameIndex())) && StringUtils.isBlank((Object)row.getCell(local.getFullNameIndex()))) continue;
                    Object info = this.setInfo(Long.parseLong(id), number, row, local);
                    list.add(info);
                }
            }
        }
        catch (Exception e) {
            return;
        }
        log.info("MultilingualRepairPlugin insert Data begin,size \uff1a" + list.size());
        this.insertInfoToDB(list);
    }

    /*
     * Exception decompiling
     */
    public static Workbook getWorkbook(String fileUrl) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getCell(Cell cell) {
        String cellValue = "";
        DecimalFormat df = new DecimalFormat("#");
        switch (cell.getCellType()) {
            case STRING: {
                cellValue = cell.getRichStringCellValue().getString().trim();
                break;
            }
            case NUMERIC: {
                cellValue = df.format(cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                cellValue = String.valueOf(cell.getBooleanCellValue()).trim();
                break;
            }
            case FORMULA: {
                cellValue = cell.getCellFormula();
                break;
            }
            default: {
                cellValue = "";
            }
        }
        return cellValue;
    }

    protected String getTempFilename(String formName, String fileType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMdd");
        String currDateTime = dateFormat.format(new Date());
        return formName + "_" + currDateTime + fileType;
    }

    protected void insertInfoToDB(List<Object> list) {
    }

    protected boolean isFiledIndex(String value) {
        return false;
    }

    protected boolean isFiledNumIndex(String value) {
        return false;
    }

    protected Object setInfo(Long id, String number, Row row, MultilingualRepairPlugin.Local local) {
        return null;
    }
}

