/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.recip;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.business.vo.reciprocal.AccountGroup;
import kd.fi.gl.constant.GLConstants;
import kd.fi.gl.formplugin.recip.OperationType;
import org.apache.commons.lang3.tuple.Pair;

class RecalUnAcccurrentThread
implements Runnable {
    private static final String PROGRESS = "progress";
    OperationType operationType;
    long orgId = 0L;
    long bookTypeId = 0L;
    long acctTableId = 0L;
    long acctMasterId = 0L;
    IFormView view;
    Log log = LogFactory.getLog((String)"RecalUnAcccurrentThread");
    String hundred = "100";

    public RecalUnAcccurrentThread(long orgId, long bookTypeId, Long acctTableId, long acctMasterId, IFormView view, OperationType operationType) {
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
        this.acctTableId = acctTableId;
        this.acctMasterId = acctMasterId;
        this.view = view;
        this.operationType = operationType;
    }

    @Override
    public void run() {
        try {
            QFilter filter = new QFilter("isendinit", "=", (Object)"1");
            switch (this.operationType) {
                case SingleAccount: {
                    UnAcccurrentUpdateUtil.syncReCalUnAcccurrent((long)this.orgId, (long)this.bookTypeId, (long)this.acctTableId, (Long)this.acctMasterId);
                    this.view.getPageCache().put(PROGRESS, this.hundred);
                    DB.execute((DBRoute)GLConstants.GL_DBRoute, (String)"delete from t_gl_unacccurrent_status where forgid = ? and fbooktypeid = ? and facctableid = ? and faccountid = ?;", (Object[])new Object[]{this.orgId, this.bookTypeId, this.acctTableId, this.acctMasterId});
                    break;
                }
                case SingleOrg: {
                    filter.and(new QFilter("org", "=", (Object)this.orgId));
                    filter.and(new QFilter("accounttable", "=", (Object)this.acctTableId));
                    this.syncReCalUnAcccurrent(filter);
                    break;
                }
                case AllOrg: {
                    this.syncReCalUnAcccurrent(filter);
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
        }
    }

    private void syncReCalUnAcccurrent(QFilter filter) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reci_init_state", (String)"org,booktype,accounttable,account.masterid", (QFilter[])filter.toArray(), null);
             DataSet copy = dataSet.copy();){
            HashMap<AccountGroup, Pair> acctGroupMap = new HashMap<AccountGroup, Pair>(1);
            double totalRows = 0.0;
            while (copy.hasNext()) {
                totalRows += 1.0;
                Row next = copy.next();
                Long orgId = next.getLong("org");
                Long booktypeId = next.getLong("booktype");
                Long accounttableId = next.getLong("accounttable");
                Long acctMasterId = next.getLong("account.masterid");
                acctGroupMap.put(AccountGroup.of((long)orgId, (long)booktypeId, (long)accounttableId, (long)acctMasterId, (long)0L), Pair.of(new HashSet(0), new HashSet(0)));
                if (acctGroupMap.size() <= 999 && copy.hasNext()) continue;
                UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMap);
                acctGroupMap.clear();
            }
            this.log.info("RecalUnAcccurrentThread#syncReCalUnAcccurrent_totalRows:{}", (Object)totalRows);
            int index = 1;
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long orgId = next.getLong("org");
                Long booktypeId = next.getLong("booktype");
                Long accounttableId = next.getLong("accounttable");
                Long acctMasterId = next.getLong("account.masterid");
                Map<AccountGroup, Pair> singleAcctGroupMap = Collections.singletonMap(AccountGroup.of((long)orgId, (long)booktypeId, (long)accounttableId, (long)acctMasterId, (long)0L), Pair.of(new HashSet(0), new HashSet(0)));
                UnAcccurrentUpdateUtil.asyncCalAndDeleteStatus(singleAcctGroupMap);
                String progress = String.valueOf((int)((double)index / totalRows * 100.0));
                if (DebugTrace.enable()) {
                    this.log.info("RecalUnAcccurrentThread#syncReCalUnAcccurrent_index:{},totalRows:{},progress:{}", new Object[]{index, totalRows, progress});
                }
                this.view.getPageCache().put(PROGRESS, progress);
                ++index;
            }
            this.view.getPageCache().put(PROGRESS, this.hundred);
        }
    }
}

