/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.recip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.formplugin.recip.OperationType;
import kd.fi.gl.formplugin.recip.RecalUnAcccurrentThread;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.AppLogHelper;

public class UnAcccurrentReCalFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESS = "progress";
    private static final int INIT_PROGRESS = 5;
    private static final String PROGRESSBARAP = "progressbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"recal", "recalall", "recalallorg"});
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter show = (ListShowParameter)evt.getFormShowParameter();
            long orgId = (Long)this.getModel().getValue("org_id");
            long acctTableId = (Long)this.getModel().getValue("accounttable_id");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            filters.add(new QFilter("isleaf", "=", (Object)"1"));
            QFilter filter = AccountUtils.getAccountDataFilter((long)orgId, (long)acctTableId, filters);
            show.getListFilterParameter().getQFilters().add(filter);
        });
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object ids = this.getView().getFormShowParameter().getCustomParam("bookid");
        if (ids != null) {
            List list = (List)ids;
            if (list.isEmpty()) {
                return;
            }
            long id = (Long)list.get(0);
            QFilter filter = new QFilter("id", "=", (Object)id);
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"org,bookstype,accounttable", (QFilter[])new QFilter[]{filter});
            IDataModel model = this.getModel();
            model.setValue("org", (Object)book.getLong("org"));
            model.setValue("booktype", (Object)book.getLong("bookstype"));
            model.setValue("accounttable", (Object)book.getLong("accounttable"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("org".equals(name)) {
            model.setValue("booktype", null);
            model.setValue("accounttable", null);
        }
        if ("booktype".equals(name)) {
            QFilter filter = new QFilter("org", "=", model.getValue("org_id"));
            filter.and(new QFilter("bookstype", "=", model.getValue("booktype_id")));
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"org,bookstype,accounttable", (QFilter[])new QFilter[]{filter});
            if (Objects.nonNull(book)) {
                model.setValue("accounttable", (Object)book.getLong("accounttable"));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.getPageCache().remove(PROGRESS);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        long orgId = (Long)this.getModel().getValue("org_id");
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long acctTableId = (Long)this.getModel().getValue("accounttable_id");
        this.getPageCache().put("operation_key", key);
        switch (key) {
            case "recal": {
                if (Objects.isNull(this.getModel().getValue("account"))) {
                    this.getView().showTipNotification("account is not empty");
                    return;
                }
                long acctMasterId = ((DynamicObject)this.getModel().getValue("account")).getLong("masterid");
                this.writeOperationLog(key + "_start", orgId, bookTypeId, acctMasterId);
                GLThreadService.ayncCallBalance((String)"UnAcccurrentReCalFormPlugin", (Runnable)new RecalUnAcccurrentThread(orgId, bookTypeId, acctTableId, acctMasterId, this.getView(), OperationType.SingleAccount));
                this.initProgressBar(5);
                break;
            }
            case "recalall": {
                if (orgId == 0L) {
                    this.getView().showTipNotification("orgId is not empty");
                    return;
                }
                if (bookTypeId == 0L) {
                    this.getView().showTipNotification("bookTypeId is not empty");
                    return;
                }
                this.writeOperationLog(key + "_start", orgId, bookTypeId, acctTableId);
                GLThreadService.ayncCallBalance((String)"UnAcccurrentReCalFormPlugin", (Runnable)new RecalUnAcccurrentThread(orgId, bookTypeId, acctTableId, 0L, this.getView(), OperationType.SingleOrg));
                this.initProgressBar(0);
                break;
            }
            case "recalallorg": {
                GLThreadService.ayncCallBalance((String)"UnAcccurrentReCalFormPlugin", (Runnable)new RecalUnAcccurrentThread(0L, 0L, 0L, 0L, this.getView(), OperationType.AllOrg));
                this.initProgressBar(0);
            }
        }
    }

    private void initProgressBar(int percent) {
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.setPercent(percent);
        bar.start();
        this.setLabel(percent);
        this.getPageCache().put(PROGRESS, String.valueOf(percent));
    }

    private void setLabel(int percent) {
        Label label = (Label)this.getControl("labelap");
        label.setText(String.format("calculating... %s ", percent) + "%");
    }

    public void onProgress(ProgressEvent progressEvent) {
        int percent = this.getPageCache().get(PROGRESS) == null ? 5 : Integer.parseInt(this.getPageCache().get(PROGRESS));
        progressEvent.setProgress(percent);
        this.setLabel(percent);
        if (percent >= 100) {
            this.writeOperationLog(this.getPageCache().get("operation_key") + "_end", new long[0]);
            Label label = (Label)this.getControl("labelap");
            label.setText("calculate complete");
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(percent);
            bar.stop();
        }
    }

    private void writeOperationLog(String opKey, long ... filters) {
        String[] descParams;
        MultiLangEnumBridge opDescBridge;
        IDataModel model = this.getModel();
        List collected = Arrays.stream(filters).mapToObj(String::valueOf).collect(Collectors.toList());
        String opKeyWord = String.join((CharSequence)" | ", collected);
        if (filters == null || filters.length == 0) {
            filters = new long[3];
            filters[0] = (Long)model.getValue("org_id");
            filters[1] = (Long)model.getValue("booktype_id");
            if (Objects.isNull(this.getModel().getValue("account"))) {
                return;
            }
            filters[2] = ((DynamicObject)this.getModel().getValue("account")).getLong("masterid");
            opDescBridge = new MultiLangEnumBridge("\u7ec4\u7ec7\u3010%1$s\u3011\u91cd\u7b97\u6210\u529f\u3002\u91cd\u7b97\u6761\u4ef6\uff1a\u3010%2$s\u3011\u3002", "UnAcccurrentReCalFormPlugin_0", "fi-gl-formplugin");
            descParams = new String[]{((DynamicObject)model.getValue("org")).getString("name"), opKeyWord};
        } else {
            opDescBridge = new MultiLangEnumBridge("\u91cd\u7b97\u6210\u529f\u3002\u91cd\u7b97\u6761\u4ef6\uff1a\u3010%1$s\u3011\u3002", "UnAcccurrentReCalFormPlugin_1", "fi-gl-formplugin");
            descParams = new String[]{opKeyWord};
        }
        Long orgId = filters[0];
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge();
        if (opKey.equals("recal_start")) {
            opKey = "recal_start";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u5f00\u59cb\u3002", "BalanceRecalculateFormPlugin_1", "fi-gl-formplugin");
        } else if (opKey.equals("recalall_start")) {
            opKey = "recal_start";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u671f\u95f4\u53ca\u540e\u671f\u5f00\u59cb\u3002", "BalanceRecalculateFormPlugin_2", "fi-gl-formplugin");
        } else if (opKey.equals("recal_end")) {
            opKey = "recal_end";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u7ed3\u675f\u3002", "BalanceRecalculateFormPlugin_3", "fi-gl-formplugin");
        } else if (opKey.equals("recalall_end")) {
            opKey = "recalall_end";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u671f\u95f4\u53ca\u540e\u671f\u7ed3\u675f\u3002", "BalanceRecalculateFormPlugin_4", "fi-gl-formplugin");
        }
        AppLogHelper.addBatchLog((long)orgId, (String)"gl_unacccurrent_status", (String)opKeyWord, (String)opKey, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])descParams);
    }
}

