/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.FlexEdit;
import kd.fi.bd.util.MasterBaseDataUtils;
import kd.fi.gl.assistitem.AccountItemValueMappingHelper;
import kd.fi.gl.assistitem.AssgrpMappingParam;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.voucher.IVoucherPropertyChangeService;
import kd.fi.gl.interfaces.service.cf.ICashFlowFlexService;
import kd.fi.gl.util.FlexUtils;

public class AccountAssgrpChangedService
implements IVoucherPropertyChangeService {
    private ICashFlowFlexService getFlexService() {
        return (ICashFlowFlexService)GLServiceFactory.getService(ICashFlowFlexService.class);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args, IFormView voucherEditView, IDataModel voucherEditModel, IPageCache cache) {
        this.propertyChanged(args, voucherEditView, voucherEditModel, cache, "entries");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args, IFormView voucherEditView, IDataModel voucherEditModel, IPageCache cache, String entryName) {
        boolean isSameItem;
        long orgId = (Long)voucherEditModel.getValue(GLField.id_((String)"org"));
        if (!this.getFlexService().isGetFromAccountFlexValueEnable(orgId)) {
            return;
        }
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        int rowIndex = voucherEditModel.getEntryCurrentRowIndex(entryName);
        DynamicObject mainCFItem = (DynamicObject)voucherEditModel.getValue("maincfitem", rowIndex);
        if (Objects.isNull(mainCFItem)) {
            return;
        }
        DynamicObjectCollection assistEntry = mainCFItem.getDynamicObjectCollection("assistentry");
        List assistTypeIds = assistEntry.stream().map(x -> x.getLong(GLField.id_((String)"asstypeid"))).collect(Collectors.toList());
        if (assistTypeIds.isEmpty()) {
            return;
        }
        HashSet mainCfItemFlexFields = new HashSet(FlexUtils.batchGetFlexFields(assistTypeIds).values());
        DynamicObject oldValue = (DynamicObject)voucherEditModel.getValue("maincfassgrp", rowIndex);
        Map valueMap = Objects.isNull(oldValue) ? new HashMap(assistTypeIds.size()) : (Map)SerializationUtils.fromJsonString((String)oldValue.getString("value"), Map.class);
        if (newValue instanceof DynamicObject) {
            DynamicObject newDynVal = (DynamicObject)newValue;
            String alias = newDynVal.getDynamicObjectType().getName();
            String pkField = MasterBaseDataUtils.getMasterIdField((String)alias);
            pkField = StringUtils.isBlank((CharSequence)pkField) ? "id" : pkField;
            newValue = newDynVal.getLong(pkField);
        }
        ThreadCache.put((Object)"curOrgId", (Object)voucherEditModel.getValue("org_id"));
        Map mappingValue = AccountItemValueMappingHelper.getMappingValue((AssgrpMappingParam)new AssgrpMappingParam(Collections.singletonMap(args.getProperty().getAlias(), newValue), mainCfItemFlexFields, orgId));
        valueMap.putAll(mappingValue);
        long rebuildAssgrpId = FlexUtils.saveFlexData(valueMap);
        if (rebuildAssgrpId == 0L) {
            return;
        }
        DynamicObject mainCfItemOnTab = (DynamicObject)voucherEditModel.getValue("maincf");
        boolean bl = isSameItem = mainCfItemOnTab != null && mainCfItemOnTab.getLong("id") == mainCFItem.getLong("id");
        if (isSameItem) {
            voucherEditModel.setValue("mcfassgrp", (Object)rebuildAssgrpId);
            FlexEdit flexEdit = (FlexEdit)voucherEditView.getControl("mcfassgrp");
            flexEdit.setFlexModelValue((Object)rebuildAssgrpId, 0);
        }
        voucherEditModel.setValue("maincfassgrp", (Object)rebuildAssgrpId, rowIndex);
        FlexEdit entryFlexEdit = (FlexEdit)voucherEditView.getControl("maincfassgrp");
        entryFlexEdit.setFlexModelValue((Object)rebuildAssgrpId, rowIndex);
    }
}

