/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.formplugin.voucher.VoucherBizNumberList;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

class BizNumberDataProvider
extends ListDataProvider {
    private static final String BOOKEDDATE = "bookeddate";
    private static final String PERIOD = "periodname";
    private static final String VOUCHERTYPE = "vouchertype";
    private static final String BILLNO = "billno";
    private static final String DEBITLOCAL = "debitlocal";
    private static final String CREDITLOCAL = "creditlocal";
    private Map<String, Set<Object>> assgrp;

    public BizNumberDataProvider(Map<String, Set<Object>> assgrp) {
        this.assgrp = assgrp;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        if (this.isNeedResum()) {
            return super.getData(start, limit);
        }
        Map<String, Set<Object>> assgrp = this.getAssgrp();
        if (assgrp != null && !assgrp.isEmpty()) {
            Collection assistFilterEntries = ReciprocalUtils.buildAssistFilterInfo(assgrp);
            Triple ormInfo = FlexUtils.buildDynamicORMAssistOnBalance((Collection)assistFilterEntries, (String)"gl_acccurrent", (boolean)true);
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_acccurrent", (IDataEntityType)ormInfo.getLeft());
            List middle = (List)ormInfo.getMiddle();
            List accQfilters = this.getQFilters();
            accQfilters.addAll(middle);
            DataSet acccurrentDataSet = orm.queryDataSet(VoucherBizNumberList.class.getName(), "gl_acccurrent", "id", accQfilters.toArray(new QFilter[0]), "id", start, limit);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            ArrayList<Long> ids = new ArrayList<Long>(9);
            for (Row row : acccurrentDataSet) {
                ids.add(row.getLong("id"));
            }
            filters.add(new QFilter("id", "in", ids));
            this.setQFilters(filters);
        }
        DynamicObjectCollection rows = super.getData(start, limit);
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(BOOKEDDATE, Date.class, null));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(PERIOD, String.class, (Object)""));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(VOUCHERTYPE, String.class, (Object)""));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(BILLNO, String.class, (Object)""));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(DEBITLOCAL, BigDecimal.class, null));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(CREDITLOCAL, BigDecimal.class, null));
        ArrayList<Long> vchEntryIds = new ArrayList<Long>(20);
        ArrayList<Long> vchIds = new ArrayList<Long>(20);
        ArrayList<Long> acccurrentIds = new ArrayList<Long>(16);
        for (DynamicObject row : rows) {
            vchEntryIds.add(row.getLong("voucherentry"));
            vchIds.add(row.getLong("voucherid"));
            if (row.getLong("voucherid") != 0L) continue;
            acccurrentIds.add(row.getLong("id"));
        }
        Map<Long, VoucherInfo> idAndVoucherMap = this.queryEntryAndVoucherMap(vchEntryIds, vchIds);
        Map<Long, Long> acccuAndAccountIdMap = this.queryAcccuAndAccountIdMap(acccurrentIds);
        for (DynamicObject row : rows) {
            VoucherInfo info = idAndVoucherMap.get(row.getLong("voucherentry"));
            Long accountId = null;
            if (info != null) {
                row.set(BOOKEDDATE, (Object)info.getBookeddate());
                row.set(PERIOD, (Object)info.getPeriod());
                row.set(VOUCHERTYPE, (Object)info.getVouchertype());
                row.set(BILLNO, (Object)info.getBillno());
                row.set(DEBITLOCAL, (Object)info.getDebitlocal());
                row.set(CREDITLOCAL, (Object)info.getCreditlocal());
                accountId = info.getAccount();
            } else {
                BigDecimal dc = row.getInt("account.dc") == 1 ? BigDecimal.ONE : new BigDecimal("-1");
                BigDecimal bal = row.getBigDecimal("amountbal").multiply(dc);
                boolean isdebit = bal.compareTo(BigDecimal.ZERO) > 0;
                BigDecimal debitlocal = isdebit ? bal.abs() : BigDecimal.ZERO;
                BigDecimal creditlocal = isdebit ? BigDecimal.ZERO : bal.abs();
                row.set(DEBITLOCAL, (Object)debitlocal);
                row.set(CREDITLOCAL, (Object)creditlocal);
                accountId = acccuAndAccountIdMap.get(row.get("id"));
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bd_accountview");
            dynamicObject.set("id", (Object)accountId);
            row.set("account", (Object)dynamicObject);
        }
        return rows;
    }

    private Map<Long, Long> queryAcccuAndAccountIdMap(List<Long> acccurrentIds) {
        HashMap<Long, Long> accuAndAccountIdMap = new HashMap<Long, Long>(8);
        if (acccurrentIds.size() > 0) {
            try (DataSet initAcccu = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initacccurrent", (String)"account, reciprocalrecord", (QFilter[])new QFilter[]{new QFilter("reciprocalrecord", "in", acccurrentIds)}, null);){
                while (initAcccu.hasNext()) {
                    Row row = initAcccu.next();
                    accuAndAccountIdMap.put(row.getLong("reciprocalrecord"), row.getLong("account"));
                }
            }
        }
        return accuAndAccountIdMap;
    }

    private Map<Long, VoucherInfo> queryEntryAndVoucherMap(List<Long> vchEntryIds, List<Long> vchIds) {
        HashMap<Long, VoucherInfo> idAndVoucherMap = new HashMap<Long, VoucherInfo>();
        if (vchEntryIds.size() > 0) {
            ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
            lstFilters.add(new QFilter("entries.id", "in", vchEntryIds));
            lstFilters.add(new QFilter("id", "in", vchIds));
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"entries.id entryid,bookeddate,period.name period,vouchertype.name vouchertype,billno,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.account account", (QFilter[])lstFilters.toArray(new QFilter[0]), null);){
                while (dSet.hasNext()) {
                    Row row = dSet.next();
                    VoucherInfo info = new VoucherInfo();
                    info.setBookeddate(row.getDate(BOOKEDDATE));
                    info.setPeriod(row.getString("period"));
                    info.setVouchertype(row.getString(VOUCHERTYPE));
                    info.setBillno(row.getString(BILLNO));
                    info.setDebitlocal(row.getBigDecimal(DEBITLOCAL));
                    info.setCreditlocal(row.getBigDecimal(CREDITLOCAL));
                    info.setAccount(row.getLong("account"));
                    idAndVoucherMap.put(row.getLong("entryid"), info);
                }
            }
        }
        return idAndVoucherMap;
    }

    public Map<String, Set<Object>> getAssgrp() {
        return this.assgrp;
    }

    static class VoucherInfo {
        private Date bookeddate;
        private String period;
        private String vouchertype;
        private String billno;
        private BigDecimal debitlocal;
        private BigDecimal creditlocal;
        private Long account;

        VoucherInfo() {
        }

        public Long getAccount() {
            return this.account;
        }

        public void setAccount(Long account) {
            this.account = account;
        }

        public Date getBookeddate() {
            return this.bookeddate;
        }

        public void setBookeddate(Date bookeddate) {
            this.bookeddate = bookeddate;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getVouchertype() {
            return this.vouchertype;
        }

        public void setVouchertype(String vouchertype) {
            this.vouchertype = vouchertype;
        }

        public String getBillno() {
            return this.billno;
        }

        public void setBillno(String billno) {
            this.billno = billno;
        }

        public BigDecimal getDebitlocal() {
            return this.debitlocal;
        }

        public void setDebitlocal(BigDecimal debitlocal) {
            this.debitlocal = debitlocal;
        }

        public BigDecimal getCreditlocal() {
            return this.creditlocal;
        }

        public void setCreditlocal(BigDecimal creditlocal) {
            this.creditlocal = creditlocal;
        }
    }
}

