/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.AppLogHelper;

public class VoucherAttachManagePlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(VoucherAttachManagePlugin.class);

    private AttachmentPanel getAttachmentPanel() {
        return (AttachmentPanel)this.getView().getControl("attachmentpanelap");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"manageattach", "attachgn", "btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String itemKey = ((Button)source).getKey();
        if ("btnok".equalsIgnoreCase(itemKey)) {
            try {
                JSONObject paramJson = this.parseParam();
                String formId = paramJson.getString("formId");
                String voucherId = String.valueOf(paramJson.get((Object)"voucherId"));
                String attachKey = paramJson.getString("attachKey");
                List tempAccachmentDatas = this.getAttachmentPanel().getAttachmentData();
                LOG.info("AccachmentDatasUpload formId:{}, voucherId:{}, attachKey:{}, tempDatas:{}", new Object[]{formId, voucherId, attachKey, SerializationUtils.toJsonString((Object)tempAccachmentDatas)});
                Map<String, List> attachmentDatas = Collections.singletonMap(attachKey, tempAccachmentDatas);
                DynamicObjectCollection saveTempAttachments = AttachmentServiceHelper.saveTempAttachments((String)formId, (Object)voucherId, (String)EntityMetadataCache.getDataEntityType((String)formId).getAppId(), attachmentDatas);
                String fileName = saveTempAttachments.stream().map(x -> x.getString("FAttachmentName")).collect(Collectors.joining(";"));
                long orgId = paramJson.getLong("org");
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u51ed\u8bc1\u9644\u4ef6", "VoucherAttachManagePlugin_0", "fi-gl-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u51ed\u8bc1%1$s\u8865\u5145\u9644\u4ef6\u6570\u91cf\uff1a%2$s(%3$s)\u3002", "VoucherAttachManagePlugin_1", "fi-gl-formplugin");
                AppLogHelper.addBatchLog((long)orgId, (String)"gl_unacccurrent_status", (String)"", (String)"voucherAttach", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{paramJson.getString("billNumber"), fileName});
                int attach = tempAccachmentDatas.size();
                this.updateAttachMents(voucherId, attach);
                this.getView().close();
            }
            catch (Exception e) {
                LOG.error("bind attachment to bill exception:  " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private JSONObject parseParam() {
        Object params = this.getView().getFormShowParameter().getCustomParams().get("params");
        LOG.info("this manageattach param : " + params);
        Preconditions.checkArgument((null != params ? 1 : 0) != 0);
        return JSONObject.parseObject((String)params.toString());
    }

    private void updateAttachMents(String voucherId, int attach) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_gl_voucher set fattachments = fattachments + ? ", new Object[]{attach});
        sqlBuilder.append("where fid = ? ", new Object[]{Long.parseLong(voucherId)});
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject paramJson = this.parseParam();
        LOG.info("this manageattach param : " + paramJson);
        this.queryAttachMents();
    }

    private void queryAttachMents() {
        JSONObject paramJson = this.parseParam();
        String formId = paramJson.getString("formId");
        Object voucherId = paramJson.get((Object)"voucherId");
        String attachKey = paramJson.getString("attachKey");
        QFilter attachFilter = new QFilter("FInterID", "=", (Object)String.valueOf(voucherId));
        attachFilter.and("FBillType", "=", (Object)formId);
        attachFilter.and("fattachmentpanel", "=", (Object)attachKey);
        DynamicObjectCollection attachCollection = QueryServiceHelper.query((String)"bos_attachment", (String)"id,fattachmentname,fextname,fcreatetime,fcreatemen", (QFilter[])new QFilter[]{attachFilter}, (String)"fcreatetime desc");
        IDataModel model = this.getModel();
        if (!attachCollection.isEmpty()) {
            HashMap<Long, String> idToNameMap = new HashMap<Long, String>(16);
            List fcreatemenList = attachCollection.stream().mapToLong(x -> x.getLong("fcreatemen")).boxed().collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", fcreatemenList);
            try (DataSet userDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{qFilter}, null);){
                for (Row row : userDataSet) {
                    idToNameMap.put(row.getLong("id"), row.getString("name"));
                }
            }
            for (DynamicObject dynamicObject : attachCollection) {
                int index = model.createNewEntryRow("entryentity");
                model.setValue("textfield", (Object)(index + 1), index);
                model.setValue("filename", dynamicObject.get("fattachmentname"), index);
                model.setValue("fileformat", dynamicObject.get("fextname"), index);
                model.setValue("uploaddate", dynamicObject.get("fcreatetime"), index);
                model.setValue("creator", idToNameMap.get(dynamicObject.getLong("fcreatemen")), index);
            }
        }
        if (DebugTrace.enable()) {
            LOG.info("Current voucher related attachment : " + attachCollection.size());
            LOG.info("curr data should display : " + model.getDataEntity());
        }
    }
}

