/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.constant.basedata.CurrencyConstant;
import kd.fi.gl.formplugin.voucher.VoucherEditView;

public class VoucherEditAccountBalanceManager {
    private static final String ACCT_CHANGE = "acct-change";
    private static final String BALKEY = "local-bal-key";
    private static final String CURLAB = "curlab";
    private static final String CURBAL = "curbal";

    protected VoucherEditAccountBalanceManager() {
    }

    protected void updateAccountDebitBalance(VoucherEditView voucherEditView, int rowIndex, BigDecimal oldAmount, BigDecimal newAmount) {
        BigDecimal debit = this.updateAccountBalance(voucherEditView, rowIndex, "debit", oldAmount, newAmount);
        if (debit.compareTo(BigDecimal.ZERO) != 0) {
            voucherEditView.getLabelManager().setLableText(CURLAB, ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u501f\u65b9\u5408\u8ba1\uff1a", (String)"VoucherEditAccountBalanceManager_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    protected void updateAccountCreditBalance(VoucherEditView voucherEditView, int rowIndex, BigDecimal oldAmount, BigDecimal newAmount) {
        BigDecimal credit = this.updateAccountBalance(voucherEditView, rowIndex, "credit", oldAmount, newAmount);
        if (credit.compareTo(BigDecimal.ZERO) != 0) {
            voucherEditView.getLabelManager().setLableText(CURLAB, ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8d37\u65b9\u5408\u8ba1\uff1a", (String)"VoucherEditAccountBalanceManager_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private BigDecimal updateAccountBalance(VoucherEditView voucherEditView, int rowIndex, String dc, BigDecimal oldAmount, BigDecimal newAmount) {
        BigDecimal amt;
        String accountChangeCacheValue = voucherEditView.getCacheManager().get(ACCT_CHANGE);
        if (StringUtils.isNotBlank((CharSequence)accountChangeCacheValue)) {
            return BigDecimal.ZERO;
        }
        DynamicObject account = voucherEditView.getValueGetter().getAccount(rowIndex);
        if (account == null) {
            return BigDecimal.ZERO;
        }
        String accountNumbver = account.getString("number");
        String balCacheValue = voucherEditView.getCacheManager().get(BALKEY);
        HashMap<String, String> balCache = StringUtils.isNotBlank((CharSequence)balCacheValue) ? (HashMap<String, String>)SerializationUtils.fromJsonString((String)balCacheValue, Map.class) : new HashMap<String, String>(16);
        oldAmount = oldAmount == null ? BigDecimal.ZERO : oldAmount;
        newAmount = newAmount == null ? BigDecimal.ZERO : newAmount;
        String key = accountNumbver + ":" + dc;
        if (balCache.containsKey(key)) {
            amt = new BigDecimal(balCache.get(key).toString());
            amt = amt.subtract(oldAmount).add(newAmount);
        } else {
            amt = newAmount;
        }
        balCache.put(key, amt.toString());
        voucherEditView.getCacheManager().set(BALKEY, SerializationUtils.toJsonString(balCache));
        DynamicObject loaclCurrency = voucherEditView.getValueGetter().getLoaclCurrency();
        int amtprecision = loaclCurrency.getInt(CurrencyConstant.Entity_AMT_Scale.key);
        voucherEditView.getLabelManager().setLableText(CURBAL, voucherEditView.getUserFormatter().formatAmount(amt, "", amtprecision));
        return amt;
    }
}

