/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.util.QFBuilder;

public class VoucherEditSummry {
    private final VoucherEditView voucherEditView;

    protected VoucherEditSummry(VoucherEditView voucherEditView) {
        this.voucherEditView = voucherEditView;
    }

    protected BigDecimal getLocalDebitSum() {
        if (this.voucherEditView.isEntryNeedPaged()) {
            int entryPageSize = this.voucherEditView.getVoucherEditModel().getEntryPageSize();
            int entryRowCount = this.voucherEditView.getVoucherEditModel().getEntryRowCount("entries");
            if (entryRowCount > entryPageSize) {
                return BigDecimal.ZERO;
            }
        }
        return this.voucherEditView.getVoucherEntryGrid().getSum("debitlocal");
    }

    protected Map<String, String> getAccountSum() {
        long id;
        int entryPageSize;
        int entryRowCount = this.voucherEditView.getVoucherEditModel().getEntryRowCount("entries");
        HashMap<String, BigDecimal> accountNumberSumMap = new HashMap<String, BigDecimal>(entryRowCount);
        DynamicObjectCollection entryEntityCollection = this.voucherEditView.getVoucherEditModel().getEntryEntity("entries");
        ArrayList<Long> entryIdList = new ArrayList<Long>(entryEntityCollection.size());
        for (DynamicObject entryDynObj : entryEntityCollection) {
            BigDecimal value;
            DynamicObject accountDynObj;
            long entryId = entryDynObj.getLong("id");
            if (entryId > 0L) {
                entryIdList.add(entryId);
            }
            if ((accountDynObj = entryDynObj.getDynamicObject("account")) == null) continue;
            String dc = "debit";
            BigDecimal bigDecimal = value = entryDynObj.getBigDecimal("debitlocal") == null ? BigDecimal.ZERO : entryDynObj.getBigDecimal("debitlocal");
            if (value.signum() == 0) {
                dc = "credit";
                value = entryDynObj.getBigDecimal("creditlocal") == null ? BigDecimal.ZERO : entryDynObj.getBigDecimal("creditlocal");
            }
            String key = accountDynObj.getString("number") + ":" + dc;
            BigDecimal mapValue = accountNumberSumMap.computeIfAbsent(key, k -> BigDecimal.ZERO);
            accountNumberSumMap.put(key, mapValue.add(value));
        }
        if (this.voucherEditView.isEntryNeedPaged() && entryRowCount > (entryPageSize = this.voucherEditView.getVoucherEditModel().getEntryPageSize()) && (id = this.voucherEditView.getValueGetter().getId()) > 0L) {
            QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)id);
            qfBuilder.add("entries.id", "not in", entryIdList);
            try (DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)VoucherEditSummry.class.getName(), (String)"gl_voucher", (String)"entries.account.number accountnumber,entries.entrydc dc,entries.debitlocal debitlocal,entries.creditlocal creditlocal", (QFilter[])qfBuilder.toArray(), null).groupBy(new String[]{"accountnumber", "dc"}).sum("debitlocal").sum("creditlocal").finish();){
                for (Row row : voucherDataSet) {
                    BigDecimal value;
                    String key;
                    String accountNumber = row.getString("accountnumber");
                    String dc = row.getString("dc");
                    if ("1".equals(dc)) {
                        key = accountNumber + ":debit";
                        value = row.getBigDecimal("debitlocal");
                    } else {
                        key = accountNumber + ":credit";
                        value = row.getBigDecimal("creditlocal");
                    }
                    BigDecimal mapValue = accountNumberSumMap.computeIfAbsent(key, k -> BigDecimal.ZERO);
                    accountNumberSumMap.put(key, mapValue.add(value));
                }
            }
        }
        return accountNumberSumMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((BigDecimal)x.getValue()).toString()));
    }
}

