/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.business.vo.voucher.IVoucherModel;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.util.ContextUtil;

public class VoucherEditValueGetter
implements IVoucherModel {
    protected final IDataModel voucherEditModel;

    protected VoucherEditValueGetter(IDataModel voucherEditModel) {
        Objects.requireNonNull(voucherEditModel);
        this.voucherEditModel = voucherEditModel;
    }

    public long getId() {
        return (Long)this.voucherEditModel.getValue("id");
    }

    public long getOrgId() {
        return (Long)this.voucherEditModel.getValue(Voucher.id_((String)"org"));
    }

    public long getBookTypeId() {
        return (Long)this.voucherEditModel.getValue(Voucher.id_((String)"booktype"));
    }

    public Date getBookedDate() {
        return this.getBookDate();
    }

    protected long getPeriodId() {
        return (Long)this.voucherEditModel.getValue(Voucher.id_((String)"period"));
    }

    protected DynamicObject getPeriodDynObj() {
        return (DynamicObject)this.voucherEditModel.getValue("period");
    }

    public long getAccountTableId() {
        return AccSysUtil.getCurPeriodAccountTableId((long)this.getOrgId(), (long)this.getBookTypeId(), (long)this.getPeriodId());
    }

    public DynamicObject getBook() {
        return (DynamicObject)this.voucherEditModel.getValue("book");
    }

    public DynamicObject getExRateTable() {
        return this.getBook().getDynamicObject("exratetable");
    }

    public Date getBookDate() {
        return (Date)this.voucherEditModel.getValue("bookeddate");
    }

    public Date getBizDate() {
        return (Date)this.voucherEditModel.getValue("bizdate");
    }

    public long getLocalCurId() {
        return this.getLocalCurrencyID();
    }

    public String getStatus() {
        return (String)this.voucherEditModel.getValue("billstatus");
    }

    protected String getCheckStatus() {
        return (String)this.voucherEditModel.getValue("ischeck");
    }

    protected String getVoucherBillNo() {
        return (String)this.voucherEditModel.getValue("billno");
    }

    @Deprecated
    protected DynamicObject getLoaclCurrency() {
        return this.getLocalCurrency();
    }

    public DynamicObject getLocalCurrency() {
        return (DynamicObject)this.voucherEditModel.getValue("localcur");
    }

    public int getLocalCurrencyAmountPrecision() {
        DynamicObject localCurrencyDyo = this.getLocalCurrency();
        return localCurrencyDyo == null ? 0 : localCurrencyDyo.getInt("amtprecision");
    }

    public Long getLocalCurrencyID() {
        DynamicObject localCurrencyDyo = this.getLocalCurrency();
        return localCurrencyDyo == null ? 0L : localCurrencyDyo.getLong("id");
    }

    protected long getSystemUserId() {
        return ContextUtil.getUserId();
    }

    protected String getMainStatus() {
        return (String)this.voucherEditModel.getValue("mainstatus");
    }

    protected String getSuppStatus() {
        return (String)this.voucherEditModel.getValue("suppstatus");
    }

    public String getSourceType() {
        return (String)this.voucherEditModel.getValue("sourcetype");
    }

    protected boolean isReverse() {
        return (Boolean)this.voucherEditModel.getValue("isreverse");
    }

    protected boolean isPost() {
        return (Boolean)this.voucherEditModel.getValue("ispost");
    }

    protected boolean hasReverse() {
        return (Boolean)this.voucherEditModel.getValue("hasreverse");
    }

    protected BigDecimal getCashUnused() {
        BigDecimal cashUnused = (BigDecimal)this.voucherEditModel.getValue("cashunused");
        return cashUnused == null ? BigDecimal.ZERO : cashUnused;
    }

    protected BigDecimal getPlUnused() {
        BigDecimal plUnused = (BigDecimal)this.voucherEditModel.getValue("plunused");
        return plUnused == null ? BigDecimal.ZERO : plUnused;
    }

    protected BigDecimal getCashTotal() {
        BigDecimal cashUnused = (BigDecimal)this.voucherEditModel.getValue("cashtotal");
        return cashUnused == null ? BigDecimal.ZERO : cashUnused;
    }

    protected BigDecimal getPlTotal() {
        BigDecimal plUnused = (BigDecimal)this.voucherEditModel.getValue("pltotal");
        return plUnused == null ? BigDecimal.ZERO : plUnused;
    }

    public Long getExchangeRateTableID() {
        DynamicObject book = this.getBook();
        if (book == null) {
            return 0L;
        }
        DynamicObject tableDyo = book.getDynamicObject("exratetable");
        return tableDyo == null ? 0L : tableDyo.getLong("id");
    }

    public Date getExRateCtrlDate() {
        return VoucherEditArgHelper.isBizDateCtrlRate((long)this.getOrgId(), (long)ContextUtil.getUserId()) ? this.getBizDate() : this.getBookDate();
    }

    public int getEntriesCurrentRowIndex() {
        return this.voucherEditModel.getEntryCurrentRowIndex("entries");
    }

    public long getCurrencyId(int rowIndex) {
        return (Long)this.voucherEditModel.getValue(Voucher.id_((String)"currency"), rowIndex);
    }

    public int getCurrencyAmountPrecision(int rowIndex) {
        DynamicObject currencyDyo = (DynamicObject)this.voucherEditModel.getValue("currency", rowIndex);
        if (currencyDyo == null) {
            return 0;
        }
        return currencyDyo.getInt("amtprecision");
    }

    public int getCurrencyPricePrecision(int rowIndex) {
        DynamicObject currencyDyo = (DynamicObject)this.voucherEditModel.getValue("currency", rowIndex);
        if (currencyDyo == null) {
            return 0;
        }
        return currencyDyo.getInt("priceprecision");
    }

    public DynamicObject getAccount(int rowIndex) {
        return (DynamicObject)this.getEntryValue("account", rowIndex);
    }

    protected long getAccountId(int rowIndex) {
        return (Long)this.getEntryValue(Voucher.id_((String)"account"), rowIndex);
    }

    protected String getDescription(int rowIndex) {
        return (String)this.getEntryValue("edescription", rowIndex);
    }

    protected Date getExpireDate(int rowIndex) {
        return (Date)this.getEntryValue("expiredate", rowIndex);
    }

    public BigDecimal getDebitLocal(int rowIndex) {
        return this.getEntryBigDecimalValue("debitlocal", rowIndex);
    }

    public BigDecimal getCreditLocal(int rowIndex) {
        return this.getEntryBigDecimalValue("creditlocal", rowIndex);
    }

    public BigDecimal getDebitOriAmt(int rowIndex) {
        return this.getEntryBigDecimalValue("debitori", rowIndex);
    }

    public BigDecimal getCreditOriAmt(int rowIndex) {
        return this.getEntryBigDecimalValue("creditori", rowIndex);
    }

    public BigDecimal getLocAmt(int rowIndex) {
        return this.getLocalAmount(rowIndex);
    }

    public BigDecimal getOriAmt(int rowIndex) {
        return this.getOriginalAmount(rowIndex);
    }

    public String getEntryDC(int rowIndex) {
        return (String)this.getEntryValue("entrydc", rowIndex);
    }

    public BigDecimal getDebitLocAmt(int rowIndex) {
        return this.getDebitLocal(rowIndex);
    }

    public BigDecimal getCreditLocAmt(int rowIndex) {
        return this.getCreditLocal(rowIndex);
    }

    public BigDecimal getLocalAmount(int rowIndex) {
        return "1".equalsIgnoreCase(this.getEntryDC(rowIndex)) ? this.getDebitLocal(rowIndex) : this.getCreditLocal(rowIndex);
    }

    public BigDecimal getOriginalAmount(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("oriamount", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public BigDecimal getExchangeRate(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("localrate", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public BigDecimal getQuantity(int rowIndex) {
        return this.getEntryBigDecimalValue("quantity", rowIndex);
    }

    public BigDecimal getPrice(int rowIndex) {
        return this.getEntryBigDecimalValue("price", rowIndex);
    }

    protected BigDecimal getMainCfAmount(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("maincfamount", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    protected BigDecimal getSuppCfAmount(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("suppcfamount", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    protected DynamicObject getMainCfItem(int rowIndex) {
        return (DynamicObject)this.getEntryValue("maincfitem", rowIndex);
    }

    protected DynamicObject getSuppCfItem(int rowIndex) {
        return (DynamicObject)this.getEntryValue("suppcfitem", rowIndex);
    }

    protected DynamicObject getCurrency(int rowIndex) {
        return (DynamicObject)this.getEntryValue("currency", rowIndex);
    }

    protected DynamicObject getMeasureUnit(int rowIndex) {
        return (DynamicObject)this.getEntryValue("measureunit", rowIndex);
    }

    public Tuple<Integer, RoundingMode> getQuantityPrecision(int rowIndex) {
        DynamicObject unit = this.getMeasureUnit(rowIndex);
        if (unit == null) {
            return Tuple.create((Object)0, (Object)((Object)RoundingMode.HALF_UP));
        }
        return Tuple.create((Object)unit.getInt("precision"), (Object)((Object)this.transPrecisionProcessing(unit.getString("precisionaccount"))));
    }

    private RoundingMode transPrecisionProcessing(String precisionAccount) {
        switch (precisionAccount) {
            case "2": {
                return RoundingMode.DOWN;
            }
            case "3": {
                return RoundingMode.UP;
            }
        }
        return RoundingMode.HALF_UP;
    }

    public RateType getRateType(int rowIndex) {
        return RateType.getRateType((String)((String)this.getEntryValue("ratetype", rowIndex)));
    }

    public int getExchangeRatePrecision(int rowIndex) {
        return RateServiceHelper.getRatePrecision((Long)this.getCurrencyId(rowIndex), (Long)this.getLocalCurrencyID(), (Long)this.getExchangeRateTableID(), (Date)this.getBookDate());
    }

    public String getEntryDCForLocalAmount(int rowIndex) {
        BigDecimal debitLocal = this.getDebitLocal(rowIndex);
        if (debitLocal.signum() != 0) {
            return "1";
        }
        BigDecimal creditLocal = this.getCreditLocal(rowIndex);
        if (creditLocal.signum() != 0) {
            return "-1";
        }
        DynamicObject account = this.getAccount(rowIndex);
        if (account == null) {
            return this.getEntryDC(rowIndex);
        }
        switch (account.getString("accrualdirection")) {
            case "debit": {
                return "1";
            }
            case "credit": {
                return "-1";
            }
        }
        return account.getString("dc");
    }

    public DynamicObjectCollection getVoucherEntries() {
        return this.voucherEditModel.getEntryEntity("entries");
    }

    protected int getEntryCount() {
        return this.voucherEditModel.getEntryRowCount("entries");
    }

    protected Map<String, Object> getAssgrpValue(int rowIndex) {
        DynamicObject assgrpDynValue = (DynamicObject)this.getEntryValue("assgrp", rowIndex);
        if (assgrpDynValue == null) {
            return new HashMap<String, Object>(16);
        }
        FlexValueJson flexValueJson = new FlexValueJson(assgrpDynValue.getString("value"));
        return flexValueJson.getValueMap();
    }

    public BigDecimal getEntryBigDecimalValue(String key, int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue(key, rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public Object getValue(String key) {
        return this.voucherEditModel.getValue(key);
    }

    public DynamicObject getDynamicObject(String key) {
        return (DynamicObject)this.voucherEditModel.getValue(key);
    }

    public Object getEntryValue(String key, int rowIndex) {
        return this.voucherEditModel.getValue(key, rowIndex);
    }

    public boolean isBudget() {
        return this.getBook() != null && this.getBook().getBoolean("isbudget");
    }

    public void setValue(String key, Object value) {
        this.voucherEditModel.setValue(key, value);
    }

    public void setValue(String key, Object value, int rowIndex) {
        this.voucherEditModel.setValue(key, value, rowIndex);
    }
}

