/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.constant.GLField;

public class VoucherNoticePlugin
extends AbstractFormPlugin {
    private static final String ENTRY_KEY_ENTRIES = "entries";
    private static final String COMMA = ",";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        List noticePks = (List)customParams.get("noticeids");
        String noticeEntity = (String)customParams.get("notice_entity");
        if (null == noticePks || noticePks.isEmpty()) {
            this.getView().close();
            return;
        }
        if (StringUtils.isBlank((CharSequence)noticeEntity)) {
            this.getView().close();
            return;
        }
        Map noticeInfos = BusinessDataServiceHelper.loadFromCache((String)noticeEntity, (String)"creator,billno,amount,currency,noticetype", (QFilter[])new QFilter("id", "in", (Object)noticePks).toArray(), (String)"noticetype desc");
        VoucherNoticePlugin.createCardEntries(noticeInfos, this.getView());
    }

    private static void createCardEntries(Map<Object, DynamicObject> noticeInfos, IFormView view) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"creator", "amount", "noticetype", "billno", "currency"});
        for (DynamicObject noticeInfo : noticeInfos.values()) {
            String type = "1".equals(noticeInfo.getString("noticetype")) ? ResManager.loadKDString((String)"\u53d1\u9001\u5355", (String)"VoucherNoticePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63a5\u6536\u5355", (String)"VoucherNoticePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            vs.addRow(new Object[]{noticeInfo.getLong(GLField.id_((String)"creator")), noticeInfo.getBigDecimal("amount"), type, noticeInfo.getString("billno"), noticeInfo.getLong(GLField.id_((String)"currency"))});
        }
        model.batchCreateNewEntryRow(ENTRY_KEY_ENTRIES, vs);
        model.endInit();
        view.updateView(ENTRY_KEY_ENTRIES);
    }
}

