/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.gl.business.service.voucher.option.cfg.VoucherArgConfig;
import kd.fi.gl.business.service.voucher.option.cfg.VoucherCarryConfig;
import kd.fi.gl.business.service.voucher.option.helper.VoucherArgConfigServiceHelper;
import kd.fi.gl.business.service.voucher.option.helper.VoucherCarryConfigServiceHelper;
import kd.fi.gl.business.service.voucher.option.key.ArgKey;
import kd.fi.gl.business.service.voucher.option.key.CarryKey;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLApp;

public class VoucherOptionsPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(VoucherOptionsPlugin.class);
    private static final String AUTO_FILL_ENTRY = "autofillentry";
    private static final String ENTRY_FIELD = "field";
    private static final String ENTRY_IS_AUTO_FILL = "isautofill";
    private static final String ENTRY_FIELD_MARK = "fieldmark";
    private static final String CACHE_ORG_ID = "cache_org_id";
    private static final String CACHE_USER_ID = "cache_user_id";
    private static final String BTN_SAVE = "btn_save";
    private static final String SETDEFAULT = "setdefault";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, SETDEFAULT});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Number orgId = (Number)param.getCustomParam("orgId");
        long userId = ContextUtil.getUserId();
        if (orgId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7", (String)"VoucherOptionsPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            log.error(String.format("\u6253\u5f00\u51ed\u8bc1\u9009\u9879\u9875\u9762\u51fa\u73b0\u5f02\u5e38\uff01\u9875\u9762\u4f20\u9012\u7684\u53c2\u6570\u5b58\u5728\u7a7a\u503c\uff1a[orgId = %s], [userId = %s]", orgId, userId));
            return;
        }
        this.getPageCache().put(CACHE_ORG_ID, SerializationUtils.toJsonString((Object)orgId));
        this.getPageCache().put(CACHE_USER_ID, SerializationUtils.toJsonString((Object)userId));
        this.createData4AutoFillTab(orgId.longValue(), userId);
        this.createData4ArgsConfigTab(orgId.longValue(), userId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_SAVE.equals(key)) {
            VoucherCarryConfigServiceHelper.save((VoucherCarryConfig)this.buildCarryConfig());
            VoucherArgConfigServiceHelper.save((VoucherArgConfig)this.buildArgConfig());
            this.getView().close();
        } else if (SETDEFAULT.equalsIgnoreCase(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u5bf9\u6240\u6709\u7ec4\u7ec7\u751f\u6548\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"VoucherOptionsPlugin_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SETDEFAULT, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (SETDEFAULT.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            VoucherCarryConfigServiceHelper.setDefault((VoucherCarryConfig)this.buildCarryConfig());
            VoucherArgConfigServiceHelper.setDefault((VoucherArgConfig)this.buildArgConfig());
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (ENTRY_IS_AUTO_FILL.equals(propName)) {
            this.processingRelatedData(e);
        }
    }

    private void createData4AutoFillTab(long orgId, long userId) {
        VoucherCarryConfig config = VoucherCarryConfigServiceHelper.get((long)orgId, (long)userId);
        CarryKey[] fields = CarryKey.values();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gl_fieldautofill");
        this.getModel().deleteEntryData(AUTO_FILL_ENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(ENTRY_FIELD, new Object[0]);
        vs.addField(ENTRY_IS_AUTO_FILL, new Object[0]);
        vs.addField(ENTRY_FIELD_MARK, new Object[0]);
        for (CarryKey field : fields) {
            vs.addRow(new Object[]{entityType.getProperty(field.name()).getDisplayName().getLocaleValue(), config.isCarry(field), field.name()});
        }
        model.batchCreateNewEntryRow(AUTO_FILL_ENTRY, vs);
        model.endInit();
        this.getView().updateView(AUTO_FILL_ENTRY);
    }

    private void createData4ArgsConfigTab(long orgId, long userId) {
        VoucherArgConfig config = VoucherArgConfigServiceHelper.get((long)orgId, (long)userId);
        for (ArgKey key : ArgKey.values()) {
            this.getModel().setValue(key.name(), config.getOriginalValue(key));
        }
    }

    private VoucherCarryConfig buildCarryConfig() {
        String orgIdJson = this.getPageCache().get(CACHE_ORG_ID);
        String userIdJson = this.getPageCache().get(CACHE_USER_ID);
        long orgId = (Long)SerializationUtils.fromJsonString((String)orgIdJson, Long.class);
        long userId = (Long)SerializationUtils.fromJsonString((String)userIdJson, Long.class);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUTO_FILL_ENTRY);
        Map<CarryKey, Boolean> configMap = entryEntity.stream().collect(Collectors.toMap(x -> CarryKey.valueOf((String)x.getString(ENTRY_FIELD_MARK)), x -> x.getBoolean(ENTRY_IS_AUTO_FILL)));
        return new VoucherCarryConfig(orgId, userId, configMap);
    }

    private VoucherArgConfig buildArgConfig() {
        String orgIdJson = this.getPageCache().get(CACHE_ORG_ID);
        String userIdJson = this.getPageCache().get(CACHE_USER_ID);
        long orgId = (Long)SerializationUtils.fromJsonString((String)orgIdJson, Long.class);
        long userId = (Long)SerializationUtils.fromJsonString((String)userIdJson, Long.class);
        Map<ArgKey, Object> configMap = Arrays.stream(ArgKey.values()).collect(Collectors.toMap(x -> x, x -> this.getModel().getValue(x.name())));
        return new VoucherArgConfig(orgId, userId, configMap);
    }

    private void processingRelatedData(PropertyChangedArgs e) {
        String fieldMark = e.getChangeSet()[0].getDataEntity().getString(ENTRY_FIELD_MARK);
        boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
        if (CarryKey.quantity.name().equalsIgnoreCase(fieldMark)) {
            if (newValue) {
                int index = this.getFieldMarkIndex(CarryKey.measureunit.name());
                this.getModel().setValue(ENTRY_IS_AUTO_FILL, (Object)true, index);
            }
        } else if (CarryKey.oriamount.name().equalsIgnoreCase(fieldMark) && newValue) {
            int index = this.getFieldMarkIndex(CarryKey.currency.name());
            this.getModel().setValue(ENTRY_IS_AUTO_FILL, (Object)true, index);
        }
    }

    private int getFieldMarkIndex(String fieldMark) {
        if (StringUtils.isEmpty((String)fieldMark)) {
            return -1;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUTO_FILL_ENTRY);
        for (DynamicObject dyn : entryEntity) {
            String mark = dyn.getString(ENTRY_FIELD_MARK);
            if (!fieldMark.equals(mark)) continue;
            return dyn.getInt("seq") - 1;
        }
        return -1;
    }
}

