/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.image.api.ImageService;
import kd.bos.image.enums.ImageQueryTypeEnum;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.service.ServiceFactory;

public class VoucherPrintImage
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>();
        if (!e.isMainDs()) {
            DynamicObjectType dt = e.getDynamicObjectType();
            List ids = e.getPkIds();
            if (ids == null || ids.size() == 0) {
                return;
            }
            ArrayList<String> idsOrNumbers = new ArrayList<String>(ids.size());
            for (Object obj : ids) {
                idsOrNumbers.add(obj.toString());
            }
            Map<String, ImageInfo> imageInfoMap = VoucherPrintImage.batchGetImageInfo(idsOrNumbers);
            if (imageInfoMap == null) {
                return;
            }
            for (Map.Entry<String, ImageInfo> entry : imageInfoMap.entrySet()) {
                DynamicObject dyn = new DynamicObject(dt);
                dyn.set("imagenumber", (Object)entry.getValue().getImageNo());
                objectList.add(dyn);
            }
        } else {
            List dyns = e.getDataEntities();
            for (DynamicObject dd : dyns) {
                objectList.add(dd);
            }
        }
        e.setDataEntities(objectList);
    }

    private static Map<String, ImageInfo> batchGetImageInfo(List<String> ids) {
        Map imageInfos = (Map)ThreadCache.get((Object)"voucher_print_Image_cachekey");
        if (imageInfos == null || imageInfos.size() == 0) {
            ImageService service = (ImageService)ServiceFactory.getService(ImageService.class);
            imageInfos = service.getImageInfoInsideBatch(ids, ImageQueryTypeEnum.BillId.getField());
            ThreadCache.put((Object)"voucher_print_Image_cachekey", (Object)imageInfos);
        } else if (!imageInfos.containsKey(ids.get(0))) {
            ImageService service = (ImageService)ServiceFactory.getService(ImageService.class);
            Map imageInfoMap = service.getImageInfoInsideBatch(ids, ImageQueryTypeEnum.BillId.getField());
            imageInfos.putAll(imageInfoMap);
        }
        return imageInfos;
    }
}

