/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.voucher.relation.VchRelation;
import kd.fi.gl.voucher.relation.VchRelationId;
import kd.fi.gl.voucher.relation.VoucherRelationHelper;

public class VoucherRelationFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String TYPEAP = "typeap";
    private static final String BILLTYPE = "billtype";
    private static final String UNKNOW = "unknow";
    private static final String COUNT = "count";
    private static final String COUNT_FORMAT = "(%d)";
    private static final String ENTITYID = "entityid";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CREATOR = "creator";
    private static final String BILLNO = "billno";
    private static final String BILLID = "billid";
    private static final String VCHNO = "vchno";
    private static final String VCHID = "vchid";
    private static final String MORE = "more";
    private static final int INDEX_BEGIN = 0;
    private static final int MAX_TYPE_SIZE = 15;
    private static final int MAX_BILL_COUNT = 10;
    private static final int COLLPASE_BILL_COUNT = 10;
    private static final int COLLPASE_TYPE_SIZE = 1;
    private static final String IS_IGNORE_LICENSE = "isIgnoreLicense";
    private static final String VOUCHERID = "voucherid";
    private static final String ORGID = "orgid";
    private static final String DIRECT = "direct";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.doSthOnAdvConWithIndex(0, 15, index -> {
            this.addClickListeners(new String[]{this.getControlKey(MORE, index), this.getControlKey(COUNT, index)});
            CardEntry cardEntry = (CardEntry)this.getControl(this.getControlKey(ENTRYENTITY, index));
            cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control control = (Control)source;
            String key = control.getKey();
            if (key.contains(MORE)) {
                this.showAllBill(key, MORE);
            } else if (key.contains(COUNT)) {
                this.showAllBill(key, COUNT);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (fieldName.contains(BILLNO)) {
            this.clickNoField(fieldName, hyperLinkClickEvent.getRowIndex(), BILLNO, BILLID);
        } else if (fieldName.contains(VCHNO)) {
            this.clickNoField(fieldName, hyperLinkClickEvent.getRowIndex(), VCHNO, VCHID);
        }
    }

    private void clickNoField(String noField, int rowIndex, String noKey, String idKey) {
        String entityId;
        int index = this.getIndex(noField, noKey);
        List<Long> idList = this.getIdValue(index, rowIndex, idKey);
        if (idList.isEmpty()) {
            return;
        }
        String string = entityId = VCHNO.equals(noKey) ? "gl_voucher" : this.getEntityId(index);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        if (idList.size() > 1) {
            this.showBillList(entityId, idList);
        } else {
            this.showBillForm(entityId, idList.get(0));
        }
    }

    private List<Long> getIdValue(int index, int rowIndex, String idField) {
        String idStr = (String)this.getModel().getValue(this.getControlKey(idField, index), rowIndex);
        if (StringUtils.isNotBlank((CharSequence)idStr)) {
            String[] idStrArray = idStr.split(",");
            return Arrays.stream(idStrArray).map(Long::valueOf).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void showBillForm(String entityId, long billId) {
        if ("gl_voucher".equals(entityId)) {
            VoucherUtil.hyperVoucher(this.getOrgId(), billId, this.getView());
            return;
        }
        BillShowParameter formshowParameter = new BillShowParameter();
        formshowParameter.setBillStatus(BillOperationStatus.VIEW);
        formshowParameter.setStatus(OperationStatus.VIEW);
        formshowParameter.setFormId(entityId);
        formshowParameter.setPkId((Object)billId);
        formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formshowParameter.setCustomParam(IS_IGNORE_LICENSE, (Object)true);
        formshowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)formshowParameter);
    }

    private void showAllBill(String controlKey, String key) {
        int index = this.getIndex(controlKey, key);
        String entityId = this.getEntityId(index);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        Set<Long> billIds = this.getBillIds(entityId);
        if (billIds.isEmpty()) {
            return;
        }
        this.showBillList(entityId, billIds);
    }

    private Set<Long> getBillIds(String entityId) {
        Map<String, List<VchRelationId>> relationIdMap = this.getVoucherRelatonIdMap();
        List relationIdList = relationIdMap.getOrDefault(entityId, Collections.emptyList());
        return relationIdList.stream().map(VchRelationId::getBillId).filter(x -> x != 0L).collect(Collectors.toSet());
    }

    private void showBillList(String entityId, Collection<Long> billIds) {
        if (billIds.isEmpty()) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setCustomParam("org", (Object)String.valueOf(this.getOrgId()));
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.setCustomParam(IS_IGNORE_LICENSE, (Object)true);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getEntityId(int index) {
        return (String)this.getModel().getValue(this.getControlKey(ENTITYID, index));
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, List<VchRelationId>> vchRelationIdMap = this.getVoucherRelatonIdMap();
        this.initAdvConState(vchRelationIdMap);
        ArrayList<Map.Entry<String, List<VchRelationId>>> vchRelationIdEntryList = new ArrayList<Map.Entry<String, List<VchRelationId>>>(vchRelationIdMap.entrySet());
        this.doSthOnAdvConWithIndex(0, vchRelationIdEntryList.size(), index -> {
            Map.Entry vchRelationIdEntry = (Map.Entry)vchRelationIdEntryList.get(index);
            String entityId = (String)vchRelationIdEntry.getKey();
            List vchRelationIdList = (List)vchRelationIdEntry.getValue();
            this.setEntityInfo(entityId, index);
            boolean isDirect = vchRelationIdList.stream().anyMatch(VchRelationId::getDirectRelationBill);
            this.setDirectVisible(index, isDirect);
            int billCount = vchRelationIdList.size();
            this.setBillCount(billCount, index);
            this.setRelationEntryInfo(vchRelationIdList, index, entityId);
            this.setMoreLabelVisiable(billCount > 10, index);
        });
    }

    private void initAdvConState(Map<String, List<VchRelationId>> vchRelationIdMap) {
        int totalTypeSize = vchRelationIdMap.size();
        int showAdvConSize = Math.min(totalTypeSize, 15);
        this.doSthOnAdvConWithIndex(showAdvConSize, 15, index -> this.getView().setVisible(Boolean.FALSE, new String[]{this.getControlKey(TYPEAP, index)}));
        long totalBillCount = vchRelationIdMap.values().stream().mapToLong(Collection::size).sum();
        boolean collapse = this.isInitCollapse(totalBillCount, totalTypeSize);
        this.doSthOnAdvConWithIndex(0, showAdvConSize, index -> this.getAdvContainer(index).setCollapse(collapse));
    }

    private boolean isInitCollapse(long totalBillCount, int totalTypeSize) {
        return totalBillCount > 10L && totalTypeSize > 1;
    }

    private AdvContainer getAdvContainer(int index) {
        return (AdvContainer)this.getControl(this.getControlKey(TYPEAP, index));
    }

    private void setEntityInfo(String entityId, int index) {
        this.getModel().setValue(this.getControlKey(ENTITYID, index), (Object)entityId);
        this.setBillTypeName(entityId, index);
    }

    private void setBillTypeName(String entityId, int index) {
        Label typeLabel = (Label)this.getControl(this.getControlKey(BILLTYPE, index));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        typeLabel.setText(dataEntityType == null ? UNKNOW : dataEntityType.getDisplayName().getLocaleValue());
    }

    private void setDirectVisible(int index, boolean isDirect) {
        this.getView().setVisible(Boolean.valueOf(isDirect), new String[]{this.getControlKey(DIRECT, index)});
    }

    private void setBillCount(int count, int index) {
        Label countLabel = (Label)this.getControl(this.getControlKey(COUNT, index));
        countLabel.setText(String.format(COUNT_FORMAT, count));
    }

    private void setRelationEntryInfo(List<VchRelationId> vchRelationIdList, int index, String entityId) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{this.getControlKey(CREATOR, index), this.getControlKey(BILLNO, index), this.getControlKey(BILLID, index), this.getControlKey(VCHNO, index), this.getControlKey(VCHID, index)});
        int billCount = vchRelationIdList.size();
        ArrayList<Integer> noVchRows = new ArrayList<Integer>(Math.min(10, billCount));
        List<VchRelationId> subVchRelationIdList = vchRelationIdList.subList(0, Math.min(10, billCount));
        List vchRelationList = VoucherRelationHelper.fillRelationBillInfo(subVchRelationIdList, (String)entityId);
        this.doSthOnEntryWithEndIndex(billCount, i -> {
            String vchId;
            VchRelation vchRelation = (VchRelation)vchRelationList.get(i);
            String string = vchId = vchRelation.getVchIdSet() == null ? null : StringUtils.join((Object[])vchRelation.getVchIdSet().toArray(new Long[0]), (String)",");
            if (StringUtils.isBlank(vchId)) {
                noVchRows.add(i);
            }
            tableValueSetter.addRow(new Object[]{vchRelation.getCreatorId(), vchRelation.getBillNo(), vchRelation.getBillId(), vchRelation.getVchBillNo(), vchId});
        });
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        String entryKey = this.getControlKey(ENTRYENTITY, index);
        model.deleteEntryData(entryKey);
        model.batchCreateNewEntryRow(entryKey, tableValueSetter);
        model.endInit();
        this.getView().updateView(entryKey);
        this.setVchFlexVisible(noVchRows, index);
    }

    private void setVchFlexVisible(List<Integer> noVchRows, int index) {
        String entryKey = this.getControlKey(ENTRYENTITY, index);
        CardEntry cardEntry = (CardEntry)this.getControl(entryKey);
        String vchFlexKey = this.getControlKey("vchflex", index);
        noVchRows.forEach(x -> cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), x.intValue(), new String[]{vchFlexKey}));
    }

    private void setMoreLabelVisiable(boolean visiable, int index) {
        this.getView().setVisible(Boolean.valueOf(visiable), new String[]{this.getControlKey(MORE, index)});
    }

    private void doSthOnAdvConWithIndex(int beginIndex, int endIndex, IntConsumer consumer) {
        endIndex = Math.min(15, endIndex);
        this.doSthInLoop(beginIndex, endIndex, consumer);
    }

    private void doSthOnEntryWithEndIndex(int endIndex, IntConsumer consumer) {
        endIndex = Math.min(10, endIndex);
        this.doSthInLoop(0, endIndex, consumer);
    }

    private void doSthInLoop(int beginIndex, int endIndex, IntConsumer consumer) {
        if ((beginIndex = Math.max(0, beginIndex)) >= endIndex) {
            return;
        }
        for (int index = beginIndex; index < endIndex; ++index) {
            consumer.accept(index);
        }
    }

    private String getControlKey(String key, int index) {
        return index > 0 ? key + index : key;
    }

    private int getIndex(String controlKey, String key) {
        String indexStr = controlKey.replace(key, "");
        if (StringUtils.isBlank((CharSequence)indexStr)) {
            return 0;
        }
        return Integer.parseInt(indexStr);
    }

    private long getVchId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam(VOUCHERID);
    }

    private long getOrgId() {
        return Long.parseLong(this.getView().getFormShowParameter().getCustomParam(ORGID).toString());
    }

    private Map<String, List<VchRelationId>> getVoucherRelatonIdMap() {
        return this.getVchRelationIdList().stream().collect(Collectors.groupingBy(VchRelationId::getEntityId, LinkedHashMap::new, Collectors.toList()));
    }

    private List<VchRelationId> getVchRelationIdList() {
        String relationCache = this.getPageCache().get(VOUCHERID);
        if (StringUtils.isBlank((CharSequence)relationCache)) {
            List vchRelationIdList = VoucherRelationHelper.getVoucherRelationIds((long)this.getVchId());
            this.getPageCache().put(VOUCHERID, SerializationUtils.toJsonString((Object)vchRelationIdList));
            return vchRelationIdList;
        }
        return SerializationUtils.fromJsonStringToList((String)relationCache, VchRelationId.class);
    }
}

