/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.util.GLApp;

public class VoucherSearchAndReplacePlugin
extends AbstractFormPlugin {
    private static final String SEARCH_TEXT = "searchtext";
    private static final String REPLACE_TEXT = "replacetext";
    private VoucherEditView voucherEditView;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.click((EventObject)evt);
        switch (key = evt.getItemKey()) {
            case "replaceall": {
                if (!this.verify()) break;
                this.replaceAll();
                break;
            }
            case "replace": {
                if (!this.verify()) break;
                this.replace();
                break;
            }
            case "searchnext": {
                if (!this.verify()) break;
                this.search();
                break;
            }
        }
    }

    private void replaceAll() {
        String target = (String)this.getModel().getValue(SEARCH_TEXT);
        String replacement = (String)this.getModel().getValue(REPLACE_TEXT);
        int nextIndex = -1;
        int successCnt = 0;
        IDataModel voucherModel = this.getVoucherEditView().getVoucherEditModel();
        voucherModel.beginInit();
        while ((nextIndex = this.findNext(nextIndex + 1, target, false)) != -1) {
            String description = this.getVoucherEditView().getValueGetter().getDescription(nextIndex);
            if (!this.getVoucherEditView().getControlStateRecoder().getEntryState("edescription", nextIndex) || StringUtils.isEmpty((String)description)) continue;
            voucherModel.setValue("edescription", (Object)description.replaceAll(target, replacement), nextIndex);
            ++successCnt;
        }
        voucherModel.endInit();
        if (successCnt > 0) {
            this.getVoucherEditView().getVchFormView().updateView("entries");
            this.getView().sendFormAction(this.voucherEditView.getVchFormView());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5168\u90e8\u5b8c\u6210\uff0c\u5b8c\u6210%s\u5904\u66ff\u6362\u3002", (String)"VoucherSearchAndReplacePlugin_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{successCnt}));
    }

    private boolean verify() {
        String val = (String)this.getModel().getValue(SEARCH_TEXT);
        if (StringUtils.isEmpty((String)val)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u67e5\u627e\u5185\u5bb9\u3002", (String)"VoucherSearchAndReplacePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void replace() {
        int currentRowIndex;
        String target = (String)this.getModel().getValue(SEARCH_TEXT);
        String replacement = (String)this.getModel().getValue(REPLACE_TEXT);
        VoucherEditValueGetter valueGetter = this.getVoucherEditView().getValueGetter();
        String description = valueGetter.getDescription(currentRowIndex = valueGetter.getEntriesCurrentRowIndex());
        if (StringUtils.isBlank((String)description) || !description.contains(target) || !this.getVoucherEditView().getControlStateRecoder().getEntryState("edescription", currentRowIndex)) {
            this.search();
            return;
        }
        this.getVoucherEditView().getVoucherEditModel().setValue("edescription", (Object)description.replaceAll(target, replacement), currentRowIndex);
        int next = this.findNext(currentRowIndex + 1, target, true);
        if (next >= 0) {
            this.getVoucherEditView().getVoucherEntryGrid().focusCell(next, "edescription");
        }
        this.getView().sendFormAction(this.getVoucherEditView().getVchFormView());
    }

    private void search() {
        String target = (String)this.getModel().getValue(SEARCH_TEXT);
        int currentRowIndex = this.getVoucherEditView().getValueGetter().getEntriesCurrentRowIndex();
        EntryGrid entryGrid = this.getVoucherEditView().getVoucherEntryGrid();
        int next = this.findNext(currentRowIndex + 1, target, true);
        if (next >= 0) {
            entryGrid.focusCell(next, "edescription");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u60a8\u6240\u67e5\u627e\u7684\u5185\u5bb9\u3002", (String)"VoucherSearchAndReplacePlugin_3", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
        this.getView().sendFormAction(this.getVoucherEditView().getVchFormView());
    }

    private int findNext(int beginIndex, String findStr, boolean restartFromStart) {
        String description;
        int i;
        int entryCurrentPageSize = this.getVoucherEditView().getEntryCurrentPageSize();
        VoucherEditValueGetter valueGetter = this.getVoucherEditView().getValueGetter();
        for (i = beginIndex; i < entryCurrentPageSize; ++i) {
            description = valueGetter.getDescription(i);
            if (!StringUtils.isNotEmpty((String)description) || !description.contains(findStr)) continue;
            return i;
        }
        if (!restartFromStart) {
            return -1;
        }
        for (i = 0; i < Math.min(beginIndex, entryCurrentPageSize); ++i) {
            description = valueGetter.getDescription(i);
            if (!StringUtils.isNotEmpty((String)description) || !description.contains(findStr)) continue;
            return i;
        }
        return -1;
    }

    private VoucherEditView getVoucherEditView() {
        IFormView voucherFormView = this.getView().getParentView();
        if (this.voucherEditView == null) {
            this.voucherEditView = new VoucherEditView(voucherFormView, voucherFormView.getModel(), voucherFormView.getPageCache());
        }
        return this.voucherEditView;
    }
}

