/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.backcalculate.impl;

import java.math.BigDecimal;
import java.util.Optional;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.enums.voucher.OriRateReCalRuleEnum;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculatorGroup;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculator;

public class LocalAmountChanged
implements IBackCalculator {
    @Override
    public String group() {
        return BackCalculatorGroup.ORI_AMT_RATE_LOC_AMT.name();
    }

    @Override
    public String[] applicableChangedFields() {
        return new String[]{"debitlocal", "creditlocal"};
    }

    @Override
    public Optional<BackCalculateResult> backCalculate(BackCalculateChangedValue changedValue) {
        VoucherEditView voucherEditView = changedValue.getVoucherEditView();
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        int rowIndex = changedValue.getRowIndex();
        BigDecimal originalAmount = valueGetter.getOriginalAmount(rowIndex);
        BigDecimal exchangeRate = valueGetter.getExchangeRate(rowIndex);
        OriRateReCalRuleEnum backCalculateRule = null;
        if (originalAmount.signum() != 0 && exchangeRate.signum() != 0) {
            backCalculateRule = VoucherEditArgHelper.getOriRateReCalRule((long)valueGetter.getOrgId());
        }
        if (backCalculateRule == null || backCalculateRule == OriRateReCalRuleEnum.NO_RE_CAL) {
            if (originalAmount.signum() != 0 && exchangeRate.signum() == 0) {
                backCalculateRule = OriRateReCalRuleEnum.RE_CAL_RATE;
            } else if (originalAmount.signum() == 0 && exchangeRate.signum() != 0) {
                backCalculateRule = OriRateReCalRuleEnum.RE_CAL_ORI;
            }
        }
        if (backCalculateRule == null) {
            return Optional.empty();
        }
        BigDecimal localAmount = changedValue.getValue();
        switch (backCalculateRule) {
            case RE_CAL_ORI: {
                return LocalAmountChanged.calculateOriginalAmount(voucherEditView, rowIndex, localAmount, exchangeRate);
            }
            case RE_CAL_RATE: {
                return LocalAmountChanged.calculateExchangeRate(voucherEditView, rowIndex, localAmount, originalAmount);
            }
        }
        return Optional.empty();
    }

    public static Optional<BackCalculateResult> calculateExchangeRate(VoucherEditView voucherEditView, int rowIndex, BigDecimal localAmount, BigDecimal originalAmount) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        if (valueGetter.getCurrencyId(rowIndex) == valueGetter.getLocalCurrencyID().longValue()) {
            return Optional.of(new BackCalculateResult("localrate", BigDecimal.ONE));
        }
        RateType rateType = valueGetter.getRateType(rowIndex);
        BigDecimal exchangeRate = rateType.getRateCalculator().calRate(originalAmount, localAmount, valueGetter.getExchangeRatePrecision(rowIndex));
        return Optional.of(new BackCalculateResult("localrate", exchangeRate));
    }

    public static Optional<BackCalculateResult> calculateOriginalAmount(VoucherEditView voucherEditView, int rowIndex, BigDecimal localAmount, BigDecimal exchangeRate) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        if ("2".equals(valueGetter.getSourceType())) {
            return Optional.empty();
        }
        if (valueGetter.getCurrencyId(rowIndex) == valueGetter.getLocalCurrencyID().longValue()) {
            return Optional.of(new BackCalculateResult("oriamount", localAmount));
        }
        RateType rateType = valueGetter.getRateType(rowIndex);
        BigDecimal originalAmount = rateType.getRateCalculator().calOriAmount(exchangeRate, localAmount, valueGetter.getCurrencyAmountPrecision(rowIndex));
        return Optional.of(new BackCalculateResult("oriamount", originalAmount));
    }

    public static Optional<BackCalculateResult> calculateLocalAmount(VoucherEditView voucherEditView, int rowIndex, BigDecimal originalAmount, BigDecimal exchangeRate) {
        String localField;
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        String entryDCForLocalAmount = valueGetter.getEntryDCForLocalAmount(rowIndex);
        String string = localField = "1".equalsIgnoreCase(entryDCForLocalAmount) ? "debitlocal" : "creditlocal";
        if (valueGetter.getCurrencyId(rowIndex) == valueGetter.getLocalCurrencyID().longValue()) {
            return Optional.of(new BackCalculateResult(localField, originalAmount));
        }
        RateType rateType = valueGetter.getRateType(rowIndex);
        BigDecimal localAmount = rateType.getRateCalculator().calLocAmount(exchangeRate, originalAmount, valueGetter.getLocalCurrencyAmountPrecision());
        return Optional.of(new BackCalculateResult(localField, localAmount));
    }
}

