/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.cashflow;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.formplugin.voucher.cashflow.ICashflowInfo;
import kd.fi.gl.formplugin.voucher.cashflow.Result;
import kd.fi.gl.util.GLUtil;

public class DataEntityCalculator
implements ICashflowInfo {
    @Override
    public Result calCfInfo(DynamicObject voucher, boolean localSet) {
        BigDecimal cashtotalamt = BigDecimal.ZERO;
        BigDecimal pltotalamt = BigDecimal.ZERO;
        BigDecimal cashtotalused = BigDecimal.ZERO;
        BigDecimal pltotalused = BigDecimal.ZERO;
        int cashCount = 0;
        int plCount = 0;
        int nnCount = 0;
        boolean hasSupp = false;
        HashMap<Long, Boolean> plAcctMap = new HashMap<Long, Boolean>();
        String entryKey = voucher.getDataEntityType().getName().equals("gl_templatevoucher") ? "voucherentity" : "entries";
        DynamicObjectCollection entries = voucher.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entries) {
            boolean isPLAcct;
            BigDecimal mainCfamt;
            DynamicObject mainCF;
            DynamicObject acct = entry.getDynamicObject("account");
            if (acct == null) {
                mainCF = entry.getDynamicObject("maincfitem");
                if (mainCF == null) continue;
                mainCfamt = entry.getBigDecimal("maincfamount");
                if ("o".equals(mainCF.getString("direction"))) {
                    cashtotalused = cashtotalused.subtract(mainCfamt);
                    continue;
                }
                cashtotalused = cashtotalused.add(mainCfamt);
                continue;
            }
            if (AccountType.isBudgetType((long)acct.getLong("accounttype_id"))) continue;
            if (GLUtil.isCashAcct((DynamicObject)acct)) {
                ++cashCount;
                BigDecimal drLoc = entry.getBigDecimal("debitlocal");
                BigDecimal crLoc = entry.getBigDecimal("creditlocal");
                cashtotalamt = cashtotalamt.add(drLoc).subtract(crLoc);
                if (!localSet) continue;
            }
            if ((mainCF = entry.getDynamicObject("maincfitem")) != null) {
                mainCfamt = entry.getBigDecimal("maincfamount");
                cashtotalused = "o".equals(mainCF.getString("direction")) ? cashtotalused.subtract(mainCfamt) : cashtotalused.add(mainCfamt);
            }
            BigDecimal suppCfamt = entry.getBigDecimal("suppcfamount");
            pltotalused = pltotalused.add(suppCfamt);
            if (plAcctMap.get(acct.getLong("id")) == null) {
                isPLAcct = GLUtil.isPLAcct((DynamicObject)acct);
                plAcctMap.put(acct.getLong("id"), isPLAcct);
            } else {
                isPLAcct = (Boolean)plAcctMap.get(acct.getLong("id"));
            }
            if (isPLAcct) {
                ++plCount;
                BigDecimal drLoc = entry.getBigDecimal("debitlocal");
                BigDecimal crLoc = entry.getBigDecimal("creditlocal");
                pltotalamt = pltotalamt.add(drLoc).subtract(crLoc);
            }
            if (!hasSupp && entry.getDynamicObject("suppcfitem") != null) {
                hasSupp = true;
            }
            if (GLUtil.isCashAcct((DynamicObject)acct) || isPLAcct) continue;
            ++nnCount;
        }
        Result result = new Result();
        result.setCashCount(cashCount);
        result.setPlCount(plCount);
        result.setNnCount(nnCount);
        result.setCashtotalamt(cashtotalamt);
        result.setPltotalamt(pltotalamt);
        result.setCashtotalused(cashtotalused);
        result.setPltotalused(pltotalused);
        result.setHasSupp(hasSupp);
        return result;
    }
}

