/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.count;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.formplugin.voucher.count.param.VoucherCountLock;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.voucher.count.VoucherCountUpgradeEngine;

public class VoucherCountFixService {
    private static final Log logger = LogFactory.getLog(VoucherCountFixService.class);

    public boolean fixVoucherCount(Set<Long> orgs, List<Long> periods) {
        boolean result;
        block17: {
            result = true;
            try (DLock lock = DLock.create((String)VoucherCountLock.LockKey.getValue());){
                if (!lock.tryLock()) break block17;
                logger.info("VoucherCountFixService get lock success");
                try {
                    SqlBuilder builder = new SqlBuilder();
                    builder.append("select distinct forgid,fbooktypeid,fperiodid from t_gl_voucher where ", new Object[0]);
                    builder.appendIn("forgid", orgs.toArray());
                    DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder);
                    ArrayList<Future> resultList = new ArrayList<Future>();
                    for (Row row : dataSet) {
                        long org = row.getLong("forgid");
                        long booktype = row.getLong("fbooktypeid");
                        long period = row.getLong("fperiodid");
                        if (!CollectionUtils.isEmpty(periods) && !periods.contains(period)) continue;
                        Future future = GLThreadService.submitAndGetResult((String)"VoucherCountFixService", (Callable)new VoucherCountUpgradeEngine(org, booktype, period, true));
                        resultList.add(future);
                        if (resultList.size() <= 100) continue;
                        for (Future taskResult : resultList) {
                            if (((Boolean)((Tuple)taskResult.get()).item1).booleanValue()) continue;
                            result = false;
                            if (!DebugTrace.enable()) continue;
                            logger.info("VoucherCountFixService error data : " + (String)((Tuple)taskResult.get()).item2);
                        }
                        resultList.clear();
                    }
                    for (Future taskResult : resultList) {
                        if (((Boolean)((Tuple)taskResult.get()).item1).booleanValue()) continue;
                        result = false;
                        if (!DebugTrace.enable()) continue;
                        logger.info("VoucherCountFixService error data : " + (String)((Tuple)taskResult.get()).item2);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }
}

