/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.count.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.formplugin.voucher.count.param.VoucherCountLock;

public class VoucherCountTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(VoucherCountTask.class);
    private static final int batch_size = 1000;
    private static final String Insert_VoucherCount = "insert into T_GL_VOUCHERCOUNT (fid,forgid,fbooktypeid,fperiodid,fbookeddate,fbillstatus,fischeck,fispost,fsourcetype,fmainstatus,fsuppstatus,fvouchercount,fentrycount) Values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String Update_VoucherCount = "update T_GL_VOUCHERCOUNT set fvouchercount = ? ,fentrycount=? where forgid=? and fbooktypeid = ? and fperiodid=? and fbookeddate=? and fbillstatus=?\u3000and fischeck=? and fispost=? and fsourcetype=? and fmainstatus=? and fsuppstatus=?";
    private static final int Insert_Batch_Size = 999;

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        block34: {
            try (DLock lock = DLock.create((String)VoucherCountLock.LockKey.getValue());){
                List ids;
                if (!lock.tryLock(0L)) break block34;
                logger.info("VoucherCountTask get lock success");
                QFilter qFilter = new QFilter("calculated", "=", (Object)false);
                while ((ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_vouchercount_log", (QFilter[])new QFilter[]{qFilter}, (String)"org,period, bookeddate", (int)1000)).size() != 0) {
                    TXHandle tx = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try {
                            SqlBuilder builder = new SqlBuilder();
                            builder.append(" select  forgid ,fbooktypeid ,fperiodid,fbookeddate ,fbillstatus,fischeck,fispost ,fsourcetype,fmainstatus,fsuppstatus, (case  when fcount > 0 then 1 else -1 end) logvouchercount,fcount logentrycount from t_gl_vouchercount_log where ", new Object[0]);
                            builder.appendIn(" fid ", ids);
                            DataSet logDs = DB.queryDataSet((String)"kd.fi.gl.voucher.count.task.VoucherCountTask", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder).groupBy(new String[]{"forgid", "fbooktypeid", "fperiodid", "fbookeddate", "fbillstatus", "fsourcetype", "fischeck", "fispost", "fmainstatus", "fsuppstatus"}).sum("logvouchercount").sum("logentrycount").finish();
                            HashSet<Long> orgs = new HashSet<Long>();
                            HashSet<Long> booktypes = new HashSet<Long>();
                            HashSet<Long> periods = new HashSet<Long>();
                            for (Row row : logDs.copy()) {
                                orgs.add(row.getLong("forgid"));
                                booktypes.add(row.getLong("fbooktypeid"));
                                periods.add(row.getLong("fperiodid"));
                            }
                            logger.info("VoucherCountTask params : orgs in " + orgs + "; booktypes in " + booktypes + "; periods in " + periods);
                            builder = new SqlBuilder();
                            builder.append(" select  forgid org,fbooktypeid booktype,fperiodid period,fbookeddate bookeddate,fbillstatus billstatus,fischeck ischeck,fispost ispost,fsourcetype sourcetype,fmainstatus mainstatus,fsuppstatus suppstatus,fvouchercount vouchercount,fentrycount entrycount from t_gl_vouchercount where ", new Object[0]);
                            builder.appendIn(" forgid ", orgs.toArray());
                            builder.appendIn(" and fbooktypeid ", booktypes.toArray());
                            builder.appendIn(" and fperiodid ", periods.toArray());
                            DataSet countDs = DB.queryDataSet((String)"kd.fi.gl.voucher.count.task.VoucherCountTask", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder);
                            logDs = logDs.join(countDs, JoinType.LEFT).on("forgid", "org").on("fbooktypeid", "booktype").on("fperiodid", "period").on("fbookeddate", "bookeddate").on("fbillstatus", "billstatus").on("fischeck", "ischeck").on("fispost", "ispost").on("fsourcetype", "sourcetype").on("fmainstatus", "mainstatus").on("fsuppstatus", "suppstatus").select(new String[]{"forgid", "fbooktypeid", "fperiodid", "fbookeddate", "fbillstatus", "fischeck", "fispost", "fsourcetype", "fmainstatus", "fsuppstatus", "logvouchercount", "logentrycount"}, new String[]{"vouchercount", "entrycount"}).finish();
                            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(999);
                            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(999);
                            List<Object> countIds = new ArrayList(1000);
                            for (Row row : logDs) {
                                Object[] object;
                                if (CollectionUtils.isEmpty(countIds)) {
                                    countIds = Arrays.stream(DB.genLongIds((String)"t_gl_vouchercount", (int)1000)).boxed().collect(Collectors.toList());
                                }
                                if (row.getInteger("entrycount") == null) {
                                    object = new Object[]{countIds.remove(0), row.getLong("forgid"), row.getLong("fbooktypeid"), row.getLong("fperiodid"), row.getDate("fbookeddate"), row.getString("fbillstatus"), row.getString("fischeck"), row.getString("fispost"), row.getString("fsourcetype"), row.getString("fmainstatus"), row.getString("fsuppstatus"), row.getInteger("logvouchercount"), row.getInteger("logentrycount")};
                                    insertParams.add(object);
                                } else {
                                    object = new Object[]{row.getInteger("logvouchercount") + row.getInteger("vouchercount"), row.getInteger("logentrycount") + row.getInteger("entrycount"), row.getLong("forgid"), row.getLong("fbooktypeid"), row.getLong("fperiodid"), row.getDate("fbookeddate"), row.getString("fbillstatus"), row.getString("fischeck"), row.getString("fispost"), row.getString("fsourcetype"), row.getString("fmainstatus"), row.getString("fsuppstatus")};
                                    updateParams.add(object);
                                }
                                if (updateParams.size() > 999) {
                                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)Update_VoucherCount, updateParams);
                                    updateParams.clear();
                                }
                                if (insertParams.size() <= 999) continue;
                                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)Insert_VoucherCount, insertParams);
                                insertParams.clear();
                            }
                            if (updateParams.size() > 0) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)Update_VoucherCount, updateParams);
                            }
                            if (insertParams.size() > 0) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)Insert_VoucherCount, insertParams);
                            }
                            SqlBuilder builder1 = new SqlBuilder();
                            builder1.append("update t_gl_vouchercount_log set FCALCULATED = '1' where ", new Object[0]);
                            builder1.appendIn(" FID ", ids);
                            DB.update((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder1);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            tx.markRollback();
                            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

