/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.ipt;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.format.DateFormatter;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportAccountInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportAssgrp;
import kd.fi.gl.util.ImportUtil;
import kd.fi.gl.util.VoucherImportUtil;

public class VoucherImportEntryInfo {
    private static final String LOCALAMOUNT = "localamount";
    private static final String ORIAMOUNT = "oriamount";
    private long accountId;
    private String accountNumber;
    private VoucherImportAccountInfo accountInfo;
    private long currencyId;
    private String currencyNumber;
    private final VoucherImportAssgrp assgrp;
    private String mainCFItemNumber;
    private long mainCFItemId;
    private final Map<String, Object> sourceEntryMap;

    protected VoucherImportEntryInfo(Map<String, Object> sourceEntryMap) {
        this.sourceEntryMap = sourceEntryMap;
        Map accountInfoMap = (Map)sourceEntryMap.get("account");
        this.accountNumber = accountInfoMap != null ? accountInfoMap.getOrDefault("number", "") : "";
        this.accountId = accountInfoMap != null ? accountInfoMap.getOrDefault("id", 0L) : 0L;
        this.accountInfo = new VoucherImportAccountInfo(accountInfoMap != null ? accountInfoMap : new HashMap(1));
        Map mainCFItemInfoMap = (Map)sourceEntryMap.get("maincfitem");
        this.mainCFItemNumber = Optional.ofNullable(mainCFItemInfoMap).map(m -> (String)m.get("number")).orElse("");
        this.mainCFItemId = Optional.ofNullable(mainCFItemInfoMap).map(m -> (Long)m.get("id")).orElseGet(() -> 0L);
        Map currencyInfoMap = (Map)sourceEntryMap.get("currency");
        this.currencyNumber = currencyInfoMap != null ? currencyInfoMap.getOrDefault("number", "") : "";
        this.currencyId = currencyInfoMap != null ? currencyInfoMap.getOrDefault("id", 0L) : 0L;
        this.assgrp = new VoucherImportAssgrp(sourceEntryMap.get("assgrp") == null ? Collections.emptyMap() : (Map)sourceEntryMap.get("assgrp"));
        this.initAmount();
    }

    public int getExcelRowNum() {
        return Integer.parseInt(this.getSourceEntryMap().getOrDefault("rowNum", 0).toString());
    }

    public String initEntryDC() {
        String dc = ImportUtil.getString(this.sourceEntryMap, (String)"entrydc");
        if ("1".equalsIgnoreCase(dc) || "-1".equalsIgnoreCase(dc)) {
            return dc;
        }
        dc = VoucherImportUtil.getEntryDCByAmount(this.sourceEntryMap, (AmountField[])new AmountField[]{AmountField.LOCAL, AmountField.ORIGINAL}).orElse("-1");
        this.sourceEntryMap.put("entrydc", dc);
        return dc;
    }

    public Map<String, Object> getSourceEntryMap() {
        return this.sourceEntryMap;
    }

    protected final void setAccountInfo(VoucherImportAccountInfo accountInfo) {
        this.setAccountId(accountInfo.getId());
        this.setAssistEntryInfo(accountInfo.getFlexMustInputMap());
        this.accountInfo = accountInfo;
    }

    private void setAssistEntryInfo(Map<String, Boolean> flexMustInputMap) {
        Map accountInfoMap = this.sourceEntryMap.getOrDefault("account", new HashMap(1));
        accountInfoMap.put("checkitementry", flexMustInputMap);
        this.sourceEntryMap.put("account", accountInfoMap);
    }

    protected VoucherImportAccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    protected long getAccountId() {
        return this.accountId;
    }

    protected final void setAccountId(long accountId) {
        Map accountInfoMap = this.sourceEntryMap.getOrDefault("account", new HashMap(1));
        accountInfoMap.put("id", accountId);
        this.sourceEntryMap.put("account", accountInfoMap);
        this.accountId = accountId;
    }

    protected String getAccountNumber() {
        return this.accountNumber;
    }

    protected long getMainCFItemId() {
        return this.mainCFItemId;
    }

    protected void setMainCFItemId(long mainCFItemId) {
        Map mainCFItemInfoMap = this.sourceEntryMap.getOrDefault("maincfitem", new HashMap(1));
        mainCFItemInfoMap.put("id", mainCFItemId);
        this.sourceEntryMap.put("maincfitem", mainCFItemInfoMap);
        this.mainCFItemId = mainCFItemId;
    }

    protected String getMainCFItemNumber() {
        return this.mainCFItemNumber;
    }

    protected long getCurrencyId() {
        return this.currencyId;
    }

    protected final void setCurrencyId(long currencyId) {
        Map currencyInfoMap = this.sourceEntryMap.getOrDefault("currency", new HashMap(1));
        currencyInfoMap.put("id", currencyId);
        this.sourceEntryMap.put("currency", currencyInfoMap);
        this.currencyId = currencyId;
    }

    protected String getCurrencyNumber() {
        return this.currencyNumber;
    }

    protected void setCurrencyNumber(String currencyNumber) {
        Map currencyInfoMap = this.sourceEntryMap.getOrDefault("currency", new HashMap(1));
        currencyInfoMap.put("number", currencyNumber);
        this.sourceEntryMap.put("currency", currencyInfoMap);
        this.currencyNumber = currencyNumber;
    }

    protected void setRate(BigDecimal rate) {
        this.sourceEntryMap.put("localrate", rate);
    }

    protected Date getDueDate() {
        Object dueDate = this.sourceEntryMap.get("expiredate");
        if (dueDate instanceof Timestamp) {
            return (Date)dueDate;
        }
        if (dueDate instanceof String) {
            if (StringUtils.isEmpty((CharSequence)((String)dueDate))) {
                return null;
            }
            return DateFormatter.yearMonthDayParse((String)((String)dueDate));
        }
        return null;
    }

    protected void setDueDate(Date dueDate) {
        this.sourceEntryMap.put("expiredate", dueDate);
    }

    protected VoucherImportAssgrp getAssgrp() {
        return this.assgrp;
    }

    private void initAmount() {
        String dc = (String)this.sourceEntryMap.get("entrydc");
        if (StringUtils.isNotBlank((CharSequence)dc)) {
            Object oriAmount;
            if ("1".equals(dc)) {
                this.sourceEntryMap.put("creditlocal", BigDecimal.ZERO);
                this.sourceEntryMap.put("creditori", BigDecimal.ZERO);
            } else {
                this.sourceEntryMap.put("debitlocal", BigDecimal.ZERO);
                this.sourceEntryMap.put("debitori", BigDecimal.ZERO);
            }
            Object localAmount = this.sourceEntryMap.get(LOCALAMOUNT);
            if (null != localAmount) {
                if ("1".equals(dc)) {
                    this.sourceEntryMap.put("debitlocal", localAmount);
                } else {
                    this.sourceEntryMap.put("creditlocal", localAmount);
                }
            }
            if (null != (oriAmount = this.sourceEntryMap.get(ORIAMOUNT))) {
                if ("1".equals(dc)) {
                    this.sourceEntryMap.put("debitori", oriAmount);
                } else {
                    this.sourceEntryMap.put("creditori", oriAmount);
                }
            }
        }
        if (!this.sourceEntryMap.containsKey("debitori")) {
            this.sourceEntryMap.put("debitori", BigDecimal.ZERO);
        }
        if (!this.sourceEntryMap.containsKey("creditori")) {
            this.sourceEntryMap.put("creditori", BigDecimal.ZERO);
        }
        if (!this.sourceEntryMap.containsKey("debitlocal")) {
            this.sourceEntryMap.put("debitlocal", BigDecimal.ZERO);
        }
        if (!this.sourceEntryMap.containsKey("creditlocal")) {
            this.sourceEntryMap.put("creditlocal", BigDecimal.ZERO);
        }
    }
}

