/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.query;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class QueryBuilderWrapper {
    private final QueryBuilder queryBuilder;
    private final ORM orm;
    private final String select;
    private QFilter[] tempFilters;
    private String tempOrderBys;
    private int tempStart;
    private int tempLimit;

    public QueryBuilderWrapper(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.orm = ORM.create();
        this.orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
        this.select = QueryBuilderWrapper.buildSelect(queryBuilder);
        this.tempFilters = queryBuilder.getFilters();
        this.tempOrderBys = queryBuilder.getOrderBys();
        this.tempStart = queryBuilder.getStart();
        this.tempLimit = queryBuilder.getLimit();
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public ORM getOrm() {
        return this.orm;
    }

    public String getSelect() {
        return this.select;
    }

    public QFilter[] getTempFilters() {
        return this.tempFilters;
    }

    public void setTempFilters(QFilter[] tempFilters) {
        this.tempFilters = tempFilters;
    }

    public String getTempOrderBys() {
        return this.tempOrderBys;
    }

    public void setTempOrderBys(String tempOrderBys) {
        this.tempOrderBys = tempOrderBys;
    }

    public int getTempStart() {
        return this.tempStart;
    }

    public void setTempStart(int tempStart) {
        this.tempStart = tempStart;
    }

    public int getTempLimit() {
        return this.tempLimit;
    }

    public void setTempLimit(int tempLimit) {
        this.tempLimit = tempLimit;
    }

    protected static String buildSelect(QueryBuilder queryBuilder) {
        String originalSelect = queryBuilder.getSelectFields() == null ? "" : queryBuilder.getSelectFields();
        LinkedHashSet<String> selectFields = new LinkedHashSet<String>(Arrays.asList(originalSelect.trim().split(",")));
        String orderBys = queryBuilder.getOrderBys();
        if (StringUtils.isNotEmpty((String)orderBys)) {
            String[] orderByArray;
            for (String orderBy : orderByArray = orderBys.trim().split(",")) {
                selectFields.add(orderBy.trim().split(" ")[0].toLowerCase());
            }
        }
        return selectFields.stream().filter(StringUtils::isNotEmpty).map(String::trim).collect(Collectors.joining(","));
    }
}

