/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.query;

import java.util.Collection;
import java.util.Optional;
import java.util.TreeMap;
import kd.bos.entity.list.IQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.formplugin.voucher.list.ctx.VoucherListContext;
import kd.fi.gl.formplugin.voucher.list.query.IQueryFactory;
import kd.fi.gl.formplugin.voucher.list.query.fac.DefaultIdQueryFactory;
import kd.fi.gl.formplugin.voucher.list.query.fac.DefaultSqlQueryFactory;
import kd.fi.gl.formplugin.voucher.list.query.fac.FirstPageQueryFactory;
import kd.fi.gl.formplugin.voucher.list.query.fac.MultiOrgQueryFactory;
import kd.fi.gl.formplugin.voucher.list.query.fac.VoucherRangesQueryFactory;

public class VoucherQueryFactory {
    private static final Log LOGGER = LogFactory.getLog(VoucherQueryFactory.class);
    private static final TreeMap<Integer, IQueryFactory> FACTORY_MAP = new TreeMap();

    public static void register(IQueryFactory factory) {
        if (factory == null) {
            return;
        }
        FACTORY_MAP.put(factory.priority(), factory);
    }

    protected static Collection<IQueryFactory> all() {
        return FACTORY_MAP.values();
    }

    protected static IQueryFactory tryGetFactory(VoucherListContext ctx) {
        Optional<IQueryFactory> first = VoucherQueryFactory.all().stream().filter(x -> x.enable(ctx)).findFirst();
        if (!first.isPresent()) {
            LOGGER.error("not find query factory by ctx: {}", (Object)ctx);
            throw new IllegalArgumentException("not find query factory");
        }
        return first.get();
    }

    public static IQuery getVoucherQuery(VoucherListContext ctx) {
        IQuery query = VoucherQueryFactory.tryGetFactory(ctx).build(ctx);
        query.setDataEntityTypes(ctx.getDataEntityTypes());
        return query;
    }

    static {
        VoucherQueryFactory.register(new VoucherRangesQueryFactory());
        VoucherQueryFactory.register(new MultiOrgQueryFactory());
        VoucherQueryFactory.register(new FirstPageQueryFactory());
        VoucherQueryFactory.register(new DefaultSqlQueryFactory());
        VoucherQueryFactory.register(new DefaultIdQueryFactory());
    }
}

