/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.range;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangeProperty;

public class VoucherRange {
    private final VoucherRangeProperty property;
    private final int startIndex;
    private int endIndex;

    @JsonCreator
    public VoucherRange(@JsonProperty(value="property") VoucherRangeProperty property, @JsonProperty(value="startIndex") int startIndex, @JsonProperty(value="endIndex") int endIndex) {
        if (startIndex < 0 || endIndex < 0) {
            throw new IllegalArgumentException("Index cannot less than 0. ");
        }
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("EndIndex cannot less than startIndex. ");
        }
        this.property = property;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public VoucherRangeProperty getProperty() {
        return this.property;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getCount() {
        return this.endIndex - this.startIndex + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoucherRange that = (VoucherRange)o;
        return this.startIndex == that.startIndex && this.endIndex == that.endIndex && Objects.equals(this.property, that.property);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.startIndex, this.endIndex);
    }
}

