/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.range;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.formplugin.voucher.list.cache.VoucherListCache;
import kd.fi.gl.formplugin.voucher.list.query.QueryBuilderWrapper;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRange;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangeQuery;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRanges;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangesParam;

public class VoucherRangesHelper {
    private static final Log LOG = ExtLogFactory.getLog(VoucherRangesHelper.class, (String)"VOUCHER_COUNT_RANGES_");

    private static boolean isEnableEnhanceQueryBuilder() {
        return GLBillParamEnum.VOUCHER_QUERY_COUNT_ENHANCE_ENABLE.getBooleanValue();
    }

    public static DataSet queryDataSet(List<VoucherRange> ranges, QueryBuilderWrapper wrapper) {
        PerformanceWatch watch = new PerformanceWatch(VoucherRangesHelper.class, "VoucherRangesHelper#queryDataSet", true);
        watch.start();
        if (ranges.isEmpty()) {
            return wrapper.getOrm().queryDataSet(VoucherRangesHelper.class.getName(), wrapper.getQueryBuilder().getEntityName(), wrapper.getSelect(), QFilterBuilder.getVoidFilter().toArray(), wrapper.getTempOrderBys(), wrapper.getTempStart(), wrapper.getTempLimit(), (Distinctable)WithEntityEntryDistinctable.get());
        }
        int total = wrapper.getTempLimit();
        int count = 0;
        ArrayList<DataSet> results = new ArrayList<DataSet>(ranges.size());
        QFilter[] filters = (QFilter[])Arrays.stream(wrapper.getTempFilters()).map(QFilter::copy).toArray(QFilter[]::new);
        for (VoucherRange range : ranges) {
            ShardingHintContext ignored = range.getProperty().buildShardingCtx().prepareShardingIndex();
            Throwable throwable = null;
            try {
                wrapper.setTempStart(Math.max(wrapper.getTempStart() - range.getStartIndex(), 0));
                wrapper.setTempLimit(Math.min(range.getCount() + 1 - wrapper.getTempStart(), total - count));
                results.add(wrapper.getOrm().queryDataSet(VoucherRangesHelper.class.getName(), wrapper.getQueryBuilder().getEntityName(), wrapper.getSelect(), range.getProperty().buildFilters(filters), wrapper.getTempOrderBys(), wrapper.getTempStart(), wrapper.getTempLimit(), (Distinctable)WithEntityEntryDistinctable.get()));
                count += wrapper.getTempLimit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        DataSet result = results.stream().reduce(DataSet::union).orElse(null);
        watch.stop();
        return result;
    }

    public static Optional<List<VoucherRange>> tryGetPageRanges(VoucherRangesParam param) {
        return VoucherRangesHelper.tryGetRanges(param).map(x -> x.getSubRanges(param.getStart(), param.getLimit()));
    }

    protected static Optional<VoucherRanges> tryGetRanges(VoucherRangesParam param) {
        VoucherRanges cacheValue;
        PerformanceWatch watch = new PerformanceWatch(VoucherRangesHelper.class, "VoucherRangesHelper#get", true);
        watch.start();
        if (!VoucherRangesHelper.isEnableEnhanceQueryBuilder()) {
            return Optional.empty();
        }
        Optional<VoucherRanges> result = Optional.empty();
        if (param.isUsingListCache() && (cacheValue = VoucherRangesHelper.getFromListCache()) != null) {
            LOG.info("cacheValue: {}", (Object)cacheValue);
            result = Optional.of(cacheValue);
        }
        if (!result.isPresent()) {
            result = VoucherRangeQuery.query(param);
            if (param.isUsingListCache()) {
                result.ifPresent(VoucherRangesHelper::putToListCache);
            }
        }
        watch.stop();
        return result;
    }

    private static VoucherRanges getFromListCache() {
        return VoucherListCache.getFromLocalCache("VOUCHER_COUNT_RANGES", VoucherRanges.class);
    }

    private static void putToListCache(VoucherRanges ranges) {
        VoucherListCache.putToLocalCache("VOUCHER_COUNT_RANGES", ranges);
    }
}

