/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LogUtil {
    private static final int TRUNCATED_LENGTH = 500;
    private static final int MULTI_MAX_SIZE = 50;

    public static String truncatedToLog(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return "";
        }
        ArrayList logs = new ArrayList(param.size());
        param.forEach((k, v) -> logs.add(k + "=" + LogUtil.truncatedToString(v)));
        return String.join((CharSequence)",", logs);
    }

    private static String truncatedToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Collection) {
            return LogUtil.collectionToString((Collection)value);
        }
        if (value.getClass().isArray()) {
            return LogUtil.arrayToString(value);
        }
        return LogUtil.truncate(String.valueOf(value));
    }

    private static String collectionToString(Collection<?> collection) {
        String fullString = collection.stream().limit(50L).map(x -> LogUtil.truncate(String.valueOf(x))).collect(Collectors.joining("|"));
        if (collection.size() > 50) {
            fullString = fullString + String.format("--ignore %s elements--", collection.size() - 50);
        }
        return fullString;
    }

    private static <T> String arrayToString(Object array) {
        Class<?> arrayClass = array.getClass();
        String fullString = arrayClass == byte[].class ? StringUtils.join((byte[])((byte[])array), (char)'|', (int)0, (int)50) : (arrayClass == short[].class ? StringUtils.join((short[])((short[])array), (char)'|', (int)0, (int)50) : (arrayClass == int[].class ? StringUtils.join((int[])((int[])array), (char)'|', (int)0, (int)50) : (arrayClass == long[].class ? StringUtils.join((long[])((long[])array), (char)'|', (int)0, (int)50) : (arrayClass == char[].class ? StringUtils.join((char[])((char[])array), (char)'|', (int)0, (int)50) : (arrayClass == float[].class ? StringUtils.join((float[])((float[])array), (char)'|', (int)0, (int)50) : (arrayClass == double[].class ? StringUtils.join((double[])((double[])array), (char)'|', (int)0, (int)50) : (arrayClass == boolean[].class ? StringUtils.join((Object[])new Serializable[]{(boolean[])array, Character.valueOf('|'), Integer.valueOf(0), Integer.valueOf(50)}) : Arrays.stream((Object[])array).limit(50L).map(x -> LogUtil.truncate(String.valueOf(x))).collect(Collectors.joining("|")))))))));
        int length = Array.getLength(array);
        if (length > 50) {
            fullString = fullString + String.format("--ignore %s elements--", length - 50);
        }
        return fullString;
    }

    private static String truncate(String fullString) {
        return fullString.length() <= 500 ? fullString : fullString.substring(0, 500) + String.format("--ignore %s chars--", fullString.length() - 500);
    }
}

