/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.backcalc;

import java.math.BigDecimal;
import java.util.Optional;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.IVoucherModel;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.mc.backcalc.AbstractMulLocalBackCalculator;
import kd.fi.gl.formplugin.voucher.mc.service.MCVoucherFormService;

public class AmountForCalcMulLocalChanged
extends AbstractMulLocalBackCalculator {
    @Override
    public String[] applicableChangedFields() {
        return new String[]{"oriamount", "debitlocal", "creditlocal"};
    }

    @Override
    public Optional<BackCalculateResult> backCalculateEmptyValue(BackCalculateChangedValue emptyValue, MulLocalConfig config) {
        IMCVoucherModel voucherModel = MCVoucherFormService.get(emptyValue.getVoucherEditView()).getMCVoucherModel();
        String propKey = emptyValue.getPropKey();
        if (voucherModel.isUsingLocalCalcMulLocal(config) && "oriamount".equalsIgnoreCase(propKey) || !voucherModel.isUsingLocalCalcMulLocal(config) && !"oriamount".equalsIgnoreCase(propKey)) {
            return Optional.empty();
        }
        return Optional.of(new BackCalculateResult(config.getLocalAmountField(this.getChangedEntryDC(propKey, (IVoucherModel)voucherModel, emptyValue.getRowIndex())), BigDecimal.ZERO));
    }

    @Override
    public Optional<BackCalculateResult> backCalculateNormalValue(BackCalculateChangedValue normalValue, MulLocalConfig config) {
        IMCVoucherModel voucherModel = MCVoucherFormService.get(normalValue.getVoucherEditView()).getMCVoucherModel();
        String propKey = normalValue.getPropKey();
        if (voucherModel.isUsingLocalCalcMulLocal(config) && "oriamount".equalsIgnoreCase(propKey) || !voucherModel.isUsingLocalCalcMulLocal(config) && !"oriamount".equalsIgnoreCase(propKey)) {
            return Optional.empty();
        }
        int rowIndex = normalValue.getRowIndex();
        BigDecimal exRate = voucherModel.getMCExRate(config, rowIndex);
        RateType exRateType = voucherModel.getMCExRateType(config, rowIndex);
        BigDecimal localAmount = exRateType.getRateCalculator().calLocAmount(exRate, normalValue.getValue(), voucherModel.getMCLocalCurAmtPrecision(config));
        return Optional.of(new BackCalculateResult(config.getLocalAmountField(this.getChangedEntryDC(propKey, (IVoucherModel)voucherModel, rowIndex)), localAmount));
    }

    private String getChangedEntryDC(String changedProp, IVoucherModel model, int rowIndex) {
        String entryDC = "debitlocal".equalsIgnoreCase(changedProp) ? "1" : ("creditlocal".equalsIgnoreCase(changedProp) ? "-1" : model.getEntryDC(rowIndex));
        return entryDC;
    }

    @Override
    public boolean applicable(String changedField, MulLocalConfig config) {
        return true;
    }
}

