/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.IListColumn;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;

public class VoucherListMulLocalService {
    public static List<FilterColumn> addSchemeFilterColumns(FilterContainerInitArgs args) {
        List schemeFilterColumns = args.getSchemeFilterColumns();
        FilterContainer filterContainer = (FilterContainer)args.getFilterContainerInitEvent().getSource();
        MulLocalConfig[] configs = MulLocalConfig.enabledConfigs();
        Set filterNames = schemeFilterColumns.stream().map(FilterColumn::getFilterFieldName).collect(Collectors.toSet());
        for (MulLocalConfig config : configs) {
            if (!filterNames.contains(config.getDebitField())) {
                schemeFilterColumns.add(VoucherListMulLocalService.buildSchemeFilterColumn(config.getDebitField(), filterContainer));
            }
            if (filterNames.contains(config.getCreditField())) continue;
            schemeFilterColumns.add(VoucherListMulLocalService.buildSchemeFilterColumn(config.getCreditField(), filterContainer));
        }
        return schemeFilterColumns;
    }

    public static List<IListColumn> modifyListColumns(BeforeCreateListColumnsArgs args) {
        HashSet<String> keys = new HashSet<String>(Arrays.asList(MulLocalConfig.getEnabledAmountFieldKeys()));
        args.getListColumns().stream().filter(x -> keys.contains(x.getListFieldKey())).forEach(x -> x.setColumnFilter(true));
        return args.getListColumns();
    }

    private static SchemeFilterColumn buildSchemeFilterColumn(String filterName, FilterContainer filterContainer) {
        SchemeFilterColumn filterColumn = new SchemeFilterColumn();
        filterColumn.setFieldName(filterName);
        filterColumn.setEntityType(filterContainer.getEntityType());
        filterColumn.setView(filterContainer.getView());
        filterColumn.setContext(filterContainer.getContext());
        filterColumn.setCaption(filterColumn.getFilterField().getCaption());
        return filterColumn;
    }
}

