/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.service.handler;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.formplugin.voucher.args.EntryExRateArg;
import kd.fi.gl.formplugin.voucher.args.EntryGridBindDataExRateArg;
import kd.fi.gl.formplugin.voucher.mc.service.handler.AbstractMCFormEventHandler;

public class ExRateHandler
extends AbstractMCFormEventHandler {
    public void setExRateType(EntryExRateArg arg) {
        MulLocalConfig[] configs;
        for (MulLocalConfig config : configs = this.getEnabledConfigs()) {
            this.setExRateType(arg, config);
        }
    }

    public void setExRateType(EntryExRateArg arg, MulLocalConfig config) {
        IMCVoucherModel voucherModel = this.getMCVoucherModel();
        this.getView().getVoucherEditModel().setValue(config.getExRateTypeField(), (Object)RateServiceHelper.getRateType((long)voucherModel.getMCOriCurId(config, arg.getRowIndex()), (long)voucherModel.getMCLocalCurId(config), (Date)arg.getExRateDate()), arg.getRowIndex());
    }

    public void setExRateType(EntryGridBindDataExRateArg arg) {
        MulLocalConfig[] configs;
        for (MulLocalConfig config : configs = this.getEnabledConfigs()) {
            IDataEntityProperty rateTypeProp = (IDataEntityProperty)arg.getEntry().getDataEntityType().getProperties().get((Object)config.getExRateTypeField());
            int ordinal = rateTypeProp.getOrdinal();
            rateTypeProp.setValue((Object)arg.getEntry(), (Object)this.getExRateType(arg, config));
            arg.getEntry().getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    public void setExRate(EntryExRateArg arg) {
        MulLocalConfig[] configs;
        for (MulLocalConfig config : configs = this.getEnabledConfigs()) {
            this.setExRate(arg, config);
        }
    }

    public void setExRate(EntryExRateArg arg, MulLocalConfig config) {
        this.getView().getVoucherEditModel().setValue(config.getExRateField(), (Object)this.getExRate(arg, config), arg.getRowIndex());
    }

    public RateType getExRateType(EntryGridBindDataExRateArg arg, MulLocalConfig config) {
        IMCVoucherModel model = this.getMCVoucherModel();
        if (model.isUsingLocalCalcMulLocal(config)) {
            return RateServiceHelper.getRateType((long)model.getLocalCurId(), (long)model.getMCLocalCurId(config), (Date)arg.getExRateDate());
        }
        return RateServiceHelper.getRateType((long)arg.getCurrencyId(), (long)model.getMCLocalCurId(config), (Date)arg.getExRateDate());
    }

    public BigDecimal getExRate(EntryExRateArg arg, MulLocalConfig config) {
        int rowIndex;
        IMCVoucherModel model = this.getMCVoucherModel();
        ExchangeRate exchangeRate = RateServiceHelper.getExchangeRate((Long)model.getMCOriCurId(config, rowIndex = arg.getRowIndex()), (Long)model.getMCLocalCurId(config), (Long)model.getMCExRateTableId(config), (Date)arg.getExRateDate());
        return exchangeRate == null ? BigDecimal.ZERO : exchangeRate.getValue();
    }

    public boolean isExistsForeignCurrencyEntry(DynamicObjectCollection entries) {
        MulLocalConfig[] configs = this.getEnabledConfigs();
        IMCVoucherModel model = this.getMCVoucherModel();
        for (MulLocalConfig config : configs) {
            boolean anyMatch;
            long mulLocalCurrencyId = model.getMCLocalCurId(config);
            if (!(model.isUsingLocalCalcMulLocal(config) ? model.getLocalCurId() != mulLocalCurrencyId : (anyMatch = entries.stream().anyMatch(row -> {
                long entryCurrencyId = row.getLong("currency.id");
                return entryCurrencyId != 0L && entryCurrencyId != mulLocalCurrencyId;
            })))) continue;
            return true;
        }
        return false;
    }
}

