/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.tmpl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.fi.gl.business.service.voucher.mc.IMulLocalEntryService;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.service.voucher.mc.arg.VoucherEntries;
import kd.fi.gl.business.vo.voucher.IVoucher;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.VoucherEntryStore;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucher;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherEntry;
import kd.fi.gl.formplugin.voucher.mc.service.MCVoucherFormService;
import kd.fi.gl.formplugin.voucher.template.IRowBuilder;
import kd.fi.gl.formplugin.voucher.template.TemplateVoucherContext;

public class MCTemplateRowBuilder
implements IRowBuilder {
    private final IMCVoucher voucher;
    private final MulLocalConfig[] configs;

    public MCTemplateRowBuilder(TemplateVoucherContext ctx) {
        this.voucher = MCVoucherFormService.get(ctx.getVoucherEditView()).getMCVoucherModel();
        this.configs = MulLocalConfig.enabledConfigs((long)this.voucher.getOrgId(), (long)this.voucher.getBookTypeId());
    }

    @Override
    public Map<String, Object> values(TemplateVoucherContext ctx, DynamicObject entry) {
        return null;
    }

    @Override
    public Table<Integer, String, Object> values(TemplateVoucherContext ctx, DynamicObjectCollection entries) {
        if (this.configs.length == 0) {
            return HashBasedTable.create();
        }
        ArrayList<VoucherEntryValueSetterAdapter> entryList = new ArrayList<VoucherEntryValueSetterAdapter>(entries.size());
        int row = 0;
        for (DynamicObject entry : entries) {
            VoucherEntryValueSetterAdapter voucherEntry = new VoucherEntryValueSetterAdapter(ctx.getValueSetter(), row);
            for (MulLocalConfig config : this.configs) {
                voucherEntry.setBigDecimal(config.getDebitField(), entry.getBigDecimal(config.getDebitField()));
                voucherEntry.setBigDecimal(config.getCreditField(), entry.getBigDecimal(config.getCreditField()));
            }
            entryList.add(voucherEntry);
            ++row;
        }
        List results = IMulLocalEntryService.get().updateByEntries(Collections.singletonList(new VoucherEntries((IVoucher)this.voucher, entryList)));
        TreeBasedTable table = TreeBasedTable.create();
        for (VoucherEntries result : results) {
            for (IMCVoucherEntry entry : result.getEntries()) {
                row = entry.getSeq() - 1;
                for (MulLocalConfig config : this.configs) {
                    table.put((Object)row, (Object)config.getExRateField(), (Object)entry.getMCExRate(config));
                    table.put((Object)row, (Object)config.getDebitField(), (Object)entry.getMCDebitAmount(config));
                    table.put((Object)row, (Object)config.getCreditField(), (Object)entry.getMCCreditAmount(config));
                }
            }
        }
        return table;
    }

    private static class VoucherEntryValueSetterAdapter
    extends VoucherEntryStore
    implements IVoucherEntry {
        private static final long serialVersionUID = 9185918334305566057L;

        private VoucherEntryValueSetterAdapter(TableValueSetter valueSetter, int row) {
            this.setSeq(row + 1);
            this.setCurrencyId((Long)valueSetter.get("currency", row));
            this.setEntryDC((String)valueSetter.get("entrydc", row));
            this.setDebitLocAmt((BigDecimal)valueSetter.get("debitlocal", row));
            this.setCreditLocAmt((BigDecimal)valueSetter.get("creditlocal", row));
            this.setDebitOriAmt((BigDecimal)valueSetter.get("debitori", row));
            this.setCreditOriAmt((BigDecimal)valueSetter.get("creditori", row));
        }
    }
}

