/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.template.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.template.IRowBuilder;
import kd.fi.gl.formplugin.voucher.template.TemplateVoucherContext;

public class AmountFieldBuilder
implements IRowBuilder {
    private final long exchangeRateTableId;
    private final DynamicObject localCurrency;
    private final long localCurrencyId;
    private final Date exchangeRateCtrlDate;

    public AmountFieldBuilder(TemplateVoucherContext ctx) {
        VoucherEditView voucherEditView = ctx.getVoucherEditView();
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        this.exchangeRateTableId = valueGetter.getExchangeRateTableID();
        this.localCurrency = valueGetter.getLocalCurrency();
        this.localCurrencyId = this.localCurrency.getLong("id");
        this.exchangeRateCtrlDate = valueGetter.getExRateCtrlDate();
    }

    @Override
    public Map<String, Object> values(TemplateVoucherContext ctx, DynamicObject entry) {
        String dc = entry.getString("entrydc");
        boolean debit = "1".equalsIgnoreCase(dc);
        BigDecimal localAmount = debit ? entry.getBigDecimal("debitlocal") : entry.getBigDecimal("creditlocal");
        BigDecimal originalAmount = entry.getBigDecimal("amountfor");
        BigDecimal exchangeRate = entry.getBigDecimal("localrate");
        DynamicObject currency = entry.getDynamicObject("currency");
        if (currency != null) {
            boolean existsOriginal;
            long currencyId = currency.getLong("id");
            if (currencyId == this.localCurrencyId) {
                exchangeRate = BigDecimal.ONE;
            }
            boolean existsLocal = localAmount != null && localAmount.signum() != 0;
            boolean bl = existsOriginal = originalAmount != null && originalAmount.signum() != 0;
            if (existsLocal && existsOriginal) {
                if (this.localCurrencyId != currencyId) {
                    RateType rateType = RateServiceHelper.getRateType((long)currencyId, (long)this.localCurrencyId, (Date)this.exchangeRateCtrlDate);
                    int ratePrecision = RateServiceHelper.getRatePrecision((Long)currencyId, (Long)this.localCurrencyId, (Long)this.exchangeRateTableId, (Date)this.exchangeRateCtrlDate);
                    exchangeRate = rateType.getRateCalculator().calRate(originalAmount, localAmount, ratePrecision);
                }
            } else if (this.localCurrencyId == currencyId) {
                if (existsLocal) {
                    originalAmount = localAmount;
                } else if (existsOriginal) {
                    localAmount = originalAmount;
                }
            } else {
                RateType rateType;
                ExchangeRate queryRate = RateServiceHelper.getExchangeRate((Long)currencyId, (Long)this.localCurrencyId, (Long)this.exchangeRateTableId, (Date)this.exchangeRateCtrlDate);
                exchangeRate = queryRate == null ? exchangeRate : (queryRate.getValue() == null ? exchangeRate : queryRate.getValue());
                RateType rateType2 = rateType = queryRate == null ? RateType.DIRECT_RATE : queryRate.getRateType();
                if (existsLocal) {
                    originalAmount = rateType.getRateCalculator().calOriAmount(exchangeRate, localAmount, currency.getInt("amtprecision"));
                } else if (existsOriginal) {
                    localAmount = rateType.getRateCalculator().calLocAmount(exchangeRate, originalAmount, this.localCurrency.getInt("amtprecision"));
                }
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("oriamount", originalAmount);
        result.put("debitori", debit ? originalAmount : BigDecimal.ZERO);
        result.put("creditori", debit ? BigDecimal.ZERO : originalAmount);
        result.put("localrate", exchangeRate);
        result.put("debitlocal", debit ? localAmount : BigDecimal.ZERO);
        result.put("creditlocal", debit ? BigDecimal.ZERO : localAmount);
        return result;
    }
}

