/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.valuechange.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.enums.AccountingType;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.valuechange.IRowValueChangedListener;
import kd.fi.gl.formplugin.voucher.valuechange.annotation.CaptureField;
import kd.fi.gl.formplugin.voucher.valuechange.events.CreateRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.DeleteRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.InitRowsEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.UpdateRowEventArgs;

public class VoucherBudgetHandler
implements IRowValueChangedListener {
    private static final String PREFIX_FINANCIAL = "financial";
    private static final String PREFIX_BUDGET = "budget";

    @Override
    public void onCreate(CreateRowEventArgs e) {
        if (!this.enableBudget(e.getVoucherEditView())) {
            return;
        }
        DynamicObject rowDyn = e.getRowDyn();
        DynamicObject accountDyn = rowDyn.getDynamicObject("account");
        if (accountDyn == null) {
            return;
        }
        if (this.isBudgetAccount(accountDyn)) {
            AmountAggregator.fromCache(e.getVoucherEditView(), "budgetdebitlocal").add(rowDyn.getBigDecimal("debitlocal")).updateCache().updateModel();
            AmountAggregator.fromCache(e.getVoucherEditView(), "budgetcreditlocal").add(rowDyn.getBigDecimal("creditlocal")).updateCache().updateModel();
        } else {
            AmountAggregator.fromCache(e.getVoucherEditView(), "financialdebitlocal").add(rowDyn.getBigDecimal("debitlocal")).updateCache().updateModel();
            AmountAggregator.fromCache(e.getVoucherEditView(), "financialcreditlocal").add(rowDyn.getBigDecimal("creditlocal")).updateCache().updateModel();
        }
    }

    @Override
    public void onInit(InitRowsEventArgs e) {
        VoucherEditView view = e.getVoucherEditView();
        e.getVoucherEditView().setBudgetVisiable();
        if (!e.getVoucherEditView().getValueGetter().isBudget() || CollectionUtils.isEmpty(e.getRowDataEntities())) {
            return;
        }
        AmountAggregator budgetDrAggregator = AmountAggregator.create(view, "budgetdebitlocal");
        AmountAggregator budgetCrAggregator = AmountAggregator.create(view, "budgetcreditlocal");
        AmountAggregator financialDrAggregator = AmountAggregator.create(view, "financialdebitlocal");
        AmountAggregator financialCrAggregator = AmountAggregator.create(view, "financialcreditlocal");
        for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
            DynamicObject rowDyn = rowDataEntity.getDataEntity();
            DynamicObject accountDyn = rowDyn.getDynamicObject("account");
            if (accountDyn == null) continue;
            if (this.isBudgetAccount(accountDyn)) {
                budgetDrAggregator.add(rowDyn.getBigDecimal("debitlocal"));
                budgetCrAggregator.add(rowDyn.getBigDecimal("creditlocal"));
                rowDyn.set("accountingtype", (Object)AccountingType.BUDGET.getValue());
                continue;
            }
            financialDrAggregator.add(rowDyn.getBigDecimal("debitlocal"));
            financialCrAggregator.add(rowDyn.getBigDecimal("creditlocal"));
            rowDyn.set("accountingtype", (Object)AccountingType.FINANCIAL.getValue());
        }
        Stream.of(budgetDrAggregator, budgetCrAggregator, financialDrAggregator, financialCrAggregator).forEach(aggregator -> ((AmountAggregator)aggregator).updateCache().updateModel());
    }

    @Override
    @CaptureField(fields={"debitlocal", "creditlocal", "account", "book"})
    public void onUpdate(UpdateRowEventArgs e) {
        if ("book".equals(e.getPropKey())) {
            this.erasureData(e.getVoucherEditView());
            return;
        }
        if (!this.enableBudget(e.getVoucherEditView())) {
            return;
        }
        if (e.getPropKey().equals("account")) {
            this.accountUpdate(e);
        } else {
            DynamicObject accountDyn = e.getVoucherEditView().getValueGetter().getAccount(e.getRowIndex());
            if (accountDyn == null) {
                return;
            }
            String prefix = this.isBudgetAccount(accountDyn) ? PREFIX_BUDGET : PREFIX_FINANCIAL;
            BigDecimal toAdd = ((BigDecimal)e.getNewValue()).subtract((BigDecimal)e.getOldValue());
            AmountAggregator.fromCache(e.getVoucherEditView(), prefix + e.getPropKey()).add(toAdd).updateCache().updateModel();
        }
    }

    @Override
    public void onDelete(DeleteRowEventArgs e) {
        if (!this.enableBudget(e.getVoucherEditView())) {
            return;
        }
        DynamicObject rowDyn = e.getRowDyn();
        DynamicObject accountDyn = rowDyn.getDynamicObject("account");
        if (accountDyn == null) {
            return;
        }
        if (this.isBudgetAccount(accountDyn)) {
            AmountAggregator.fromCache(e.getVoucherEditView(), "budgetdebitlocal").subtract(rowDyn.getBigDecimal("debitlocal")).updateCache().updateModel();
            AmountAggregator.fromCache(e.getVoucherEditView(), "budgetcreditlocal").subtract(rowDyn.getBigDecimal("creditlocal")).updateCache().updateModel();
        } else {
            AmountAggregator.fromCache(e.getVoucherEditView(), "financialdebitlocal").subtract(rowDyn.getBigDecimal("debitlocal")).updateCache().updateModel();
            AmountAggregator.fromCache(e.getVoucherEditView(), "financialcreditlocal").subtract(rowDyn.getBigDecimal("creditlocal")).updateCache().updateModel();
        }
    }

    private void accountUpdate(UpdateRowEventArgs e) {
        DynamicObject oldAccountDyn = (DynamicObject)e.getOldValue();
        DynamicObject newAccountDyn = (DynamicObject)e.getNewValue();
        VoucherEditView editView = e.getVoucherEditView();
        IDataModel model = editView.getVoucherEditModel();
        DynamicObject rowDyn = model.getEntryRowEntity("entries", e.getRowIndex());
        if (Objects.isNull(oldAccountDyn)) {
            this.onCreate(new CreateRowEventArgs(editView, rowDyn, e.getRowIndex()));
            this.setAccountingType(editView, e.getRowIndex());
            return;
        }
        if (Objects.isNull(newAccountDyn)) {
            model.setValue("accountingtype", (Object)"");
            DynamicObject cloneRow = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)rowDyn);
            cloneRow.set("account", (Object)oldAccountDyn);
            this.onDelete(new DeleteRowEventArgs(editView, cloneRow, e.getRowIndex()));
            return;
        }
        if (this.isBudgetAccount(oldAccountDyn) == this.isBudgetAccount(newAccountDyn)) {
            return;
        }
        this.setAccountingType(editView, e.getRowIndex());
        DynamicObject cloneRow = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)rowDyn);
        cloneRow.set("account", (Object)oldAccountDyn);
        this.onDelete(new DeleteRowEventArgs(editView, cloneRow, e.getRowIndex()));
        this.onCreate(new CreateRowEventArgs(editView, rowDyn, e.getRowIndex()));
    }

    private boolean enableBudget(VoucherEditView voucherEditView) {
        return voucherEditView.getValueGetter().isBudget();
    }

    private boolean isBudgetAccount(DynamicObject acctDyn) {
        return AccountType.isBudgetType((long)acctDyn.getLong("accounttype_id"));
    }

    private void setAccountingType(VoucherEditView view, int rowIndex) {
        DynamicObject account = view.getValueGetter().getAccount(rowIndex);
        if (account == null) {
            view.getVoucherEditModel().setValue("accountingtype", (Object)"", rowIndex);
            return;
        }
        view.getVoucherEditModel().setValue("accountingtype", (Object)(this.isBudgetAccount(account) ? AccountingType.BUDGET.getValue() : AccountingType.FINANCIAL.getValue()), rowIndex);
    }

    private void erasureData(VoucherEditView view) {
        this.onInit(new InitRowsEventArgs(view, Collections.emptyList()));
    }

    private static class AmountAggregator {
        private final VoucherEditView voucherEditView;
        private final String sumKey;
        private BigDecimal sum;

        private AmountAggregator(VoucherEditView voucherEditView, String sumKey) {
            this.voucherEditView = voucherEditView;
            this.sumKey = sumKey;
        }

        private static AmountAggregator fromCache(VoucherEditView voucherEditView, String sumKey) {
            AmountAggregator amountAggregator = new AmountAggregator(voucherEditView, sumKey);
            String amountStr = voucherEditView.getCacheManager().get(sumKey);
            amountAggregator.sum = amountStr == null ? BigDecimal.ZERO : new BigDecimal(amountStr);
            return amountAggregator;
        }

        private static AmountAggregator create(VoucherEditView voucherEditView, String sumKey) {
            AmountAggregator amountAggregator = new AmountAggregator(voucherEditView, sumKey);
            amountAggregator.sum = BigDecimal.ZERO;
            return amountAggregator;
        }

        private AmountAggregator add(BigDecimal toAdd) {
            this.sum = this.sum.add(toAdd);
            return this;
        }

        private AmountAggregator subtract(BigDecimal toSubtract) {
            this.sum = this.sum.subtract(toSubtract);
            return this;
        }

        private AmountAggregator updateCache() {
            this.voucherEditView.getCacheManager().set(this.sumKey, this.sum.toPlainString());
            return this;
        }

        private AmountAggregator updateModel() {
            this.voucherEditView.getVoucherEditModel().setValue(this.sumKey, (Object)this.sum);
            return this;
        }
    }
}

