/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucherref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListCache;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.model.schema.basedata.OrgSchema;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.synbook.VoucherRefType;
import kd.fi.gl.formplugin.voucherref.ManageBookVoucherList;
import kd.fi.gl.formplugin.voucherref.VoucherRefListDataProvider;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VoucherRefList
extends ManageBookVoucherList {
    private static Log LOG = ExtLogFactory.getLog(VoucherRefList.class, (String)"[VoucherRefList]", () -> true);
    private static final String CACHE_LINK_FIELD = "cache_link_field";
    private static final String SYNCBOOKVOUCHER = "syncbookvoucher";
    private static final String SYNCNUMVOUCHER = "syncnumvoucher";
    private static final String SYNCNUMVOUCHERLOG = "syncnumvoucherlog";
    private ListCache listCache = null;

    private void cacheOrgId(Long orgId) {
        this.getPageCache().put("CacheKey_OrgId", String.valueOf(orgId));
    }

    private long getCacheOrgId() {
        String cacheOrgId = this.getPageCache().get("CacheKey_OrgId");
        return StringUtils.isBlank((CharSequence)cacheOrgId) ? 0L : Long.parseLong(cacheOrgId);
    }

    private void cacheBookTypeId(Long bookTypeId) {
        this.getPageCache().put("CacheKey_ManageBookTypeId", String.valueOf(bookTypeId));
        this.getPageCache().put("bookstype", String.valueOf(bookTypeId));
    }

    private long getCacheBookTypeId() {
        String cacheManageBookTypeId = this.getPageCache().get("CacheKey_ManageBookTypeId");
        return StringUtils.isBlank((CharSequence)cacheManageBookTypeId) ? 0L : Long.parseLong(cacheManageBookTypeId);
    }

    private void cacheTargetOrgId(Long orgId) {
        this.getPageCache().put("CacheKey_TargetOrgId", String.valueOf(orgId));
    }

    private long getCacheTargetOrgId() {
        String cacheTargetOrgId = this.getPageCache().get("CacheKey_TargetOrgId");
        return StringUtils.isBlank((CharSequence)cacheTargetOrgId) ? 0L : Long.parseLong(cacheTargetOrgId);
    }

    private void cacheTargetBookTypeId(Long bookTypeId) {
        this.getPageCache().put("CacheKey_TargetBookTypeId", String.valueOf(bookTypeId));
    }

    private long getCacheTargetBookTypeId() {
        String cacheTargetBookTypeId = this.getPageCache().get("CacheKey_TargetBookTypeId");
        return StringUtils.isBlank((CharSequence)cacheTargetBookTypeId) ? 0L : Long.parseLong(cacheTargetBookTypeId);
    }

    private void cacheFilterContainerSourceBookTypeId(String bookTypeId) {
        this.getPageCache().put("CacheKey_cacheFilterContainerSourceBookTypeId", bookTypeId);
    }

    private String getCacheFilterContainerSourceBookTypeId() {
        return this.getPageCache().get("CacheKey_cacheFilterContainerSourceBookTypeId");
    }

    private void cacheFilterContainerTargetOrgId(String orgId) {
        this.getPageCache().put("CacheKey_cacheFilterContainerTargetOrgId", orgId);
    }

    private String getCacheFilterContainerTargetOrgId() {
        return this.getPageCache().get("CacheKey_cacheFilterContainerTargetOrgId");
    }

    private void cacheFilterContainerTargetBookTypeId(String bookTypeId) {
        this.getPageCache().put("CacheKey_cacheFilterContainerTargetBookTypeId", bookTypeId);
    }

    private String getCacheFilterContainerTargetBookTypeId() {
        return this.getPageCache().get("CacheKey_cacheFilterContainerTargetBookTypeId");
    }

    private void cacheFilterContainerAllOrgIds(Set<Long> orgIds) {
        this.getPageCache().put("CacheKey_cacheFilterContainerAllOrgIds", SerializationUtils.toJsonString(orgIds));
    }

    private Set<Long> getCacheFilterContainerAllOrgIds() {
        Set orgIds = null;
        String allOrgIds = this.getPageCache().get("CacheKey_cacheFilterContainerAllOrgIds");
        if (StringUtils.isEmpty((CharSequence)allOrgIds)) {
            orgIds = this.getAllOrgIds();
            this.cacheFilterContainerAllOrgIds(orgIds);
        } else {
            orgIds = (Set)SerializationUtils.fromJsonString((String)allOrgIds, Set.class);
        }
        return orgIds;
    }

    private void cacheFilterContainerAllTargetOrgIds(Set<Long> orgIds) {
        this.getPageCache().put("CacheKey_cacheFilterContainerAllTargetOrgIds", SerializationUtils.toJsonString(orgIds));
    }

    private Set<Long> getCacheFilterContainerAllTargetOrgIds() {
        Set orgIds = null;
        String allOrgIds = this.getPageCache().get("CacheKey_cacheFilterContainerAllTargetOrgIds");
        if (StringUtils.isEmpty((CharSequence)allOrgIds)) {
            orgIds = this.getAllTargetOrgIds();
            this.cacheFilterContainerAllTargetOrgIds(orgIds);
        } else {
            orgIds = (Set)SerializationUtils.fromJsonString((String)allOrgIds, Set.class);
        }
        return orgIds;
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String hyperLinkFieldKey = this.getHyperLinkFieldKey();
        if ("refbillno".equals(hyperLinkFieldKey) || "billno".equals(hyperLinkFieldKey)) {
            e.getParameter().setFormId("gl_voucher");
            if ("refbillno".equals(hyperLinkFieldKey)) {
                e.setCancel(Boolean.TRUE.booleanValue());
                long refVoucherId = this.getRefVoucherId(e.getParameter().getPkId());
                if (refVoucherId != 0L) {
                    VoucherUtil.hyperVoucher(this.getOrgId(), refVoucherId, this.getView());
                }
            }
        }
    }

    private long getRefVoucherId(Object voucherId) {
        Long manageBookId = this.getManageBookId();
        Long targetBookId = this.getTargetBookId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("srcbook", "=", (Object)manageBookId);
        qfBuilder.add("srcvoucherid", "=", voucherId);
        qfBuilder.add("destbook", "=", (Object)targetBookId);
        DynamicObject relation = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_voucher_relation", (String)"destvoucherid", (QFilter[])qfBuilder.toArray());
        return relation == null ? 0L : relation.getLong("destvoucherid");
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.putHyperLinkFieldKey(args.getFieldName());
    }

    private void putHyperLinkFieldKey(String key) {
        this.getPageCache().put(CACHE_LINK_FIELD, key);
    }

    private String getHyperLinkFieldKey() {
        return this.getPageCache().get(CACHE_LINK_FIELD);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "export": {
                Set<Long> orgids = this.getCacheFilterContainerAllOrgIds();
                if (!Objects.isNull(orgids) && !orgids.isEmpty()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"VoucherRefList_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        DebugTrace.action(() -> LOG.info("setFilter filters before handle = {}", (Object)QFilterBuilder.dumpQFilters((Collection)qFilters)));
        this.extractAndCacheOrgAndBookType();
        VoucherRefListDataProvider provider = (VoucherRefListDataProvider)((BillList)e.getSource()).getListModel().getProvider();
        provider.setSourceBookTypeId(this.getManageBookTypeId());
        provider.setTargetOrgId(this.getTargetOrgId());
        provider.setTargetBookTypeId(this.getTargetBookTypeId());
        QFilterBuilder.SimpleFilterNameMatcher targetPropertyMatcher = new QFilterBuilder.SimpleFilterNameMatcher(new String[]{"reforg.id", "reforg.name", "refbooktype.id", "refbooktype.name"});
        QFilterBuilder result = QFilterBuilder.modifyFilters((Collection)qFilters, (boolean)true, qf -> {
            List nests = qf.getNests(true);
            if (nests.isEmpty()) {
                return null;
            }
            QFilter dummy = QFilter.of((String)"1=1", (Object[])new Object[0]);
            for (QFilter.QFilterNest nest : nests) {
                if (targetPropertyMatcher.test(nest.getFilter())) continue;
                dummy = nest.isAnd() ? dummy.and(nest.getFilter()) : dummy.or(nest.getFilter());
            }
            return dummy;
        }, (QFilterBuilder.IQFilterMatcher)targetPropertyMatcher);
        result = QFilterBuilder.modifyFilters((Collection)result.getFilters(), (boolean)true, qf -> {
            Long destBookId = Optional.ofNullable(AccSysUtil.getBookFromAccSys((long)this.getCacheTargetOrgId(), (long)this.getCacheTargetBookTypeId())).map(AccountBookInfo::getId).orElse(0L);
            QFilter transFilter = (QFilter)VoucherRefType.fromValue((String)qf.getValue().toString()).getJoinQFilterFunc().apply(destBookId);
            for (QFilter.QFilterNest nest : qf.getNests(false)) {
                transFilter = nest.isAnd() ? transFilter.and(nest.getFilter()) : transFilter.or(nest.getFilter());
            }
            return transFilter;
        }, (QFilterBuilder.IQFilterMatcher)new QFilterBuilder.SimpleFilterNameMatcher(new String[]{"reftype"}));
        qFilters.clear();
        qFilters.addAll(result.getFilters());
        DebugTrace.action(() -> LOG.info("setFilter filters after handle = {}", (Object)QFilterBuilder.dumpQFilters((Collection)qFilters)));
    }

    private void extractAndCacheOrgAndBookType() {
        this.cacheOrgId(this.extractFilterValue("org"));
        this.cacheBookTypeId(this.extractFilterValue("booktype"));
        this.cacheTargetOrgId(this.extractFilterValue("reforg"));
        this.cacheTargetBookTypeId(this.extractFilterValue("refbooktype"));
    }

    private Long extractFilterValue(String field) {
        List values;
        List list = values = field.contains("org") ? CommonAssistUtil.getOrgCommonFilterColumnValues((IFormView)this.getView(), (String)field) : CommonAssistUtil.getBookTypeCommonFilterColumnValues((IFormView)this.getView(), (String)field);
        if (values.isEmpty()) {
            return 0L;
        }
        if (values.size() > 1) {
            String localName = EntityMetadataCache.getDataEntityType((String)"gl_voucher_ref").getProperty(field).getDisplayName().getLocaleValue();
            throw new KDBizException(ResManager.loadKDString((String)"\u534f\u540c\u68c0\u67e5\u5217\u8868\u4e0d\u652f\u6301\u591a\u9009%s\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u8bbe\u7f6e\u3002", (String)"VoucherRefList_18", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{localName}));
        }
        return (Long)values.get(0);
    }

    private long getOrgId() {
        Long customFilterId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        if (customFilterId == null || customFilterId == 0L) {
            return this.getCacheOrgId();
        }
        return customFilterId;
    }

    private long getTargetBookTypeId() {
        long cacheBookTypeId = this.getCacheTargetBookTypeId();
        if (cacheBookTypeId != 0L) {
            return cacheBookTypeId;
        }
        Long customFilterId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"refbooktype.id");
        return customFilterId == null ? 0L : customFilterId;
    }

    private long getTargetOrgId() {
        long cacheTargetOrgId = this.getCacheTargetOrgId();
        if (cacheTargetOrgId != 0L) {
            return cacheTargetOrgId;
        }
        Long customFilterId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"reforg.id");
        return customFilterId == null ? 0L : customFilterId;
    }

    private long getManageBookTypeId() {
        long cacheBookTypeId = this.getCacheBookTypeId();
        if (cacheBookTypeId != 0L) {
            return cacheBookTypeId;
        }
        Long customFilterId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
        return customFilterId == null ? 0L : customFilterId;
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        IListModel sourceModel = ((BillList)args.getSource()).getListModel();
        IListDataProvider provider = Optional.ofNullable(sourceModel.getProvider()).orElseGet(() -> new VoucherRefListDataProvider(this.getView()));
        args.setListDataProvider(provider);
    }

    private Long getManageBookId() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)this.getOrgId());
        qfBuilder.add("bookstype", "=", (Object)this.getManageBookTypeId());
        DynamicObject manageBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"id", (QFilter[])qfBuilder.toArray());
        return manageBook == null ? 0L : manageBook.getLong("id");
    }

    private Long getTargetBookId() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)this.getTargetOrgId());
        qfBuilder.add("bookstype", "=", (Object)this.getTargetBookTypeId());
        DynamicObject manageBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"id", (QFilter[])qfBuilder.toArray());
        return manageBook == null ? 0L : manageBook.getLong("id");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SYNCBOOKVOUCHER.equals(operateKey)) {
            StringBuilder msg = new StringBuilder();
            if (this.getTargetOrgId() == 0L) {
                msg.append(ResManager.loadKDString((String)"\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7", (String)"VoucherRefList_14", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            if (this.getTargetBookTypeId() == 0L) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)msg.toString())) {
                    msg.append("\u3001");
                }
                msg.append(ResManager.loadKDString((String)"\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b", (String)"VoucherRefList_15", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)msg.toString())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\uff0c\u518d\u8fdb\u884c\u51ed\u8bc1\u534f\u540c\u3002", (String)"VoucherRefList_16", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{msg.toString()}), new Object[0]));
            }
            if (this.getTargetBookId() == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u76ee\u6807\u7ec4\u7ec7\u4e0e\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\u672a\u627e\u5230\u76f8\u5e94\u7684\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u8bbe\u7f6e\u3002", (String)"VoucherRefList_19", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{msg.toString()}), new Object[0]));
            }
            if (this.getTargetOrgId() == this.getOrgId() && this.getTargetBookTypeId() == this.getManageBookTypeId()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u6838\u7b97\u7ec4\u7ec7\u3001\u6e90\u8d26\u7c3f\u7c7b\u578b\u4e0e\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7\u3001\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"VoucherRefList_6", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            operate.setEntityId("gl_voucher");
            OperateOption option = ((FormOperate)args.getSource()).getOption();
            option.setVariableValue("Option_DestOrgId", String.valueOf(this.getTargetOrgId()));
            option.setVariableValue("Option_DestBookTypeId", String.valueOf(this.getTargetBookTypeId()));
            option.setVariableValue("Option_SourceOrgId", String.valueOf(this.getOrgId()));
            option.setVariableValue("Option_SourceBookTypeId", String.valueOf(this.getManageBookTypeId()));
            operate.setOption(option);
        } else if (SYNCNUMVOUCHER.equals(operateKey)) {
            Long orgId = this.getOrgId();
            CodeRuleInfo codeRuleInfo = VoucherNumberUtils.getCodeRuleInfo((Long)orgId, (String)"B");
            if (codeRuleInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u9002\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"VoucherRefList_5", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            if (!this.checkBookTypeCodeRule(codeRuleInfo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u51ed\u8bc1\u7684\u7f16\u7801\u89c4\u5219\u4e2d\u5fc5\u987b\u8bbe\u7f6e\u8d26\u7c3f\u7c7b\u578b\u4f5c\u4e3a\u6d41\u6c34\u53f7\u4f9d\u636e\uff0c\u624d\u80fd\u6d41\u6c34\u53f7\u540c\u6b65\u3002", (String)"VoucherRefList_3", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            if (!this.checkBillNoCodeRule(codeRuleInfo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\u51ed\u8bc1\u7684\u7f16\u7801\u89c4\u5219\u5fc5\u987b\u5728\u6700\u540e\u4e00\u4f4d\u8bbe\u7f6e\u6d41\u6c34\u53f7\uff08\u6216\u968f\u673a\u7801\uff09\uff0c\u624d\u80fd\u8fdb\u884c\u6d41\u6c34\u53f7\u540c\u6b65\u3002", (String)"VoucherRefList_4", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            OperateOption option = ((FormOperate)args.getSource()).getOption();
            option.setVariableValue("Option_DestBookId", String.valueOf(this.getTargetBookId()));
            operate.setOption(option);
        } else if (SYNCNUMVOUCHERLOG.equals(operateKey)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setBillFormId("gl_syncnumvoucher_log");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(true);
            showParameter.getCustomParams().put("org", this.getOrgId() + "");
            showParameter.getCustomParams().put("booktype", this.getManageBookTypeId() + "");
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            showParameter.getCustomParams().put("mainvoucherid", Arrays.asList(primaryKeyValues));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult result = args.getOperationResult();
        IListView listView = (IListView)this.getView();
        if (SYNCNUMVOUCHER.equals(operateKey) && result.isSuccess()) {
            listView.refresh();
        }
        if (SYNCBOOKVOUCHER.equals(operateKey)) {
            listView.refreshWithSelected();
        }
    }

    private boolean checkBookTypeCodeRule(CodeRuleInfo codeRuleInfo) {
        for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
            String valueAtribute = codeRuleEntry.getValueAtribute();
            if (!valueAtribute.contains("booktype")) continue;
            return true;
        }
        return false;
    }

    private boolean checkBillNoCodeRule(CodeRuleInfo codeRuleInfo) {
        Iterator codeRule = codeRuleInfo.getRuleEntry().iterator();
        while (codeRule.hasNext()) {
            CodeRuleEntryInfo codeRuleEntry = (CodeRuleEntryInfo)codeRule.next();
            CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums((String)codeRuleEntry.getAttributeType());
            if (!CodeRuleEntryTypeEnum.TYPE_SEQ.equals((Object)enums) && !CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER.equals((Object)enums) || codeRule.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("org.name")) {
            Set<Long> orgids = this.getCacheFilterContainerAllOrgIds();
            if (Objects.isNull(orgids) || orgids.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u51ed\u8bc1\u6298\u7b97\u89c4\u5219\u6216\u68c0\u67e5\u662f\u5426\u6709\u6e90\u6838\u7b97\u7ec4\u7ec7\u201c\u51ed\u8bc1\u534f\u540c\u68c0\u67e5\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"VoucherRefList_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            args.getQFilters().add(new OrgSchema().id.toFilter("in", orgids));
        } else if (fieldName.equals("reforg.name")) {
            Set<Long> orgids = this.getCacheFilterContainerAllTargetOrgIds();
            args.getQFilters().add(new OrgSchema().id.toFilter("in", orgids));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        ArrayList<Object> val;
        String fieldName;
        boolean isClear;
        List customfilter = (List)args.getFilterValues().get("customfilter");
        if (customfilter == null || customfilter.size() == 0) {
            List schemefilter = (List)args.getFilterValues().get("schemefilter");
            boolean containsOrgName = schemefilter.stream().anyMatch(x -> "org.name".equals(((List)x.get("FieldName")).get(0)));
            boolean containsRefOrgName = schemefilter.stream().anyMatch(x -> "reforg.name".equals(((List)x.get("FieldName")).get(0)));
            boolean containsBookTypeName = schemefilter.stream().anyMatch(x -> "booktype.name".equals(((List)x.get("FieldName")).get(0)));
            boolean containsRefBookTypeName = schemefilter.stream().anyMatch(x -> "refbooktype.name".equals(((List)x.get("FieldName")).get(0)));
            if (!(containsOrgName && containsRefOrgName && containsBookTypeName && containsRefBookTypeName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u534f\u540c\u68c0\u67e5\u5df2\u7ecf\u5347\u7ea7\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u65b9\u6848\u589e\u52a0\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7\u3001\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\uff0c\u6216\u65b0\u5efa\u67e5\u8be2\u65b9\u6848\u3002", (String)"VoucherRefList_7", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            return;
        }
        Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        Long booktypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
        for (Map map : customfilter) {
            String fieldName2 = (String)((List)map.get("FieldName")).get(0);
            ArrayList<String> val2 = (ArrayList<String>)map.get("Value");
            if (!"booktype.id".equals(fieldName2)) continue;
            if (null == orgId) {
                return;
            }
            List<ComboItem> comboItems = this.getSourceBookTypeComboItems(orgId);
            isClear = true;
            if (Objects.isNull(val2) || val2.isEmpty() || val2.get(0).equals("")) {
                val2 = new ArrayList<String>(1);
            } else {
                for (ComboItem comboItem : comboItems) {
                    if (!comboItem.getValue().equals(val2.get(0).toString())) continue;
                    isClear = false;
                    break;
                }
            }
            if (!isClear) break;
            val2.clear();
            if (comboItems.size() > 0) {
                String bookTypeId = this.getCacheFilterContainerSourceBookTypeId();
                val2.add(bookTypeId);
                booktypeId = Long.valueOf(bookTypeId);
                break;
            }
            val2.add("");
            break;
        }
        Long refOrgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"reforg.id");
        for (Map map : customfilter) {
            fieldName = (String)((List)map.get("FieldName")).get(0);
            val = (ArrayList<Object>)map.get("Value");
            if (!"reforg.id".equals(fieldName)) continue;
            isClear = true;
            Set<Long> targetOrgIds = this.getTargetOrgIds(orgId, booktypeId);
            if (Objects.isNull(val) || val.isEmpty() || val.get(0).equals("")) {
                val = new ArrayList<Object>(1);
            } else {
                for (Long l : targetOrgIds) {
                    if (!String.valueOf(l).equals(val.get(0).toString())) continue;
                    isClear = false;
                    break;
                }
            }
            if (!isClear) break;
            val.clear();
            if (targetOrgIds.size() > 0) {
                String string = this.getCacheFilterContainerTargetOrgId();
                val.add(string);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    refOrgId = 0L;
                    break;
                }
                refOrgId = Long.parseLong(string);
                break;
            }
            val.add("");
            break;
        }
        for (Map map : customfilter) {
            fieldName = (String)((List)map.get("FieldName")).get(0);
            val = (List)map.get("Value");
            if (!"refbooktype.id".equals(fieldName)) continue;
            if (null == refOrgId || refOrgId.compareTo(0L) == 0) {
                return;
            }
            List<ComboItem> comboItems = this.getTargetBookTypeComboItems(orgId, booktypeId, refOrgId);
            boolean isClear2 = true;
            if (Objects.isNull(val) || val.isEmpty() || val.get(0) == null || val.get(0).equals("")) {
                val = new ArrayList(1);
            } else {
                for (ComboItem comboItem : comboItems) {
                    if (!comboItem.getValue().equals(val.get(0).toString())) continue;
                    isClear2 = false;
                    break;
                }
            }
            if (!isClear2) break;
            val.clear();
            if (comboItems.size() > 0) {
                void var12_28;
                String string = this.getCacheFilterContainerTargetBookTypeId();
                if (StringUtils.isEmpty((CharSequence)string)) {
                    String string2 = "";
                }
                val.add(var12_28);
                break;
            }
            val.add("");
            break;
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        List<Object> comboItems;
        String fieldName;
        CommonFilterColumn commonFilterColumn;
        Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        Long booktypeId = 0L;
        Long refOrgId = 0L;
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        boolean isFirst = false;
        if (this.getPageCache().get("isFirst") == null) {
            isFirst = true;
            this.getPageCache().put("isFirst", "false");
        }
        boolean isBeforeFilterColumnNull = false;
        if (orgId == null || orgId.compareTo(0L) == 0) {
            for (FilterColumn filterColumn : listFilterColumns) {
                commonFilterColumn = (CommonFilterColumn)filterColumn;
                fieldName = filterColumn.getFieldName();
                if (!"org.name".equals(fieldName)) continue;
                List originalComboItems = commonFilterColumn.getComboItems();
                if (originalComboItems == null || originalComboItems.isEmpty() || StringUtils.isEmpty((CharSequence)((ComboItem)originalComboItems.get(0)).getValue())) {
                    isBeforeFilterColumnNull = true;
                    break;
                }
                orgId = Long.parseLong(((ComboItem)originalComboItems.get(0)).getValue());
                if (isFirst) {
                    long defaultOrgId = AccSysUtil.getDefaultOrgId((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                    if (AccSysUtil.getAllOrgIdByComboItems((Collection)originalComboItems).contains(defaultOrgId)) {
                        orgId = defaultOrgId;
                    }
                }
                commonFilterColumn.setDefaultValue(String.valueOf(orgId));
                break;
            }
        }
        for (FilterColumn filterColumn : listFilterColumns) {
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            fieldName = commonFilterColumn.getFieldName();
            if (!"booktype.name".equals(fieldName)) continue;
            if (isBeforeFilterColumnNull) {
                comboItems = new ArrayList(1);
                ComboItem item = new ComboItem();
                item.setValue("");
                comboItems.add(item);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            if (!(orgId != null && orgId.compareTo(0L) != 0 || isFirst)) {
                comboItems = AccSysUtil.getBookTypeCombo(null);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            comboItems = this.getSourceBookTypeComboItems(orgId);
            if (comboItems.isEmpty()) {
                isBeforeFilterColumnNull = true;
                ComboItem item = new ComboItem();
                item.setValue("");
                comboItems.add(item);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            commonFilterColumn.setComboItems(comboItems);
            booktypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
            boolean isExistDef = false;
            if (booktypeId == null || booktypeId.compareTo(0L) == 0) {
                isExistDef = false;
            } else {
                String booktypeIdStr = String.valueOf(booktypeId);
                isExistDef = comboItems.stream().anyMatch(comboItem -> comboItem.getValue().equals(booktypeIdStr));
            }
            if (!isExistDef) {
                String defBookType = ((ComboItem)comboItems.get(0)).getValue();
                commonFilterColumn.setDefaultValue(defBookType);
                booktypeId = Long.parseLong(defBookType);
                this.cacheFilterContainerSourceBookTypeId(defBookType);
                this.setToOrgControlFilter("booktype.id", defBookType);
                break;
            }
            commonFilterColumn.setDefaultValue(String.valueOf(booktypeId));
            this.cacheFilterContainerSourceBookTypeId(String.valueOf(booktypeId));
            break;
        }
        for (FilterColumn filterColumn : listFilterColumns) {
            ComboItem item;
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            fieldName = filterColumn.getFieldName();
            if (!"reforg.name".equals(fieldName)) continue;
            if (isBeforeFilterColumnNull) {
                comboItems = new ArrayList(1);
                ComboItem item2 = new ComboItem();
                item2.setValue("");
                comboItems.add(item2);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            if (!(orgId != null && orgId.compareTo(0L) != 0 || isFirst)) {
                return;
            }
            comboItems = new ArrayList(10);
            Set<Long> targetOrgIds = this.getTargetOrgIds(orgId, booktypeId);
            if (targetOrgIds.isEmpty()) {
                isBeforeFilterColumnNull = true;
                item = new ComboItem();
                item.setValue("");
                comboItems.add(item);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", targetOrgIds).toArray(), null);){
                for (Row row : bookDataSet) {
                    ComboItem item3 = new ComboItem();
                    item3.setValue(row.getString("id"));
                    item3.setCaption(new LocaleString(row.getString("name")));
                    comboItems.add(item3);
                }
            }
            commonFilterColumn.setComboItems(comboItems);
            if (comboItems.isEmpty()) {
                isBeforeFilterColumnNull = true;
                item = new ComboItem();
                item.setValue("");
                comboItems.add(item);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            refOrgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"reforg.id");
            if (refOrgId == null || refOrgId.compareTo(0L) == 0 || !targetOrgIds.contains(refOrgId)) {
                commonFilterColumn.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
                refOrgId = Long.valueOf(((ComboItem)comboItems.get(0)).getValue());
                this.cacheFilterContainerTargetOrgId(((ComboItem)comboItems.get(0)).getValue());
                this.setToOrgControlFilter("reforg.id", ((ComboItem)comboItems.get(0)).getValue());
                break;
            }
            commonFilterColumn.setDefaultValue(String.valueOf(refOrgId));
            this.cacheFilterContainerTargetOrgId(String.valueOf(refOrgId));
            break;
        }
        for (FilterColumn filterColumn : listFilterColumns) {
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            fieldName = commonFilterColumn.getFieldName();
            if (!"refbooktype.name".equals(fieldName)) continue;
            if (isBeforeFilterColumnNull || refOrgId == null || refOrgId.compareTo(0L) == 0) {
                comboItems = new ArrayList(1);
                ComboItem item = new ComboItem();
                item.setValue("");
                comboItems.add(item);
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
            if (!(orgId != null && orgId.compareTo(0L) != 0 || isFirst)) {
                return;
            }
            comboItems = this.getTargetBookTypeComboItems(orgId, booktypeId, refOrgId);
            if (comboItems.isEmpty()) {
                isBeforeFilterColumnNull = true;
                ComboItem item = new ComboItem();
                item.setValue("");
                comboItems.add(item);
                commonFilterColumn.setComboItems(comboItems);
                commonFilterColumn.setDefaultValue("");
                break;
            }
            commonFilterColumn.setComboItems(comboItems);
            boolean isExistDef = false;
            Long regBooktypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"refbooktype.id");
            if (regBooktypeId == null || regBooktypeId.compareTo(0L) == 0) {
                isExistDef = false;
            } else {
                String regBooktypeIdStr = String.valueOf(regBooktypeId);
                isExistDef = comboItems.stream().anyMatch(comboItem -> comboItem.getValue().equals(regBooktypeIdStr));
            }
            if (!isExistDef) {
                String defBookType = ((ComboItem)comboItems.get(0)).getValue();
                commonFilterColumn.setDefaultValue(defBookType);
                this.cacheFilterContainerTargetBookTypeId(defBookType);
                this.setToOrgControlFilter("refbooktype.id", defBookType);
                break;
            }
            commonFilterColumn.setDefaultValue(String.valueOf(regBooktypeId));
            this.cacheFilterContainerTargetBookTypeId(String.valueOf(regBooktypeId));
            break;
        }
    }

    void setToOrgControlFilter(String fieldName, String toOrgId) {
        FilterContainerFilterValues cachedFilterValues = this.getListCache().getCachedFilterValues();
        FilterKeyValueCollections otherFilterValues = cachedFilterValues.getOtherFilterValues();
        if (otherFilterValues == null) {
            return;
        }
        for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
            List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
            if (!((FilterKeyValue)filterKeyValues.get(0)).getValue().get(0).equals(fieldName)) continue;
            List values = ((FilterKeyValue)filterKeyValues.get(1)).getValue();
            values.clear();
            values.add(toOrgId);
        }
        this.getListCache().setCachedFilterValues(cachedFilterValues);
        ControlFilters c = ((ListView)this.getView()).getControlFilters();
        List btValues = c.getFilter(fieldName);
        btValues.clear();
        btValues.add(toOrgId);
    }

    protected ListCache getListCache() {
        if (this.listCache == null) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            this.listCache = new ListCache(pageCache, "filtercontainerap");
        }
        return this.listCache;
    }

    private List<ComboItem> getSourceBookTypeComboItems(Long sourceOrgId) {
        DynamicObject sourceaccbooktype;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)sourceOrgId));
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add("iscrossorgsyn", "=", (Object)Boolean.TRUE);
        qfBuilder.add(new QFilter("entryentity.sourceorg", "=", (Object)sourceOrgId));
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"gl_voucher_rulecondition", (String)"sourceaccbooktype", (QFilter[])qfBuilder.toArray());
        HashMap<Long, String> comboItemsMap = new HashMap<Long, String>(16);
        for (DynamicObject dyn : dyns) {
            sourceaccbooktype = dyn.getDynamicObject("sourceaccbooktype");
            comboItemsMap.put(sourceaccbooktype.getLong("id"), sourceaccbooktype.getString("name"));
        }
        qfBuilder = new QFBuilder();
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)sourceOrgId));
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add(new QFilter("iscrossorgsyn", "=", (Object)Boolean.FALSE));
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"gl_voucher_rulecondition", (String)"sourceaccbooktype", (QFilter[])qfBuilder.toArray())) {
            sourceaccbooktype = dyn.getDynamicObject("sourceaccbooktype");
            comboItemsMap.put(sourceaccbooktype.getLong("id"), sourceaccbooktype.getString("name"));
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(comboItemsMap.size());
        for (Map.Entry entry : comboItemsMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(String.valueOf(entry.getKey()));
            item.setCaption(new LocaleString((String)entry.getValue()));
            comboItems.add(item);
        }
        return comboItems;
    }

    private List<ComboItem> getTargetBookTypeComboItems(Long sourceOrgId, Long sourceAccBooktypeId, Long targetOrgId) {
        DynamicObject dynamicObject;
        DynamicObjectCollection targetbooktypes;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)sourceOrgId));
        qfBuilder.add("enable", "=", (Object)"1");
        qfBuilder.add("iscrossorgsyn", "=", (Object)"1");
        qfBuilder.add("sourceaccbooktype.id", "=", (Object)sourceAccBooktypeId);
        qfBuilder.add("entryentity.sourceorg", "=", (Object)sourceOrgId);
        qfBuilder.add("entryentity.targetorg", "=", (Object)targetOrgId);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"gl_voucher_rulecondition", (String)"targetaccbooktype", (QFilter[])qfBuilder.toArray());
        HashMap<Long, String> comboItemsMap = new HashMap<Long, String>(16);
        for (DynamicObject dyn : dyns) {
            targetbooktypes = dyn.getDynamicObjectCollection("targetaccbooktype");
            for (DynamicObject targetbooktype : targetbooktypes) {
                dynamicObject = targetbooktype.getDynamicObject("fbasedataid");
                comboItemsMap.put(dynamicObject.getLong("id"), dynamicObject.getString("name"));
            }
        }
        qfBuilder = new QFBuilder();
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)sourceOrgId));
        qfBuilder.add("enable", "=", (Object)"1");
        qfBuilder.add("iscrossorgsyn", "=", (Object)"0");
        qfBuilder.add("sourceaccbooktype.id", "=", (Object)sourceAccBooktypeId);
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"gl_voucher_rulecondition", (String)"targetaccbooktype", (QFilter[])qfBuilder.toArray())) {
            targetbooktypes = dyn.getDynamicObjectCollection("targetaccbooktype");
            for (DynamicObject targetbooktype : targetbooktypes) {
                dynamicObject = targetbooktype.getDynamicObject("fbasedataid");
                comboItemsMap.put(dynamicObject.getLong("id"), dynamicObject.getString("name"));
            }
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(comboItemsMap.size());
        for (Map.Entry entry : comboItemsMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(String.valueOf(entry.getKey()));
            item.setCaption(new LocaleString((String)entry.getValue()));
            comboItems.add(item);
        }
        return comboItems;
    }

    private Set<Long> getTargetOrgIds(Long sourceOrgId, Long sourceBooktypeId) {
        if (DebugTrace.enable()) {
            LOG.info("getTargetOrgIds_orgId:{},booktypeId{}", (Object)sourceOrgId, (Object)sourceBooktypeId);
        }
        HashSet<Long> targetOrgIds = new HashSet<Long>(10);
        List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher_ref", (boolean)false, (PermissonType)PermissonType.VIEW);
        if (pkSet.isEmpty()) {
            return targetOrgIds;
        }
        QFBuilder qfBuilder = new QFBuilder();
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)sourceOrgId);
        qfBuilder.add(baseDataFilter);
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add("sourceaccbooktype.id", "=", (Object)sourceBooktypeId);
        qfBuilder.add(new QFilter("iscrossorgsyn", "=", (Object)Boolean.FALSE));
        boolean exists = QueryServiceHelper.exists((String)"gl_voucher_rulecondition", (QFilter[])qfBuilder.toArray());
        if (exists) {
            targetOrgIds.add(sourceOrgId);
        }
        qfBuilder = new QFBuilder();
        qfBuilder.add(baseDataFilter);
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add("sourceaccbooktype.id", "=", (Object)sourceBooktypeId);
        qfBuilder.add("iscrossorgsyn", "=", (Object)Boolean.TRUE);
        qfBuilder.add("entryentity.sourceorg", "=", (Object)sourceOrgId);
        qfBuilder.add("entryentity.targetorg", "in", (Object)pkSet);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_voucher_rulecondition", (String)"entryentity.targetorg", (QFilter[])qfBuilder.toArray());
        if (dyns != null && dyns.size() > 0) {
            for (DynamicObject dyn : dyns) {
                targetOrgIds.add(dyn.getLong("entryentity.targetorg"));
            }
        }
        if (DebugTrace.enable()) {
            LOG.info("getTargetOrgIds_targetOrgIds:{}", targetOrgIds);
        }
        return targetOrgIds;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String field = args.getFieldName();
        if (field.equals("org.id")) {
            Set<Long> orgIds = this.getCacheFilterContainerAllOrgIds();
            args.addCustomQFilter(new QFilter("id", "in", orgIds));
        } else if (field.equals("booktype.id")) {
            Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
            if (orgId == null || orgId.compareTo(0L) == 0) {
                args.addCustomQFilter(new QFilter("id", "=", (Object)0L));
            } else {
                List<ComboItem> comboItems = this.getSourceBookTypeComboItems(orgId);
                List bookTypeIds = comboItems.stream().map(ci -> Long.parseLong(ci.getValue())).collect(Collectors.toList());
                args.addCustomQFilter(new QFilter("id", "in", bookTypeIds));
            }
        } else if (field.equals("reforg.name")) {
            Set<Long> orgIds = this.queryPermissionBookOrgs();
            args.addCustomQFilter(new QFilter("id", "in", orgIds));
        } else if (field.equals("reforg.id")) {
            Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
            Long booktypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
            if (orgId == null || orgId.compareTo(0L) == 0 || booktypeId == null || booktypeId.compareTo(0L) == 0) {
                args.addCustomQFilter(new QFilter("id", "=", (Object)0L));
            } else {
                Set<Long> targetOrgIds = this.getTargetOrgIds(orgId, booktypeId);
                args.addCustomQFilter(new QFilter("id", "in", targetOrgIds));
            }
        } else if (field.equals("refbooktype.id")) {
            Long refOrgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"reforg.id");
            if (refOrgId == null || refOrgId.compareTo(0L) == 0) {
                args.addCustomQFilter(new QFilter("id", "=", (Object)0L));
            } else {
                Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
                Long booktypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
                List<ComboItem> comboItems = this.getTargetBookTypeComboItems(orgId, booktypeId, refOrgId);
                List bookTypeIds = comboItems.stream().map(ci -> Long.parseLong(ci.getValue())).collect(Collectors.toList());
                args.addCustomQFilter(new QFilter("id", "in", bookTypeIds));
            }
        }
    }

    private Set<Long> getAllOrgIds() {
        Set<Long> orgs = this.queryPermissionBookOrgs();
        if (orgs == null || orgs.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u53ef\u67e5\u8be2\u7684\u7ec4\u7ec7\u672a\u5efa\u7acb\u5b9e\u4f53\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u8bbe\u7f6e\u3002", (String)"VoucherRefList_17", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("ctrlstrategy", "=", (Object)"5");
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add("iscrossorgsyn", "=", (Object)Boolean.FALSE);
        HashSet<Long> useregOrgs = new HashSet(10);
        boolean exists = QueryServiceHelper.exists((String)"gl_voucher_rulecondition", (QFilter[])qfBuilder.toArray());
        if (exists) {
            useregOrgs = orgs;
        } else {
            SqlBuilder unCrossOrgSysSql = new SqlBuilder();
            unCrossOrgSysSql.append(" select u.fuseorgid from t_gl_vourulecon_U as u ", new Object[0]);
            unCrossOrgSysSql.append(" inner join t_gl_vourulecon a on a.fid=u.fdataid ", new Object[0]);
            unCrossOrgSysSql.append(" where a.fenable = '1' ", new Object[0]);
            unCrossOrgSysSql.append(" and a.fiscrossorgsyn = '0' ", new Object[0]);
            unCrossOrgSysSql.appendIn(" and u.fuseorgid ", new ArrayList<Long>(orgs));
            try (DataSet ds = DB.queryDataSet((String)"VoucherRefList_query_rules_U", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)unCrossOrgSysSql);){
                for (Row row : ds) {
                    useregOrgs.add(row.getLong("fuseorgid"));
                }
            }
            qfBuilder = new QFBuilder();
            qfBuilder.add("ctrlstrategy", "=", (Object)"5");
            qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
            qfBuilder.add("iscrossorgsyn", "=", (Object)Boolean.TRUE);
            qfBuilder.add("entryentity.sourceorg", "in", orgs);
            var7_7 = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"VoucherRefList_query_rules_global_share_entry", (String)"gl_voucher_rulecondition", (String)"entryentity.sourceorg.id", (QFilter[])qfBuilder.toArray(), null);){
                for (Row row : dataSet) {
                    useregOrgs.add(row.getLong("entryentity.sourceorg.id"));
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            SqlBuilder crossOrgSysSql = new SqlBuilder();
            crossOrgSysSql.append(" select e.fsourceorgid from t_gl_vourulecon a ", new Object[0]);
            crossOrgSysSql.append(" inner join t_gl_vouruleconentry e on a.fid=e.fid ", new Object[0]);
            crossOrgSysSql.append(" inner join t_gl_vourulecon_U as u on a.fid=u.fdataid ", new Object[0]);
            crossOrgSysSql.append(" where a.fenable = '1' ", new Object[0]);
            crossOrgSysSql.append(" and a.fiscrossorgsyn = '1' ", new Object[0]);
            crossOrgSysSql.appendIn(" and u.fuseorgid ", new ArrayList<Long>(orgs));
            crossOrgSysSql.appendIn(" and e.fsourceorgid ", new ArrayList<Long>(orgs));
            DataSet ds = DB.queryDataSet((String)"VoucherRefList_query_rules_U_crossOrgSysSql", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)crossOrgSysSql);
            Object object = null;
            try {
                for (Row row : ds) {
                    useregOrgs.add(row.getLong("fsourceorgid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return useregOrgs;
    }

    private Set<Long> getAllTargetOrgIds() {
        Set<Long> orgs = this.queryPermissionBookOrgs();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("ctrlstrategy", "=", (Object)"5");
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add("iscrossorgsyn", "=", (Object)Boolean.FALSE);
        HashSet<Long> useregOrgs = new HashSet(10);
        boolean exists = QueryServiceHelper.exists((String)"gl_voucher_rulecondition", (QFilter[])qfBuilder.toArray());
        if (exists) {
            useregOrgs = orgs;
        } else {
            try (DataSet ds = DB.queryDataSet((String)"VoucherRefList_query_rules", (DBRoute)DBRoute.of((String)"fi"), (String)"select distinct fuseorgid from t_gl_vourulecon_U");){
                for (Row row : ds) {
                    useregOrgs.add(row.getLong("fuseorgid"));
                }
            }
            qfBuilder = new QFBuilder();
            qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
            qfBuilder.add("iscrossorgsyn", "=", (Object)Boolean.TRUE);
            ds = QueryServiceHelper.queryDataSet((String)"VoucherRefList_query_sourceOrg", (String)"gl_voucher_rulecondition", (String)"entryentity.sourceorg", (QFilter[])qfBuilder.toArray(), null);
            var6_6 = null;
            try {
                for (Row row : ds) {
                    useregOrgs.add(row.getLong("entryentity.sourceorg"));
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var6_6 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            useregOrgs.retainAll(orgs);
        }
        return useregOrgs;
    }

    private Set<Long> queryPermissionBookOrgs() {
        HashSet<Long> orgIds = null;
        String allOrgIds = this.getPageCache().get("CacheKey_cachePermissionBookOrgss");
        if (StringUtils.isEmpty((CharSequence)allOrgIds)) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher_ref", (boolean)false, (PermissonType)PermissonType.VIEW);
            QFilter orgF = new QFilter("org", "in", (Object)pkSet);
            QFilter enableF = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter isbiz = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{orgF, enableF, isbiz});
            orgIds = new HashSet(orgDyns.size());
            for (DynamicObject org : orgDyns) {
                orgIds.add(org.getLong("org"));
            }
            this.getPageCache().put("CacheKey_cachePermissionBookOrgss", SerializationUtils.toJsonString(orgIds));
        } else {
            orgIds = (HashSet<Long>)SerializationUtils.fromJsonString((String)allOrgIds, Set.class);
        }
        if (orgIds == null) {
            orgIds = new HashSet<Long>(1);
        }
        return orgIds;
    }
}

