/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AmountPrecision;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.AmountGroupInfo;
import kd.bos.entity.list.GroupBySummaryResult;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListCache;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.enums.ControlVisible;
import kd.fi.gl.formplugin.comassist.ComAssistListDataProvider;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.ControlFilterUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.MetaUtils;
import kd.fi.gl.util.PermissonType;
import org.apache.commons.collections4.list.UnmodifiableList;

public class InitBalanceList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(InitBalanceList.class);
    protected static final String ACCOUNTBOOK_INFO = "accountBookInfo";
    private static final String END_INIT_PERIOD = "endinitperiod";
    private static final String PC_BOOKTYPE = "pc_booktype";
    private static final String PC_ORG = "pc_orglist";
    private ListCache listCache = null;

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        QFilter qtalbe;
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_initbalance", (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQfilters().add(new QFilter("id", "in", (Object)pkSet));
        } else if (field.startsWith("booktype.")) {
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            List bookTypeIdList = AccSysUtil.getBookTypeIdList((List)orgIds);
            args.addCustomQFilter(new QFilter("id", "in", (Object)bookTypeIdList));
        } else if (field.startsWith("account.") && (qtalbe = ControlFilterUtil.getAccountFilterByOrgAndBookType(((IListView)this.getView()).getControlFilters())) != null) {
            args.addCustomQFilter(qtalbe);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new InitBalListDataProvider(this.getView()));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        IFormView view = this.getView();
        Long customFilterOrgId = GLUtil.getCustomFilterId((IFormView)view, (String)"org.id");
        Long curFilterBookTypeId = GLUtil.getCustomFilterId((IFormView)view, (String)"booktype.id");
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : listFilterColumns) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "org.name": {
                    List comboItems = AccSysUtil.getAcctOrgComboItem((String)"gl_initbalance", (boolean)false, (PermissonType)PermissonType.VIEW);
                    commFilter.setComboItems(comboItems);
                    if (customFilterOrgId == null) {
                        FormShowParameter showParameter = this.getView().getFormShowParameter();
                        String orgId = (String)showParameter.getCustomParam("imicdimension_bos_org");
                        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
                            customFilterOrgId = Long.parseLong(orgId);
                        } else {
                            ArrayList<Long> orgList = new ArrayList<Long>(comboItems.size());
                            for (ComboItem comboItem : comboItems) {
                                if (comboItem.getValue() == null) continue;
                                orgList.add(Long.parseLong(comboItem.getValue()));
                            }
                            long defaultOrgId = AccSysUtil.getDefaultOrgId((String)"gl_initbalance", (boolean)false, (PermissonType)PermissonType.VIEW);
                            customFilterOrgId = orgList.contains(defaultOrgId) ? Long.valueOf(defaultOrgId) : GlFormUtil.getDefaultAcctOrg(orgList);
                        }
                        if (customFilterOrgId != null) {
                            commFilter.setDefaultValue(customFilterOrgId.toString());
                        }
                    }
                    this.cacheCustomFilterValue(PC_ORG, customFilterOrgId != null ? customFilterOrgId : 0L);
                    break;
                }
                case "booktype.name": {
                    if (customFilterOrgId == null) {
                        customFilterOrgId = GLUtil.getFilterInitDefOrgId((IPageCache)this.getPageCache(), (String)"gl_initbalance");
                        this.cacheCustomFilterValue(PC_ORG, customFilterOrgId != null ? customFilterOrgId : 0L);
                    }
                    List bookTypeCombos = AccSysUtil.getBookTypeComboByOrg((long)(customFilterOrgId != null ? customFilterOrgId : 0L));
                    List bkIds = bookTypeCombos.stream().map(x -> Long.valueOf(x.getValue())).collect(Collectors.toList());
                    commFilter.setComboItems(bookTypeCombos);
                    long defaultBookTypeId = 0L;
                    if (bookTypeCombos.size() > 0) {
                        String value = ((ComboItem)bookTypeCombos.get(0)).getValue();
                        defaultBookTypeId = Long.parseLong(value);
                        if (curFilterBookTypeId == null || !bkIds.contains(curFilterBookTypeId)) {
                            this.setBookTypeControlFilter(defaultBookTypeId);
                            curFilterBookTypeId = defaultBookTypeId;
                        }
                        commFilter.setDefaultValue(curFilterBookTypeId.toString());
                    }
                    this.cacheCustomFilterValue(PC_BOOKTYPE, curFilterBookTypeId == null ? 0L : curFilterBookTypeId);
                    this.setEndInitPeriod(this.getBook());
                    break;
                }
            }
        }
    }

    void setBookTypeControlFilter(Long bookTypeId) {
        FilterContainerFilterValues cachedFilterValues = this.getListCache().getCachedFilterValues();
        FilterKeyValueCollections otherFilterValues = cachedFilterValues.getOtherFilterValues();
        if (otherFilterValues == null) {
            return;
        }
        for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
            List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
            if (!((FilterKeyValue)filterKeyValues.get(0)).getValue().get(0).equals("booktype.id")) continue;
            List values = ((FilterKeyValue)filterKeyValues.get(1)).getValue();
            values.clear();
            values.add(bookTypeId);
        }
        this.getListCache().setCachedFilterValues(cachedFilterValues);
        ControlFilters c = ((ListView)this.getView()).getControlFilters();
        List btValues = c.getFilter("booktype.id");
        btValues.clear();
        btValues.add(bookTypeId);
    }

    protected ListCache getListCache() {
        if (this.listCache == null) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            this.listCache = new ListCache(pageCache, "filtercontainerap");
        }
        return this.listCache;
    }

    private void cacheCustomFilterValue(String key, long value) {
        this.getPageCache().put(key, String.valueOf(value));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        DynamicObject acctbook;
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map filterValues = searchClickEvent.getFilterValues();
        List customFils = (List)filterValues.get("customfilter");
        if (customFils == null) {
            return;
        }
        for (Map map : customFils) {
            String fieldName = (String)((List)map.get("FieldName")).get(0);
            if (!"booktype.id".equals(fieldName)) continue;
            List val = (List)map.get("Value");
            val.clear();
            long bkId = this.getValFromPageCache(PC_BOOKTYPE);
            val.add(bkId == 0L ? "" : String.valueOf(bkId));
            FilterContainer container = (FilterContainer)this.getView().getControl("filtercontainerap");
            FilterContainerFilterValues filters = container.getCachedFilterValues();
            filters.getOtherFilterValues().createFilterValuesList().stream().filter(filter -> "booktype.id".equals(((List)filter.get("FieldName")).get(0))).forEach(filter -> {
                List values = (List)filter.get("Value");
                values.clear();
                values.add(bkId + "");
            });
            container.setCachedFilterValues(filters);
            break;
        }
        if ((acctbook = ControlFilterUtil.getAcctBookByOrgAndBookType(((IListView)this.getView()).getControlFilters())) != null) {
            this.setEndInitPeriod(acctbook);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        customQFilters.add(new QFilter("isdeleted", "=", (Object)false));
        e.setCustomQFilters(customQFilters);
        DynamicObject book = this.getBook();
        if (book != null) {
            this.getView().setEnable(Boolean.valueOf(!book.getBoolean("isendinit")), new String[]{"new", "import", "delete", "btn_modify", "closeinit"});
        }
        this.getComAssistTable().ifPresent(comAssistTable -> comAssistTable.getCommonAssists().forEach(commonAssist -> ComAssistService.getDataPermIds((CommonAssist)commonAssist, Collections.singletonList(this.getValFromPageCache(PC_ORG)), (String)"id").map(ids -> new QFilter(commonAssist.key, "in", ids)).ifPresent(arg_0 -> ((SetFilterEvent)e).addCustomQFilter(arg_0))));
    }

    private DynamicObject getBook() {
        return AccSysUtil.loadSingleBook((Object)this.getValFromPageCache(PC_ORG), (Object)this.getValFromPageCache(PC_BOOKTYPE), (String)"isendinit,startperiod");
    }

    private Optional<ComAssistTable> getComAssistTable() {
        return ComAssistTable.get((Long)this.getValFromPageCache(PC_ORG), (Long)this.getValFromPageCache(PC_BOOKTYPE));
    }

    private void setEndInitPeriod(DynamicObject book) {
        if (book == null) {
            this.getModel().setValue(END_INIT_PERIOD, null);
        } else {
            long startPeriod = book.getLong("startperiod_id");
            this.getModel().setValue(END_INIT_PERIOD, (Object)startPeriod);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCaption(ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u521d\u59cb\u5316", (String)"InitBalanceList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        if (BillOperationStatus.ADDNEW == e.getParameter().getBillStatus() || BillOperationStatus.EDIT == e.getParameter().getBillStatus()) {
            long booksTypeId;
            long orgId = this.getValFromPageCache(PC_ORG);
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)(booksTypeId = this.getValFromPageCache(PC_BOOKTYPE)));
            if (bookInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"InitBalanceList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            e.getParameter().setCustomParam(ACCOUNTBOOK_INFO, (Object)GLUtil.toSerializedString((Object)bookInfo));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "modify": {
                ListSelectedRowCollection data = args.getListSelectedData();
                if (data.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f59\u989d\u6570\u636e\u3002", (String)"InitBalanceList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                if (data.size() == 1) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"InitBalanceList_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            case "closeinit": {
                this.closeinit();
                break;
            }
            case "batchcloseinit": {
                this.showForm(Boolean.TRUE);
                break;
            }
            case "anticloseinit": {
                this.anticloseinit();
                break;
            }
            case "batchanitcloseinit": {
                this.showForm(Boolean.FALSE);
                break;
            }
        }
    }

    private void showForm(boolean isForEndInit) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_initbalance", (boolean)false, (PermissonType)PermissonType.VIEW);
        QFilter qfbookstype = new QFilter("bookstype", "=", (Object)this.getValFromPageCache(PC_BOOKTYPE));
        DynamicObjectCollection dynBookTypeColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id", (QFilter[])new QFilter[]{qfbookstype});
        Set ids = dynBookTypeColl.stream().map(v -> v.getLong("org.id")).collect(Collectors.toSet());
        pkSet.retainAll(ids);
        QFilter qfisendinit = new QFilter("isendinit", "=", (Object)isForEndInit);
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"gl_endinit", (String)"org.id", (QFilter[])new QFilter[]{qfbookstype, qfisendinit});
        pkSet.removeAll(dynColl.stream().map(v -> v.getLong("org.id")).collect(Collectors.toSet()));
        qFilters.add(new QFilter("id", "in", (Object)pkSet));
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)0);
        para.setCustomParam("islockfunc", (Object)true);
        para.setCustomParam("orgFuncId", (Object)"10");
        para.getListFilterParameter().setQFilters(qFilters);
        para.setCustomParam("range", ids);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isForEndInit ? "batchcloseinit" : "batchanitcloseinit"));
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            if ("batchcloseinit".equals(evt.getActionId())) {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                this.batchInitOp(rows);
            } else if ("batchanitcloseinit".equals(evt.getActionId())) {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                this.batchAntiInitOp(rows);
            }
        }
    }

    private void closeinit() {
        this.initOp("closeinitbalance");
    }

    private void anticloseinit() {
        this.initOp("anticloseinitbalance");
    }

    private void batchInitOp(ListSelectedRowCollection rows) {
        long booksTypeId = this.getValFromPageCache(PC_BOOKTYPE);
        ArrayList<OperationResult> batchOpResult = new ArrayList<OperationResult>();
        boolean isContainsCurOrg = false;
        Long curOrgId = this.getValFromPageCache(PC_ORG);
        for (ListSelectedRow row : rows) {
            OperationResult initOpResult = this.initOp((Long)row.getPrimaryKeyValue(), booksTypeId, "closeinitbalance");
            batchOpResult.add(initOpResult);
            if (!initOpResult.isSuccess() || !curOrgId.equals(row.getPrimaryKeyValue())) continue;
            isContainsCurOrg = true;
        }
        if (isContainsCurOrg) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"new", "import", "delete", "btn_modify", "closeinit"});
        }
        this.showOperationResult(batchOpResult, rows.stream().map(x -> x.getName()).collect(Collectors.toList()), true);
    }

    private void batchAntiInitOp(ListSelectedRowCollection rows) {
        long booksTypeId = this.getValFromPageCache(PC_BOOKTYPE);
        ArrayList<OperationResult> batchOpResult = new ArrayList<OperationResult>();
        boolean isContainsCurOrg = false;
        Long curOrgId = this.getValFromPageCache(PC_ORG);
        for (ListSelectedRow row : rows) {
            OperationResult antiInitOpResult = this.initOp((Long)row.getPrimaryKeyValue(), booksTypeId, "anticloseinitbalance");
            batchOpResult.add(antiInitOpResult);
            if (!antiInitOpResult.isSuccess() || !curOrgId.equals(row.getPrimaryKeyValue())) continue;
            isContainsCurOrg = true;
        }
        if (isContainsCurOrg) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"new", "import", "delete", "btn_modify", "closeinit"});
        }
        this.showOperationResult(batchOpResult, rows.stream().map(x -> x.getName()).collect(Collectors.toList()), false);
    }

    private void initOp(String opKey) {
        OperationResult result;
        Long booksTypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
        Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        if (DebugTrace.enable()) {
            logger.info("InitBalanceList_closeinit_orgId:{},booksTypeId:{};PageCacheorgId:{},PageCacheBooksTypeId:{}", new Object[]{orgId, booksTypeId, this.getValFromPageCache(PC_ORG), this.getValFromPageCache(PC_BOOKTYPE)});
        }
        if ((result = this.initOp(orgId, booksTypeId, opKey)).isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(opKey.equals("anticloseinitbalance")), new String[]{"new", "import", "delete", "btn_modify", "closeinit"});
            String info = "anticloseinitbalance".equals(opKey) ? ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitBalanceList_4", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitBalanceList_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(info);
        } else {
            this.getView().showOperationResult(result);
        }
    }

    private OperationResult initOp(Long orgId, Long booksTypeId, String opKey) {
        if (orgId == null || orgId == 0L || booksTypeId == null || booksTypeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6216\u8d26\u7c3f\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"InitBalanceList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        DynamicObject book = AccSysUtil.loadSingleBook((Object)orgId, (Object)booksTypeId, (String)"id");
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"InitBalanceList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        book = BusinessDataServiceHelper.loadSingle((Object)book.getLong("id"), (String)"gl_endinit");
        return OperationServiceHelper.executeOperate((String)opKey, (String)"gl_endinit", (DynamicObject[])new DynamicObject[]{book}, (OperateOption)OperateOption.create());
    }

    private void showOperationResult(List<OperationResult> batchOpResults, List<String> msgTitles, boolean isEndInit) {
        if (batchOpResults.stream().allMatch(x -> x.isSuccess())) {
            String sucMsg = isEndInit ? ResManager.loadKDString((String)"\u5168\u90e8\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitBalanceList_7", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5168\u90e8\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitBalanceList_8", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(sucMsg);
        } else {
            String summary = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5171\u64cd\u4f5c%1\u9879\uff0c\u6210\u529f%2\u9879\uff0c\u5931\u8d25%3\u9879\u3002", (String)"InitBalanceList_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), (String)"InitBalanceList_9", (String)"fi-gl-formplugin", (Object[])new Object[]{batchOpResults.size(), batchOpResults.stream().filter(x -> x.isSuccess()).count(), batchOpResults.stream().filter(x -> !x.isSuccess()).count()});
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < batchOpResults.size(); ++i) {
                details.append(msgTitles.get(i)).append("\uff1a");
                OperationResult curOpResult = batchOpResults.get(i);
                if (curOpResult.isSuccess()) {
                    details.append(ResManager.loadKDString((String)"\u6210\u529f", (String)"InitBalanceList_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                } else if (!curOpResult.getAllErrorOrValidateInfo().isEmpty()) {
                    String opOriginMsg = ((IOperateInfo)curOpResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                    Object[] billNos = curOpResult.getBillNos().values().toArray(new String[curOpResult.getBillNos().size()]);
                    if (Objects.nonNull(opOriginMsg) && ArrayUtils.isNotEmpty((Object[])billNos) && StringUtils.isNotEmpty((CharSequence)billNos[0]) && opOriginMsg.contains((CharSequence)billNos[0])) {
                        details.append(opOriginMsg.replace((String)billNos[0] + ": ", ""));
                    } else {
                        details.append(opOriginMsg);
                    }
                } else {
                    details.append(curOpResult.getMessage());
                }
                details.append("\n");
            }
            this.getView().showConfirm(summary, details.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
        }
    }

    long getValFromPageCache(String key) {
        switch (key) {
            case "pc_booktype": {
                String booksTypeStr = this.getPageCache().get(PC_BOOKTYPE);
                return booksTypeStr == null ? 0L : Long.parseLong(booksTypeStr);
            }
            case "pc_orglist": {
                String orgIdsJson = this.getPageCache().get(PC_ORG);
                return orgIdsJson == null ? 0L : Long.parseLong(orgIdsJson);
            }
        }
        return 0L;
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        UnmodifiableList configs = LocalCurrencyConfigService.queryEnableCurrencies();
        HashMap field2Enable = new HashMap(64);
        long org = this.getValFromPageCache(PC_ORG);
        long bookTypeId = this.getValFromPageCache(PC_BOOKTYPE);
        for (LocalCurrencyConfigVO config : configs) {
            boolean enabled = config.getCurrencyId(org, bookTypeId) > 0L;
            config.getAllInitBalanceFields().stream().map(MetaField::getMetaId).forEach(field -> field2Enable.put(field, enabled));
        }
        args.getListColumns().stream().filter(ListColumn.class::isInstance).map(ListColumn.class::cast).filter(column -> field2Enable.containsKey(column.getFieldKey())).forEach(x -> x.setVisible((Boolean)field2Enable.get(x.getFieldKey()) != false ? ControlVisible.show.value : ControlVisible.hide.value));
    }

    class InitBalListDataProvider
    extends ComAssistListDataProvider {
        public InitBalListDataProvider(IFormView view) {
            super(view);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            return this.addMulLocalCurProp(super.getData(start, limit));
        }

        DynamicObjectCollection addMulLocalCurProp(DynamicObjectCollection data) {
            long org = InitBalanceList.this.getValFromPageCache(InitBalanceList.PC_ORG);
            long bookTypeId = InitBalanceList.this.getValFromPageCache(InitBalanceList.PC_BOOKTYPE);
            UnmodifiableList configs = LocalCurrencyConfigService.queryEnableCurrencies();
            for (LocalCurrencyConfigVO config : configs) {
                String curFieldKey = config.getCurrencyField();
                CurrencyProp curProp = (CurrencyProp)this.getEntityType().getProperty(curFieldKey);
                MetaUtils.registerIDataEntityProperty((IDataEntityProperty)curProp, (DynamicObjectType)data.getDynamicObjectType());
                for (DynamicObject row : data) {
                    long currencyId = config.getCurrencyId(org, bookTypeId);
                    DynamicObject curDyo = null;
                    if (currencyId != 0L) {
                        curDyo = BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency");
                    }
                    row.set(curFieldKey, curDyo);
                    row.set(curFieldKey + "_id", (Object)currencyId);
                }
            }
            return data;
        }

        public QueryBuilder getQueryBuilder() {
            return this.removeMcGroupBySumFields(super.getQueryBuilder());
        }

        QueryBuilder removeMcGroupBySumFields(QueryBuilder queryBuilder) {
            List groupBySumFields = queryBuilder.getGroupBySumFields();
            if (!groupBySumFields.isEmpty()) {
                UnmodifiableList configs = LocalCurrencyConfigService.queryEnableCurrencies();
                HashSet<String> mcFields = new HashSet<String>();
                for (LocalCurrencyConfigVO config : configs) {
                    for (MetaField field : config.getAllInitBalanceFields()) {
                        mcFields.add(field.getMetaId());
                    }
                }
                groupBySumFields.removeIf(mcFields::contains);
            }
            return queryBuilder;
        }

        public List<SummaryResult> getSummaryResults() {
            ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>();
            HashMap<String, SummaryResult> mcField2Sum = new HashMap<String, SummaryResult>(18);
            super.getSummaryResults().forEach(sumRes -> mcField2Sum.put(sumRes.getFieldName(), (SummaryResult)sumRes));
            UnmodifiableList configs = LocalCurrencyConfigService.queryEnableCurrencies();
            if (configs.size() > 0) {
                long org = InitBalanceList.this.getValFromPageCache(InitBalanceList.PC_ORG);
                long bookTypeId = InitBalanceList.this.getValFromPageCache(InitBalanceList.PC_BOOKTYPE);
                Map<String, Long> amtKey2CurId = this.getMcAmtKey2CurId((Collection<LocalCurrencyConfigVO>)configs, org, bookTypeId);
                Map<Long, NumberPrecision> numberPrecisionMap = this.getNumberPrecision(amtKey2CurId.values());
                mcField2Sum.forEach((mcField, oriSum) -> {
                    Long curId = (Long)amtKey2CurId.get(mcField);
                    if (curId != null && curId != 0L) {
                        NumberPrecision numberPrecision = (NumberPrecision)numberPrecisionMap.get(curId);
                        AmountGroupInfo amountGroupInfo = new AmountGroupInfo((Object)curId);
                        AmountPrecision amtPrecision = new AmountPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), oriSum.getNumberPrecision().getResult(), numberPrecision.getFormatObject());
                        amountGroupInfo.setValue(amtPrecision.getFmtString());
                        amountGroupInfo.setAbbreviation(amtPrecision.getFormatObject().getCurrencyFormat().getCurrencyNumber());
                        summaryResults.add((SummaryResult)new GroupBySummaryResult(mcField, (NumberPrecision)amtPrecision, 1, amountGroupInfo));
                    } else {
                        summaryResults.add((SummaryResult)oriSum);
                    }
                });
            }
            return summaryResults;
        }

        Map<Long, NumberPrecision> getNumberPrecision(Collection<Long> curIds) {
            return curIds.stream().distinct().filter(id -> id != 0L).collect(Collectors.toMap(curId -> curId, this::getNumberPrecision));
        }

        Map<String, Long> getMcAmtKey2CurId(Collection<LocalCurrencyConfigVO> configs, long org, long bookTypeId) {
            HashMap<String, Long> amtKey2CurId = new HashMap<String, Long>(4);
            for (LocalCurrencyConfigVO config : configs) {
                long currencyId = config.getCurrencyId(org, bookTypeId);
                config.getAllInitBalanceFields().forEach(f -> {
                    String metaId = f.getMetaId();
                    amtKey2CurId.put(metaId, currencyId);
                });
            }
            return amtKey2CurId;
        }

        NumberPrecision getNumberPrecision(long currencyId) {
            DynamicObject cur = BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency");
            FormatObject formatObject = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
            int amtPrecision = cur.getInt("priceprecision");
            String currencySign = cur.getString("sign");
            String curNum = cur.getString("number");
            formatObject.getCurrencyFormat().setMinimumFractionDigits(amtPrecision);
            formatObject.getCurrencyFormat().setCurrencySymbols(currencySign);
            formatObject.getCurrencyFormat().setCurrencyNumber(curNum);
            return new AmountPrecision(amtPrecision, currencySign, false, BigDecimal.ZERO, formatObject);
        }
    }
}

