/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.TransBalToReciUtil;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class ReciprocalInitDiffPlugin
extends AbstractFormPlugin {
    private static final String DIFFAMOUNTLOCAL = "diffamountlocal";
    private static final String DIFFAMOUNTFOR = "diffamountfor";
    private static final String INITLOCAL = "initlocal";
    private static final String INITFOR = "initfor";

    public void afterCreateNewData(EventObject e) {
        Object row2;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        Long accountId = (Long)formShowParam.getCustomParam("account");
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
        String assgrpValue = (String)formShowParam.getCustomParam("assgrp");
        Collection assistFilterEntries = null;
        if (assgrpValue != null) {
            HashMap flexMap = new HashMap(8);
            JSONObject assistMap = JSON.parseObject((String)assgrpValue);
            for (Map.Entry entry : assistMap.entrySet()) {
                String flexField = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Integer && value.equals(0)) continue;
                HashSet values = new HashSet(8);
                values.add(value);
                flexMap.put(flexField, values);
            }
            if (!flexMap.isEmpty()) {
                assistFilterEntries = ReciprocalUtils.buildAssistFilterInfo(flexMap);
            }
        }
        Long periodId = Long.valueOf((String)formShowParam.getCustomParam("period"));
        Long[] currencyIds = new Long[]{Long.valueOf((String)formShowParam.getCustomParam("currency"))};
        Long accountBookId = (Long)formShowParam.getCustomParam("book");
        AccountBookInfo accountBookInfo = new AccountBookInfo(accountBookId.longValue());
        model.setValue("currency", (Object)currencyIds[0]);
        model.setValue("curlocal", (Object)accountBookInfo.getBaseCurrencyId());
        String accountName = account.getString("name");
        String accountNumber = account.getString("number");
        String acctname = accountNumber + "             " + accountName;
        model.setValue("acctname", (Object)acctname);
        BigDecimal amountFor = BigDecimal.ZERO;
        BigDecimal amountLocal = BigDecimal.ZERO;
        BigDecimal dc = new BigDecimal(account.getString("dc"));
        try (DataSet sumBalanceDs = this.sumBalance(account, assistFilterEntries, periodId, currencyIds, accountBookInfo);){
            if (sumBalanceDs != null) {
                for (Object row2 : sumBalanceDs) {
                    amountFor = row2.getBigDecimal("beginfor").multiply(dc);
                    amountLocal = row2.getBigDecimal("beginlocal").multiply(dc);
                    model.setValue("amountfor", (Object)amountFor);
                    model.setValue("amountlocal", (Object)amountLocal);
                }
            }
        }
        BigDecimal initFor = BigDecimal.ZERO;
        BigDecimal initLocal = BigDecimal.ZERO;
        DataSet sumReciprocalInit = this.sumReciprocalInit(account, currencyIds, assistFilterEntries, accountBookInfo);
        row2 = null;
        try {
            if (sumReciprocalInit != null) {
                for (Row row3 : sumReciprocalInit) {
                    initFor = row3.getBigDecimal("amountfor");
                    initLocal = row3.getBigDecimal("amountlocal");
                    model.setValue(INITFOR, (Object)initFor);
                    model.setValue(INITLOCAL, (Object)initLocal);
                }
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (sumReciprocalInit != null) {
                if (row2 != null) {
                    try {
                        sumReciprocalInit.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    sumReciprocalInit.close();
                }
            }
        }
        BigDecimal diffAmountFor = amountFor.subtract(initFor);
        BigDecimal diffAmountLocal = amountLocal.subtract(initLocal);
        model.setValue(DIFFAMOUNTFOR, (Object)diffAmountFor);
        model.setValue(DIFFAMOUNTLOCAL, (Object)diffAmountLocal);
        this.setColorRedIfNotZero(DIFFAMOUNTFOR, diffAmountFor);
        this.setColorRedIfNotZero(DIFFAMOUNTLOCAL, diffAmountLocal);
    }

    private void setColorRedIfNotZero(String controlKey, BigDecimal value) {
        if (value.signum() != 0) {
            FieldAp field = new FieldAp();
            field.setForeColor("#ff0000");
            field.setKey(controlKey);
            this.getView().updateControlMetadata(controlKey, field.createControl());
        }
    }

    private DataSet sumReciprocalInit(DynamicObject account, Long[] currencyIds, Collection<FlexUtils.AssistFilterEntry> assistFilterEntries, AccountBookInfo accountBookInfo) {
        String selectFields = "account, currency , amountfor, amountlocal";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("account.masterid", "=", (Object)account.getLong("masterid")));
        filters.add(new QFilter("currency", "=", (Object)currencyIds[0]));
        filters.add(new QFilter("org", "=", (Object)accountBookInfo.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)accountBookInfo.getBookTypeId()));
        if (assistFilterEntries != null) {
            Triple ormInfo = FlexUtils.buildDynamicORMAssistOnBalance(assistFilterEntries, (String)"gl_initacccurrent", (boolean)true);
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_initacccurrent", (IDataEntityType)ormInfo.getLeft());
            List middle = (List)ormInfo.getMiddle();
            filters.addAll(middle);
            try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "gl_initacccurrent", selectFields, filters.toArray(new QFilter[0]));){
                GroupbyDataSet groupByDs = ds.groupBy(new String[]{"account", "currency"});
                DataSet dataSet = groupByDs.sum("amountfor").sum("amountlocal").finish().select("amountfor, amountlocal");
                return dataSet;
            }
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "sumReciprocalInit"), (String)"gl_initacccurrent", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupByDs = ds.groupBy(new String[]{"account", "currency"});
        return groupByDs.sum("amountfor").sum("amountlocal").finish().select("amountfor, amountlocal");
    }

    private DataSet sumBalance(DynamicObject account, Collection<FlexUtils.AssistFilterEntry> assistFilterEntries, Long periodId, Long[] currencyIds, AccountBookInfo accountBookInfo) {
        List accheckFlexField;
        TransBalToReciUtil transUtil = new TransBalToReciUtil();
        DataSet ds = transUtil.queryValidateBalDataSet(account = BusinessDataServiceHelper.loadSingleFromCache((Object)account.get("id"), (String)"bd_accountview"), assistFilterEntries, periodId, currencyIds, accountBookInfo, accheckFlexField = transUtil.collectNotAccheckFlexField(account));
        if (ds != null) {
            StringBuilder filterStr = new StringBuilder();
            for (String flexField : accheckFlexField) {
                filterStr.append(" or ").append(flexField).append(" != null ");
            }
            if (filterStr.length() > 4) {
                ds = ds.filter(filterStr.substring(4));
            }
            GroupbyDataSet dsGroupBy = ds.groupBy(new String[]{"account"});
            return dsGroupBy.sum("beginfor").sum("beginlocal").finish();
        }
        return null;
    }
}

