/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.listfilter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.fi.gl.listfilter.FilterValues;

public class FilterContainerValues {
    private static final String SCHEMEFILTER = "schemefilter";
    private static final String CUSTOMFILTER = "customfilter";
    private static final String FASTFILTER = "fastfilter";
    private final Map<String, List<Map<String, List<Object>>>> allFilterValuesMap;
    private final List<FilterValues> customFilterValuesList;
    private final List<FilterValues> schemeFilterValuesList;
    private final List<FilterValues> fastFilterValuesList;

    public FilterContainerValues(Map<String, List<Map<String, List<Object>>>> filterValuesMap) {
        this.allFilterValuesMap = filterValuesMap;
        List customFilterList = filterValuesMap.get(CUSTOMFILTER) == null ? Collections.emptyList() : filterValuesMap.get(CUSTOMFILTER);
        List schemeFilterList = filterValuesMap.get(SCHEMEFILTER) == null ? Collections.emptyList() : filterValuesMap.get(SCHEMEFILTER);
        List fastFilterList = filterValuesMap.get(FASTFILTER) == null ? Collections.emptyList() : filterValuesMap.get(FASTFILTER);
        this.customFilterValuesList = customFilterList.stream().map(FilterValues::new).collect(Collectors.toList());
        this.schemeFilterValuesList = schemeFilterList.stream().map(FilterValues::new).collect(Collectors.toList());
        this.fastFilterValuesList = fastFilterList.stream().map(FilterValues::new).collect(Collectors.toList());
    }

    public Map<String, List<Map<String, List<Object>>>> getAllFilterValuesMap() {
        return this.allFilterValuesMap;
    }

    public List<FilterValues> getCustomFilterValuesList() {
        return this.customFilterValuesList;
    }

    public List<FilterValues> getSchemeFilterValuesList() {
        return this.schemeFilterValuesList;
    }

    public List<FilterValues> getFastFilterValuesList() {
        return this.fastFilterValuesList;
    }

    public void updateValue() {
        for (FilterValues filterValues : this.customFilterValuesList) {
            filterValues.updateValue();
        }
        for (FilterValues filterValues : this.schemeFilterValuesList) {
            filterValues.updateValue();
        }
        for (FilterValues filterValues : this.fastFilterValuesList) {
            filterValues.updateValue();
        }
    }
}

