/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;

public class AcAccountCheckRptPrint
extends AbstractPrintServicePlugin {
    private FormatObject fobj;
    private Format dateFormat;

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        ThreadCache.put((Object)"isPrintOperation", (Object)true);
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>();
        ReportListModel listModel = null;
        listModel = ReportPrintHelper.getListModel(e.getPageId());
        if (listModel == null) {
            return;
        }
        int rowCount = listModel.getRowCount();
        DynamicObjectCollection col = listModel.getRowData(0, rowCount);
        ArrayList<String> assistKeyList = new ArrayList<String>();
        ArrayList<String> assistCaptionList = new ArrayList<String>();
        this.getAssist((IReportListModel)listModel, assistKeyList, assistCaptionList);
        if (e.isMainDs()) {
            ReportQueryParam param = listModel.getReportQueryParam();
            DynamicObject orgDyn = (DynamicObject)param.getFilter().getFilterItem("org").getValue();
            DynamicObject accountDyn = (DynamicObject)param.getFilter().getFilterItem("account1").getValue();
            String orgName = orgDyn.getString("name");
            DynamicObjectType dt = new DynamicObjectType("mainds");
            dt.registerProperty("id", String.class, (Object)"", false);
            dt.registerProperty("orgtype", String.class, (Object)"", false);
            dt.registerProperty("account", String.class, (Object)"", false);
            dt.registerProperty("showassist", String.class, (Object)"", false);
            String preAccountName = "";
            String preAssistName = "";
            long indexId = 1L;
            for (DynamicObject o : col) {
                String accountName = accountDyn.getString("name");
                String accountNumber = accountDyn.getString("number");
                String assistName = this.assistVal(assistKeyList, assistCaptionList, o);
                if (preAccountName.equals(accountName + accountNumber) && preAssistName.equals(assistName)) continue;
                preAccountName = accountName + accountNumber;
                preAssistName = assistName;
                DynamicObject obj = new DynamicObject(dt);
                obj.set("id", (Object)indexId);
                obj.set("orgtype", (Object)orgName);
                obj.set("account", (Object)accountName);
                obj.set("showassist", (Object)assistName);
                ++indexId;
                objectList.add(obj);
            }
        } else {
            DynamicObjectType dt = new DynamicObjectType("mainds1");
            dt.registerProperty("seq", String.class, (Object)"", false);
            dt.registerProperty("datefield", String.class, (Object)"", false);
            dt.registerProperty("bizdate", String.class, (Object)"", false);
            dt.registerProperty("vouchernumber", String.class, (Object)"", false);
            dt.registerProperty("desc", String.class, (Object)"", false);
            dt.registerProperty("debitlocal", String.class, (Object)"", false);
            dt.registerProperty("creditlocal", String.class, (Object)"", false);
            dt.registerProperty("dc", String.class, (Object)"", false);
            dt.registerProperty("endlocal", String.class, (Object)"", false);
            QFilter fid = e.getFilter();
            String id = (String)fid.getValue();
            if (StringUtils.isNotBlank((CharSequence)id) && rowCount > 0) {
                int indexId = Integer.parseInt(id);
                int index = 1;
                int rowIndex = 1;
                boolean isFirst = true;
                String accountName = ((DynamicObject)col.get(0)).getString("accountname");
                String accountNumber = ((DynamicObject)col.get(0)).getString("accountnumber");
                String preAccountName = accountName + accountNumber;
                String preAsisstName = this.assistVal(assistKeyList, assistCaptionList, (DynamicObject)col.get(0));
                String asisstName = "";
                this.fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
                this.dateFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
                for (DynamicObject o : col) {
                    accountName = o.getString("accountname");
                    accountNumber = o.getString("accountnumber");
                    asisstName = this.assistVal(assistKeyList, assistCaptionList, o);
                    if (preAccountName.equals(accountName + accountNumber) && preAsisstName.equals(asisstName)) {
                        if (indexId == index) {
                            this.setEntryData(o, dt, rowIndex, objectList);
                            isFirst = false;
                        } else if (!isFirst) {
                            break;
                        }
                    } else {
                        preAccountName = accountName + accountNumber;
                        preAsisstName = asisstName;
                        if (indexId == ++index && isFirst) {
                            this.setEntryData(o, dt, rowIndex, objectList);
                            isFirst = false;
                        }
                    }
                    ++rowIndex;
                }
            }
        }
        e.setDataEntities(objectList);
    }

    private String assistVal(List<String> keyList, List<String> captionList, DynamicObject rowSet) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyList.size(); ++i) {
            String key = keyList.get(i);
            String caption = captionList.get(i);
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(";");
            }
            sb.append(caption);
            sb.append(":");
            Object value = rowSet.get(key);
            if (value instanceof String) {
                sb.append(rowSet.get(key).toString());
                continue;
            }
            if (!(value instanceof DynamicObject)) continue;
            sb.append(((DynamicObject)rowSet.get(key)).getString("name"));
        }
        return sb.toString();
    }

    private void getAssist(IReportListModel reportListModel, List<String> keyList, List<String> captionList) {
        List listColumn = reportListModel.getColumns();
        for (int i = 1; i < listColumn.size(); ++i) {
            ReportColumn column = (ReportColumn)listColumn.get(i);
            String key = column.getFieldKey();
            if ("period".equals(key)) continue;
            if ("accountnumber".equals(key)) break;
            captionList.add(column.getCaption().toString());
            keyList.add(key);
        }
    }

    private void setEntryData(DynamicObject o, DynamicObjectType dt, int i, List<DynamicObject> objectList) {
        String time;
        DynamicObject obj = new DynamicObject(dt);
        obj.set("seq", (Object)i);
        if (o.get("datefield") != null) {
            time = this.dateFormat.format(o.get("datefield"));
            obj.set("datefield", (Object)time);
        }
        if (o.get("bizdate") != null) {
            time = this.dateFormat.format(o.get("bizdate"));
            obj.set("bizdate", (Object)time);
        }
        obj.set("vouchernumber", o.get("vouchernumber"));
        obj.set("desc", o.get("desc"));
        String sign = o.getString("basecurrency.sign");
        int amtVal = o.getInt("basecurrency.amtprecision");
        this.fobj.getCurrencyFormat().setCurrencySymbols(sign);
        this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtVal);
        Format moneyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
        BigDecimal debitVal = o.getBigDecimal("debitlocal");
        obj.set("debitlocal", (Object)this.dealZero(debitVal, moneyFormat));
        BigDecimal creditVal = o.getBigDecimal("creditlocal");
        obj.set("creditlocal", (Object)this.dealZero(creditVal, moneyFormat));
        obj.set("dc", (Object)this.dealDc(o.getString("dc")));
        BigDecimal endLocalVal = o.getBigDecimal("endlocal");
        obj.set("endlocal", (Object)this.dealZero(endLocalVal, moneyFormat));
        objectList.add(obj);
    }

    private String dealZero(BigDecimal bigDecimal, Format format) {
        if (bigDecimal != null) {
            if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                return null;
            }
            return format.format(bigDecimal);
        }
        return null;
    }

    private String dealDc(String dc) {
        if (StringUtils.isNotBlank((CharSequence)dc)) {
            int dcVal = Integer.parseInt(dc);
            dc = 1 == dcVal ? ResManager.loadKDString((String)"\u501f\u65b9", (String)"AcAccountCheckRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]) : (-1 == dcVal ? ResManager.loadKDString((String)"\u8d37\u65b9", (String)"AcAccountCheckRptPrint_1", (String)"fi-gl-formplugin", (Object[])new Object[0]) : null);
        }
        return dc;
    }
}

