/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GLUtil;

public class AccountBalanceCompareFormPlugin
extends AbstractReportFormPlugin {
    private static final String DC_DEBIT = "1";
    private static final String TO_ORG = "toorg";
    private static final String TO_BOOKTYPE = "tobooktype";
    private static final String TO_ACCOUNTTABLE = "toaccounttable";

    public void registerListener(EventObject eventObject) {
        IDataModel model = this.getModel();
        long orgid = (Long)model.getValue("org_id");
        long toOrgid = (Long)model.getValue(GLField.id_((String)TO_ORG));
        BasedataEdit sourceAccountType = (BasedataEdit)this.getControl("booktype");
        sourceAccountType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            QFilter orgf = new QFilter("org", "=", (Object)orgid);
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{orgf});
            ArrayList<Long> typeid = new ArrayList<Long>(2);
            if (books != null) {
                for (DynamicObject book : books) {
                    typeid.add(book.getLong("bookstype"));
                }
            }
            QFilter bookf = new QFilter("id", "in", typeid);
            qFilters.add(bookf);
        });
        BasedataEdit toaccounttype = (BasedataEdit)this.getControl(TO_BOOKTYPE);
        toaccounttype.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            QFilter orgf = new QFilter("org", "=", (Object)toOrgid);
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{orgf});
            ArrayList<Long> typeid = new ArrayList<Long>(2);
            if (books != null) {
                for (DynamicObject book : books) {
                    typeid.add(book.getLong("bookstype"));
                }
            }
            QFilter bookf = new QFilter("id", "in", typeid);
            qFilters.add(bookf);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": 
            case "tobooktype": {
                long toOrgId = (Long)this.getModel().getValue(GLField.id_((String)TO_ORG));
                long targetBookTypeId = (Long)this.getModel().getValue(GLField.id_((String)TO_BOOKTYPE));
                if (toOrgId == 0L || targetBookTypeId == 0L) {
                    this.getModel().setValue(TO_ACCOUNTTABLE, null);
                    return;
                }
                AccountBookInfo targetBookInfo = AccSysUtil.getBookFromAccSys((long)toOrgId, (long)targetBookTypeId);
                if (targetBookInfo == null) {
                    this.getModel().setValue(TO_ACCOUNTTABLE, null);
                    return;
                }
                this.getModel().setValue(TO_ACCOUNTTABLE, (Object)targetBookInfo.getAccountTableId());
                break;
            }
        }
    }

    private Boolean isShowByAccDc(Long orgId) {
        Boolean bIsShowByAccountDC = (Boolean)GLUtil.getSystemParam((String)"showbyaccountdc", (Long)orgId);
        if (bIsShowByAccountDC == null) {
            bIsShowByAccountDC = Boolean.FALSE;
        }
        return bIsShowByAccountDC;
    }

    private void setAmountByDC(Boolean isShowByDC, DynamicObject row, String accountField, String debitField, String creditField) {
        if (!isShowByDC.booleanValue()) {
            return;
        }
        DynamicObject account = row.getDynamicObject(accountField);
        if (account == null) {
            return;
        }
        String dc = account.getString("dc");
        BigDecimal debitAmt = row.getBigDecimal(debitField);
        BigDecimal creditAmt = row.getBigDecimal(creditField);
        if (DC_DEBIT.equals(dc)) {
            if (creditAmt.compareTo(BigDecimal.ZERO) > 0) {
                row.set(debitField, (Object)creditAmt.negate());
                row.set(creditField, (Object)0);
            }
        } else if (debitAmt.compareTo(BigDecimal.ZERO) > 0) {
            row.set(debitField, (Object)0);
            row.set(creditField, (Object)debitAmt.negate());
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Long preAcctId = 0L;
        Long preCurrencyId = 0L;
        FilterInfo filterInfo = queryParam.getFilter();
        Long orgId = filterInfo.getLong("org");
        Boolean isShowByDC = this.isShowByAccDc(orgId);
        for (DynamicObject row : rowData) {
            boolean isEql;
            this.setAmountByDC(isShowByDC, row, "accountfor", "debitendfor", "creditendfor");
            Long newAccountId = row.getLong("accountto.id");
            Long currencyId = row.getLong("currencyfor.id");
            boolean bl = isEql = preAcctId.equals(newAccountId) && preCurrencyId.equals(currencyId);
            if (isEql) {
                row.set("accountto", null);
                row.set("debitcurto", null);
                row.set("creditcurto", null);
                row.set("debitendto", null);
                row.set("creditendto", null);
                row.set("debitdiffcur", null);
                row.set("creditdiffcur", null);
                row.set("debitdiffend", null);
                row.set("creditdiffend", null);
                continue;
            }
            preAcctId = newAccountId;
            preCurrencyId = currencyId;
            this.setAmountByDC(isShowByDC, row, "accountto", "debitendto", "creditendto");
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject targetBookTypeDyn = filter.getDynamicObject(TO_BOOKTYPE);
        if (null == targetBookTypeDyn) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AccountBalanceCompareFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        long toOrgid = filter.getLong(TO_ORG);
        AccountBookInfo targetBookInfo = AccSysUtil.getBookFromAccSys((long)toOrgid, (long)targetBookTypeDyn.getLong("id"));
        if (targetBookInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u76ee\u6807\u8d26\u7c3f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AccountBalanceCompareFormPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (targetBookInfo.getPeriodTypeId() != filter.getDynamicObject("periodtype").getLong("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\u5bf9\u5e94\u7684\u671f\u95f4\u7c7b\u578b\u4e0e\u4e3b\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u3002", (String)"AccountBalanceCompareFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filter.getLong("org") == toOrgid && targetBookTypeDyn.getLong("id") == filter.getLong("booktype")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u6838\u7b97\u7ec4\u7ec7\u3001\u6e90\u8d26\u7c3f\u7c7b\u578b\u4e0e\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7\u3001\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"AccountBalanceCompareFormPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

